/*
 * Decompiled with CFR 0.152.
 */
package com.seedfinding.latticg;

import com.seedfinding.latticg.math.component.BigFraction;
import com.seedfinding.latticg.math.component.BigMatrix;
import com.seedfinding.latticg.math.component.BigVector;
import com.seedfinding.latticg.math.lattice.LLL.LLL;
import com.seedfinding.latticg.math.lattice.LLL.Params;
import com.seedfinding.latticg.math.lattice.LLL.Result;
import com.seedfinding.latticg.math.lattice.enumeration.Enumerate;
import com.seedfinding.latticg.util.LCG;
import com.seedfinding.latticg.util.Mth;
import com.seedfinding.latticg.util.Rand;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.stream.LongStream;
import org.jetbrains.annotations.ApiStatus;

@ApiStatus.Internal
public class RandomReverser {
    private static final BigInteger MOD = BigInteger.valueOf(0x1000000000000L);
    private static final BigInteger MULT = BigInteger.valueOf(25214903917L);
    private BigMatrix lattice;
    private final ArrayList<Long> mins = new ArrayList();
    private final ArrayList<Long> maxes = new ArrayList();
    private final ArrayList<Long> callIndices = new ArrayList();
    private long currentCallIndex = 0L;
    private int dimensions = 0;
    private boolean verbose = false;
    private double successChance = 1.0;

    public LongStream findAllValidSeeds() {
        if (this.dimensions == 0) {
            return LongStream.range(0L, 0x1000000000000L);
        }
        this.createLattice();
        BigVector lower = new BigVector(this.dimensions);
        BigVector upper = new BigVector(this.dimensions);
        BigVector offset = new BigVector(this.dimensions);
        Rand rand = Rand.ofInternalSeed(0L);
        for (int i = 0; i < this.dimensions; ++i) {
            lower.set(i, new BigFraction(this.mins.get(i)));
            upper.set(i, new BigFraction(this.maxes.get(i)));
            offset.set(i, new BigFraction(rand.getSeed()));
            if (i == this.dimensions - 1) continue;
            rand.advance(this.callIndices.get(i + 1) - this.callIndices.get(i));
        }
        if (this.verbose) {
            System.out.println("Mins: " + lower);
            System.out.println("Maxes: " + upper);
            System.out.println("Offsets: " + offset);
        }
        LCG r = LCG.JAVA.combine(-this.callIndices.get(0).longValue());
        if (this.successChance != 1.0) {
            System.err.printf("Ignored approximately %.2e of all seeds %n", 1.0 - this.successChance);
        }
        return Enumerate.enumerate(this.lattice.transpose(), lower, upper, offset).map(vec -> vec.get(0)).map(BigFraction::getNumerator).mapToLong(BigInteger::longValue).map(r::nextSeed);
    }

    private void createLattice() {
        if (this.verbose) {
            System.out.println("Call Indices: " + this.callIndices);
        }
        if (this.mins.size() != this.dimensions || this.maxes.size() != this.dimensions || this.callIndices.size() != this.dimensions) {
            return;
        }
        BigInteger[] sideLengths = new BigInteger[this.dimensions];
        for (int i = 0; i < this.dimensions; ++i) {
            sideLengths[i] = BigInteger.valueOf(this.maxes.get(i) - this.mins.get(i) + 1L);
        }
        BigInteger lcm = BigInteger.ONE;
        for (int i = 0; i < this.dimensions; ++i) {
            lcm = Mth.lcm(lcm, sideLengths[i]);
        }
        BigMatrix scales = new BigMatrix(this.dimensions, this.dimensions);
        for (int i = 0; i < this.dimensions; ++i) {
            for (int j = 0; j < this.dimensions; ++j) {
                scales.set(i, j, BigFraction.ZERO);
            }
            scales.set(i, i, new BigFraction(lcm.divide(sideLengths[i])));
        }
        BigMatrix unscaledLattice = this.lattice;
        if (this.verbose) {
            System.out.println("Looking for points on:\n" + unscaledLattice.toPrettyString());
        }
        BigMatrix scaledLattice = unscaledLattice.multiply(scales);
        Params params = new Params().setDelta(Params.recommendedDelta).setDebug(false);
        if (this.verbose) {
            System.out.println("Reducing:\n" + scaledLattice.toPrettyString());
        }
        Result result = LLL.reduce(scaledLattice, params);
        if (this.verbose) {
            System.out.println("Found Reduced Scaled Basis:\n" + result.getReducedBasis().toPrettyString());
            System.out.println("Found Reduced Basis:\n" + result.getReducedBasis().multiply(scales.inverse()).toPrettyString());
        }
        this.lattice = result.getReducedBasis().multiply(scales.inverse());
    }

    private void addMeasuredSeed(long min, long max) {
        this.mins.add(min);
        this.maxes.add(max);
        ++this.dimensions;
        ++this.currentCallIndex;
        this.callIndices.add(this.currentCallIndex);
        BigMatrix newLattice = new BigMatrix(this.dimensions + 1, this.dimensions);
        if (this.dimensions != 1) {
            for (int row = 0; row < this.dimensions; ++row) {
                for (int col = 0; col < this.dimensions - 1; ++col) {
                    newLattice.set(row, col, this.lattice.get(row, col));
                }
            }
        }
        BigInteger tempMult = MULT.modPow(BigInteger.valueOf(this.callIndices.get(this.dimensions - 1) - this.callIndices.get(0)), MOD);
        newLattice.set(0, this.dimensions - 1, new BigFraction(tempMult));
        newLattice.set(this.dimensions, this.dimensions - 1, new BigFraction(MOD));
        this.lattice = newLattice;
    }

    private void addModuloMeasuredSeed(long min, long max, long mod) {
        long residue = 0x1000000000000L % mod;
        if (residue != 0L) {
            this.successChance *= 1.0 - (double)residue / 2.81474976710656E14;
            this.mins.add(0L);
            this.maxes.add(0x1000000000000L - residue);
            ++this.currentCallIndex;
            this.callIndices.add(this.currentCallIndex);
            this.mins.add(min);
            this.maxes.add(max);
            this.callIndices.add(this.currentCallIndex);
            this.dimensions += 2;
            BigMatrix newLattice = new BigMatrix(this.dimensions + 1, this.dimensions);
            if (this.dimensions != 2) {
                for (int row = 0; row < this.dimensions - 1; ++row) {
                    for (int col = 0; col < this.dimensions - 2; ++col) {
                        newLattice.set(row, col, this.lattice.get(row, col));
                    }
                }
            }
            BigInteger tempMult = MULT.modPow(BigInteger.valueOf(this.callIndices.get(this.dimensions - 1) - this.callIndices.get(0)), MOD);
            newLattice.set(0, this.dimensions - 2, new BigFraction(tempMult));
            newLattice.set(0, this.dimensions - 1, new BigFraction(tempMult));
            newLattice.set(this.dimensions - 1, this.dimensions - 1, new BigFraction(MOD));
            newLattice.set(this.dimensions - 1, this.dimensions - 2, new BigFraction(MOD));
            newLattice.set(this.dimensions, this.dimensions - 1, new BigFraction(mod));
            this.lattice = newLattice;
        } else {
            this.mins.add(min);
            this.maxes.add(max);
            ++this.dimensions;
            ++this.currentCallIndex;
            this.callIndices.add(this.currentCallIndex);
            BigMatrix newLattice = new BigMatrix(this.dimensions + 1, this.dimensions);
            if (this.dimensions != 1) {
                for (int row = 0; row < this.dimensions; ++row) {
                    for (int col = 0; col < this.dimensions - 1; ++col) {
                        newLattice.set(row, col, this.lattice.get(row, col));
                    }
                }
            } else if (!MOD.equals(BigInteger.valueOf(mod))) {
                System.err.println("First call not a bound on a seed. Junk output may be produced.");
            }
            BigInteger tempMult = MULT.modPow(BigInteger.valueOf(this.callIndices.get(this.dimensions - 1) - this.callIndices.get(0)), MOD);
            newLattice.set(0, this.dimensions - 1, new BigFraction(tempMult));
            newLattice.set(this.dimensions, this.dimensions - 1, new BigFraction(mod));
            this.lattice = newLattice;
        }
    }

    public void addUnmeasuredSeeds(long numSeeds) {
        this.currentCallIndex += numSeeds;
    }

    public void addNextIntCall(int n, int min, int max) {
        if ((n & -n) == n) {
            int log = Long.numberOfTrailingZeros(n);
            this.addMeasuredSeed((long)min * (1L << 48 - log), (long)(max + 1) * (1L << 48 - log) - 1L);
        } else {
            this.addModuloMeasuredSeed((long)min * 131072L, (long)max * 131072L | 0x1FFFFL, (long)n * 131072L);
        }
    }

    public void addNextIntCall(int min, int max) {
        this.addMeasuredSeed((long)min * 65536L, (long)(max + 1) * 65536L - 1L);
    }

    public void consumeNextIntCalls(int numCalls, int bound) {
        long residue = 0x1000000000000L % (131072L * (long)bound);
        if (residue != 0L) {
            this.successChance *= Math.pow(1.0 - (double)residue / 2.81474976710656E14, numCalls);
        }
        this.addUnmeasuredSeeds(numCalls);
    }

    public void addNextBooleanCall(boolean value) {
        if (value) {
            this.addNextIntCall(2, 1, 1);
        } else {
            this.addNextIntCall(2, 0, 0);
        }
    }

    public void consumeNextBooleanCalls(int numCalls) {
        this.addUnmeasuredSeeds(numCalls);
    }

    public void addNextFloatCall(float min, float max, boolean minInclusive, boolean maxInclusive) {
        float minInc = min;
        float maxInc = max;
        if (!minInclusive) {
            minInc = Math.nextUp(min);
        }
        if (maxInclusive) {
            maxInc = Math.nextUp(max);
        }
        long minLong = (long)StrictMath.ceil(minInc * 1.6777216E7f);
        long maxLong = (long)StrictMath.ceil(maxInc * 1.6777216E7f) - 1L;
        if (maxLong < minLong) {
            throw new IllegalArgumentException("call has no valid range");
        }
        long minSeed = minLong << 24;
        long maxSeed = maxLong << 24 | 0xFFFFFFL;
        this.addMeasuredSeed(minSeed, maxSeed);
    }

    public void addNextFloatCall(float min, float max) {
        this.addNextFloatCall(min, max, true, false);
    }

    public void consumeNextFloatCalls(int numCalls) {
        this.addUnmeasuredSeeds(numCalls);
    }

    public void addNextLongCall(long min, long max) {
        boolean minSignBit = (min & Integer.MIN_VALUE) != 0L;
        boolean maxSignBit = (max & Integer.MIN_VALUE) != 0L;
        long minFirstSeed = minSignBit ? (min >>> 32) + 1L << 16 : min >>> 32 << 16;
        long maxFirstSeed = maxSignBit ? ((max >>> 32) + 2L << 16) - 1L : ((max >>> 32) + 1L << 16) - 1L;
        this.addMeasuredSeed(minFirstSeed, maxFirstSeed);
        if (min >>> 32 == max >>> 32) {
            this.addMeasuredSeed((min & 0xFFFFFFFFL) << 16, ((max & 0xFFFFFFFFL) + 1L << 16) - 1L);
        } else {
            this.addUnmeasuredSeeds(1L);
        }
    }

    public void consumeNextLongCalls(int numCalls) {
        this.addUnmeasuredSeeds(2 * numCalls);
    }

    public void addNextDoubleCall(double min, double max, boolean minInclusive, boolean maxInclusive) {
        double minInc = min;
        double maxInc = max;
        if (!minInclusive) {
            minInc = Math.nextUp(min);
        }
        if (maxInclusive) {
            maxInc = Math.nextUp(max);
        }
        long minLong = (long)StrictMath.ceil(minInc * 9.007199254740992E15);
        long maxLong = (long)StrictMath.ceil(maxInc * 9.007199254740992E15) - 1L;
        if (maxLong < minLong) {
            throw new IllegalArgumentException("call has no valid range");
        }
        long minSeed1 = minLong >> 27 << 22;
        long maxSeed1 = maxLong >> 27 << 22 | 0x3FFFFFL;
        this.addMeasuredSeed(minSeed1, maxSeed1);
        if (minLong >>> 27 == maxLong >>> 27) {
            long minSeed2 = (minLong & 0x7FFFFFFL) << 21;
            long maxSeed2 = (maxLong & 0x7FFFFFFL) << 21 | 0x1FFFFFL;
            this.addMeasuredSeed(minSeed2, maxSeed2);
        } else {
            this.addUnmeasuredSeeds(1L);
        }
    }

    public void addNextDoubleCall(double min, double max) {
        this.addNextDoubleCall(min, max, true, false);
    }

    public void consumeNextDoubleCalls(int numCalls) {
        this.addUnmeasuredSeeds(2 * numCalls);
    }

    public void addModConstraint(long min, long max, long newMod) {
        this.addModuloMeasuredSeed(min, max, newMod);
    }

    public void setVerbose(boolean verbose) {
        this.verbose = verbose;
    }
}

