/*
 * Decompiled with CFR 0.152.
 */
package com.seedfinding.latticg.reversal;

import com.seedfinding.latticg.reversal.Program;
import com.seedfinding.latticg.reversal.calltype.CallType;
import com.seedfinding.latticg.util.LCG;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.ApiStatus;

@ApiStatus.Experimental
public class ProgramBuilder {
    private final LCG lcg;
    private final List<CallType<?>> calls = new ArrayList();
    private final List<Long> skips = new ArrayList<Long>();
    private long currentSkip = 0L;

    ProgramBuilder(LCG lcg) {
        this.lcg = lcg;
    }

    public ProgramBuilder add(CallType<?> call) {
        this.calls.add(call);
        this.skips.add(this.currentSkip);
        this.currentSkip = 0L;
        return this;
    }

    public ProgramBuilder skip(long steps) {
        this.currentSkip += steps;
        return this;
    }

    public Program build() {
        return new Program(this.lcg, this.calls, this.skips);
    }
}

