/*
 * Decompiled with CFR 0.152.
 */
package com.seedfinding.latticg.reversal;

import com.seedfinding.latticg.RandomReverser;
import com.seedfinding.latticg.reversal.Program;
import com.seedfinding.latticg.reversal.calltype.CallType;
import com.seedfinding.latticg.reversal.calltype.java.NextBooleanCall;
import com.seedfinding.latticg.reversal.calltype.java.NextDoubleCall;
import com.seedfinding.latticg.reversal.calltype.java.NextFloatCall;
import com.seedfinding.latticg.reversal.calltype.java.NextIntCall;
import com.seedfinding.latticg.reversal.calltype.java.NextLongCall;
import com.seedfinding.latticg.reversal.calltype.java.UnboundedNextIntCall;
import com.seedfinding.latticg.util.LCG;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.LongStream;
import org.jetbrains.annotations.ApiStatus;

public class ProgramInstance {
    private final Program program;
    private final List<Object> observations = new ArrayList<Object>();
    private int callIndex = 0;

    @ApiStatus.Internal
    protected ProgramInstance(Program program) {
        this.program = program;
    }

    public Program getProgram() {
        return this.program;
    }

    public <T> ProgramInstance add(Object value) {
        if (this.callIndex >= this.program.getCalls().size()) {
            throw new IndexOutOfBoundsException("Too many observations for the number of calls specified");
        }
        CallType<?> callType = this.program.getCalls().get(this.callIndex++);
        Object observation = callType.getType().cast(value);
        this.observations.add(observation);
        return this;
    }

    public LongStream reverse() {
        if (!LCG.JAVA.equals(this.program.getLcg())) {
            throw new IllegalStateException("Only the Java LCG is currently supported");
        }
        if (this.callIndex != this.program.getCalls().size()) {
            throw new IllegalStateException("Not all specified calls have been given observations");
        }
        RandomReverser reverser = new RandomReverser();
        if (this.program.isVerbose()) {
            reverser.setVerbose(true);
        }
        List<CallType<?>> calls = this.program.getCalls();
        List<Long> skips = this.program.getSkips();
        for (int i = 0; i < calls.size(); ++i) {
            int max;
            int min;
            int value;
            CallType<?> call = calls.get(i);
            Object observation = this.observations.get(i);
            reverser.addUnmeasuredSeeds(skips.get(i));
            if (call instanceof NextBooleanCall) {
                NextBooleanCall booleanCall = (NextBooleanCall)call;
                value = ((Boolean)observation).booleanValue();
                if (booleanCall.isInverted()) {
                    value = value == 0 ? 1 : 0;
                }
                reverser.addNextBooleanCall(value != 0);
                continue;
            }
            if (call instanceof NextDoubleCall) {
                double value2 = (Double)observation;
                reverser.addNextDoubleCall(value2, value2, true, true);
                continue;
            }
            if (call instanceof NextFloatCall) {
                float value3 = ((Float)observation).floatValue();
                reverser.addNextFloatCall(value3, value3, true, true);
                continue;
            }
            if (call instanceof NextIntCall) {
                NextIntCall intCall = (NextIntCall)call;
                value = (Integer)observation;
                reverser.addNextIntCall(intCall.getBound(), value, value);
                continue;
            }
            if (call instanceof UnboundedNextIntCall) {
                int value4 = (Integer)observation;
                reverser.addNextIntCall(value4, value4);
                continue;
            }
            if (call instanceof NextLongCall) {
                long value5 = (Long)observation;
                reverser.addNextLongCall(value5, value5);
                continue;
            }
            if (call instanceof NextFloatCall.FloatRange) {
                NextFloatCall.FloatRange floatRange = (NextFloatCall.FloatRange)call;
                value = ((Boolean)observation).booleanValue() ? 1 : 0;
                if (floatRange.isInverted()) {
                    int n = value = value == 0 ? 1 : 0;
                }
                if (value != 0) {
                    reverser.addNextFloatCall(((Float)floatRange.getMin()).floatValue(), ((Float)floatRange.getMax()).floatValue(), !floatRange.isMinStrict(), !floatRange.isMaxStrict());
                    continue;
                }
                reverser.addUnmeasuredSeeds(1L);
                continue;
            }
            if (call instanceof NextIntCall.IntRange) {
                NextIntCall.IntRange intRange = (NextIntCall.IntRange)call;
                value = ((Boolean)observation).booleanValue() ? 1 : 0;
                if (intRange.isInverted()) {
                    value = value == 0 ? 1 : 0;
                }
                min = (Integer)intRange.getMin();
                max = (Integer)intRange.getMax();
                if (intRange.isMinStrict()) {
                    ++min;
                }
                if (intRange.isMaxStrict()) {
                    --max;
                }
                if (value != 0) {
                    reverser.addNextIntCall(intRange.getBound(), min, max);
                    continue;
                }
                reverser.addUnmeasuredSeeds(1L);
                continue;
            }
            if (call instanceof UnboundedNextIntCall.IntRange) {
                UnboundedNextIntCall.IntRange intRange = (UnboundedNextIntCall.IntRange)call;
                value = ((Boolean)observation).booleanValue() ? 1 : 0;
                if (intRange.isInverted()) {
                    value = value == 0 ? 1 : 0;
                }
                min = (Integer)intRange.getMin();
                max = (Integer)intRange.getMax();
                if (intRange.isMinStrict()) {
                    ++min;
                }
                if (intRange.isMaxStrict()) {
                    --max;
                }
                if (value != 0) {
                    reverser.addNextIntCall(min, max);
                    continue;
                }
                reverser.addUnmeasuredSeeds(1L);
                continue;
            }
            if (call instanceof NextDoubleCall.DoubleRange) {
                NextDoubleCall.DoubleRange doubleRange = (NextDoubleCall.DoubleRange)call;
                value = ((Boolean)observation).booleanValue() ? 1 : 0;
                if (doubleRange.isInverted()) {
                    int n = value = value == 0 ? 1 : 0;
                }
                if (value != 0) {
                    reverser.addNextDoubleCall((Double)doubleRange.getMin(), (Double)doubleRange.getMax(), !doubleRange.isMinStrict(), !doubleRange.isMaxStrict());
                    continue;
                }
                reverser.addUnmeasuredSeeds(2L);
                continue;
            }
            if (call instanceof NextLongCall.LongRange) {
                NextLongCall.LongRange intRange = (NextLongCall.LongRange)call;
                value = ((Boolean)observation).booleanValue() ? 1 : 0;
                if (intRange.isInverted()) {
                    value = value == 0 ? 1 : 0;
                }
                long min2 = (Long)intRange.getMin();
                long max2 = (Long)intRange.getMax();
                if (intRange.isMinStrict()) {
                    ++min2;
                }
                if (intRange.isMaxStrict()) {
                    --max2;
                }
                if (value != 0) {
                    reverser.addNextLongCall(min2, max2);
                    continue;
                }
                reverser.addUnmeasuredSeeds(2L);
                continue;
            }
            throw new IllegalStateException("Unsupported call type: " + call.getClass().getName());
        }
        return reverser.findAllValidSeeds();
    }
}

