/*
 * Decompiled with CFR 0.152.
 */
package com.seedfinding.latticg.reversal.asm;

import com.seedfinding.latticg.reversal.asm.ParseException;
import com.seedfinding.latticg.reversal.asm.Token;
import com.seedfinding.latticg.util.Pair;
import java.io.IOException;
import java.io.StreamTokenizer;
import java.io.StringReader;
import java.io.UncheckedIOException;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.function.Supplier;
import java.util.regex.Pattern;
import org.jetbrains.annotations.ApiStatus;

@Deprecated
@ApiStatus.Internal
public final class StringParser {
    private final List<Token> tokens;
    private int cursor = 0;
    private static final Pattern HEX_VALUE_PATTERN = Pattern.compile("0[Xx][0-9a-fA-F]+");
    private static final Pattern BINARY_VALUE_PATTERN = Pattern.compile("0[Bb][01]+");
    private static final Pattern DECIMAL_VALUE_PATTERN = Pattern.compile("[0-9]+");

    private StringParser(List<Token> tokens) {
        this.tokens = tokens;
    }

    public static StringParser of(String text) {
        StreamTokenizer tokenizer = new StreamTokenizer(new StringReader(text));
        tokenizer.resetSyntax();
        tokenizer.wordChars(48, 57);
        tokenizer.wordChars(65, 90);
        tokenizer.wordChars(97, 122);
        tokenizer.wordChars(160, 255);
        tokenizer.wordChars(95, 95);
        tokenizer.wordChars(35, 35);
        tokenizer.whitespaceChars(0, 32);
        tokenizer.slashSlashComments(true);
        tokenizer.slashStarComments(true);
        ArrayList<Token> tokens = new ArrayList<Token>();
        try {
            int tk;
            while ((tk = tokenizer.nextToken()) != -1) {
                if (tk == -3) {
                    tokens.add(new Token(tokenizer.sval, tokenizer.lineno()));
                    continue;
                }
                tokens.add(new Token(String.valueOf((char)tk), tokenizer.lineno()));
            }
        }
        catch (IOException e) {
            throw new UncheckedIOException("Reading from StringReader", e);
        }
        return new StringParser(tokens);
    }

    public Token consume() {
        Token ret = this.peek().orElseThrow(this.eofException());
        ++this.cursor;
        return ret;
    }

    public void expectEof() {
        if (this.cursor != this.tokens.size()) {
            throw new ParseException("Expected EOF before '" + this.tokens.get(this.cursor).getText() + "' token", this.tokens.get(this.cursor));
        }
    }

    public Optional<Token> peek() {
        return this.cursor == this.tokens.size() ? Optional.empty() : Optional.of(this.tokens.get(this.cursor));
    }

    public Token peekNotEof() {
        return this.peek().orElseThrow(this.eofException());
    }

    public Token expect(String token) {
        Token consumed = this.consume();
        if (!consumed.getText().equals(token)) {
            throw new ParseException("Expected '" + token + "' before '" + consumed.getText() + "' token", consumed);
        }
        return consumed;
    }

    private Supplier<ParseException> eofException() {
        return () -> new ParseException("EOF token reached early", this.tokens.isEmpty() ? null : this.tokens.get(this.tokens.size() - 1));
    }

    private Token consumeNumberToken() {
        StringBuilder number = new StringBuilder();
        Token firstToken = this.peekNotEof();
        String sign = firstToken.getText();
        if (sign.equals("+") || sign.equals("-")) {
            this.consume();
            number.append(sign);
        }
        String firstPart = this.consume().getText();
        number.append(firstPart);
        if (firstPart.startsWith("0x") || firstPart.startsWith("0X")) {
            if (!HEX_VALUE_PATTERN.matcher(firstPart).matches()) {
                throw new ParseException("Invalid number '" + number + "'", firstToken);
            }
        } else if (firstPart.startsWith("0b") || firstPart.startsWith("0B")) {
            if (!BINARY_VALUE_PATTERN.matcher(firstPart).matches()) {
                throw new ParseException("Invalid number '" + number + "'", firstToken);
            }
        } else if (firstPart.equals(".")) {
            String lastPart = this.consume().getText();
            number.append(lastPart);
            if (!DECIMAL_VALUE_PATTERN.matcher(lastPart).matches()) {
                throw new ParseException("Invalid number '" + number + "'", firstToken);
            }
        } else {
            if (!DECIMAL_VALUE_PATTERN.matcher(firstPart).matches()) {
                throw new ParseException("Invalid number '" + number + "'", firstToken);
            }
            if (this.peek().filter(token -> token.getText().equals(".")).isPresent()) {
                this.consume();
                number.append(".");
                this.peek().filter(token -> DECIMAL_VALUE_PATTERN.matcher(token.getText()).matches()).ifPresent(token -> {
                    this.consume();
                    number.append(token.getText());
                });
            }
        }
        return new Token(number.toString(), firstToken.getLine());
    }

    public Pair<BigDecimal, Token> consumeDecimal() {
        Token token = this.consumeNumberToken();
        if (token.getText().startsWith("0x") || token.getText().startsWith("0X")) {
            return new Pair<BigDecimal, Token>(new BigDecimal(new BigInteger(token.getText().substring(2), 16)), token);
        }
        if (token.getText().startsWith("0b") || token.getText().startsWith("0B")) {
            return new Pair<BigDecimal, Token>(new BigDecimal(new BigInteger(token.getText().substring(2), 2)), token);
        }
        return new Pair<BigDecimal, Token>(new BigDecimal(token.getText()), token);
    }

    public Pair<BigInteger, Token> consumeInteger() {
        Token token = this.consumeNumberToken();
        if (token.getText().startsWith("0x") || token.getText().startsWith("0X")) {
            return new Pair<BigInteger, Token>(new BigInteger(token.getText().substring(2), 16), token);
        }
        if (token.getText().startsWith("0b") || token.getText().startsWith("0B")) {
            return new Pair<BigInteger, Token>(new BigInteger(token.getText().substring(2), 2), token);
        }
        try {
            return new Pair<BigInteger, Token>(new BigInteger(token.getText()), token);
        }
        catch (NumberFormatException e) {
            throw new ParseException("Invalid number '" + token.getText() + "'", token);
        }
    }

    public Class<?> consumeClass() {
        Token firstToken = this.consume();
        switch (firstToken.getText()) {
            case "boolean": {
                return Boolean.TYPE;
            }
            case "char": {
                return Character.TYPE;
            }
            case "double": {
                return Double.TYPE;
            }
            case "float": {
                return Float.TYPE;
            }
            case "int": {
                return Integer.TYPE;
            }
            case "long": {
                return Long.TYPE;
            }
            case "short": {
                return Short.TYPE;
            }
            case "void": {
                return Void.TYPE;
            }
        }
        StringBuilder className = new StringBuilder(firstToken.getText());
        while (this.peek().filter(token -> token.getText().equals(".")).isPresent()) {
            this.expect(".");
            className.append(".").append(this.consume().getText());
        }
        String javaClass = className.toString().replace('#', '$');
        try {
            return Class.forName(javaClass);
        }
        catch (ClassNotFoundException e) {
            throw new ParseException("Class not found: '" + javaClass + "'", firstToken);
        }
    }
}

