/*
 * Decompiled with CFR 0.152.
 */
package de.scribble.lp.killtherng;

import de.scribble.lp.killtherng.KillTheRNG;
import de.scribble.lp.killtherng.custom.CustomRandom;
import java.util.HashMap;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public class UltimateRandomness {
    public HashMap<String, CustomRandom> REGISTRY = new HashMap();

    protected CustomRandom registerRandom(String name, String description, boolean enabled, boolean client) {
        CustomRandom newRandom = new CustomRandom(name, description, enabled, client);
        this.REGISTRY.put(name, newRandom);
        return newRandom;
    }

    public void setSeedAll(long seed) {
        this.REGISTRY.forEach((name, rand) -> rand.setSeed(seed));
    }

    public CustomRandom getRandom(String name) {
        return this.REGISTRY.get(name);
    }

    public Set<String> getAllKeys() {
        return this.REGISTRY.keySet();
    }

    public boolean exists(String randomName) {
        return this.getRandom(randomName) != null;
    }

    public long nextSeed() {
        return this.nextSeed(1);
    }

    public long nextSeed(int step) {
        KillTheRNG.commonRandom.GlobalServer.advance(step);
        long seed = KillTheRNG.commonRandom.GlobalServer.getSeed();
        KillTheRNG.commonRandom.REGISTRY.forEach((name, rand) -> {
            if (rand.getName().startsWith("Global")) {
                return;
            }
            rand.setSeed(seed, false);
        });
        return seed;
    }

    public static List<String> getNames() {
        List<String> mergedRegistry = Stream.concat(KillTheRNG.commonRandom.getAllKeys().stream(), KillTheRNG.clientRandom.getAllKeys().stream()).collect(Collectors.toList());
        return mergedRegistry;
    }

    public static CustomRandom getRandomBothSides(String name) {
        CustomRandom rand = KillTheRNG.commonRandom.getRandom(name);
        if (rand == null) {
            rand = KillTheRNG.clientRandom.getRandom(name);
        }
        return rand;
    }
}

