/*
 * Decompiled with CFR 0.152.
 */
package de.scribble.lp.killtherng.commands;

import com.google.common.collect.ImmutableList;
import com.mojang.realmsclient.gui.ChatFormatting;
import de.scribble.lp.killtherng.KillTheRNG;
import de.scribble.lp.killtherng.UltimateRandomness;
import de.scribble.lp.killtherng.custom.CustomRandom;
import de.scribble.lp.killtherng.networking.ChangeSeedPacket;
import de.scribble.lp.killtherng.networking.SeedInfoPacket;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.EntityPlayerSP;
import net.minecraft.command.CommandBase;
import net.minecraft.command.CommandException;
import net.minecraft.command.ICommand;
import net.minecraft.command.ICommandSender;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import net.minecraft.util.text.event.ClickEvent;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class CommandKillTheRNG
extends CommandBase {
    public String func_71517_b() {
        return "killtherng";
    }

    public String func_71518_a(ICommandSender sender) {
        return "/killtherng <RNGName> <seed>";
    }

    public List<String> func_71514_a() {
        return ImmutableList.of((Object)"ktrng");
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void func_184881_a(MinecraftServer server, ICommandSender sender, String[] args) throws CommandException {
        if (!(sender instanceof EntityPlayer)) return;
        if (args.length == 0) {
            sender.func_145747_a((ITextComponent)new TextComponentString(ChatFormatting.GOLD + "-----------------------Help-----------------------\n" + ChatFormatting.RESET + "This mod transforms all randomness in the game to something predictable. \nJust like a Minecraft world, every randomvariable has a 'seed'.\nBased on this seed, a random number will be generated, when the game needs randomness to occur.\nThe game generates a new number and uses that for it's new seed and for its number.\nThis makes it so if you have a start seed, every number generated after that will be the same\n\n" + String.format("%s/killtherng %s<seed>%s - Set the seed for every RNG value\n", ChatFormatting.AQUA, ChatFormatting.GREEN, ChatFormatting.RESET) + String.format("%s/killtherng %s<RNG-Value> %s<seed>%s - Set the RNG seed for that value\n", ChatFormatting.AQUA, ChatFormatting.YELLOW, ChatFormatting.GREEN, ChatFormatting.RESET) + ChatFormatting.GRAY + "Current Global Seed: " + ChatFormatting.YELLOW + KillTheRNG.commonRandom.getRandom("GlobalServer").getSeed()));
            return;
        }
        CustomRandom rand = null;
        rand = UltimateRandomness.getRandomBothSides(args[0]);
        if (this.isNumeric(args[0])) {
            long seed = Long.parseLong(args[0]);
            KillTheRNG.commonRandom.setSeedAll(seed);
            KillTheRNG.NETWORK.sendToAll((IMessage)new ChangeSeedPacket(seed));
            CommandKillTheRNG.func_152373_a((ICommandSender)sender, (ICommand)this, (String)"Set seed %s for everything", (Object[])new Object[]{args[0]});
            return;
        } else {
            if (rand == null) throw new CommandException("Can't understand what you just typed in...", new Object[0]);
            if (args.length == 1) {
                if (rand.isClient()) {
                    KillTheRNG.NETWORK.sendTo((IMessage)new SeedInfoPacket(args[0]), (EntityPlayerMP)sender);
                    return;
                } else {
                    KillTheRNG.NETWORK.sendTo((IMessage)new SeedInfoPacket(rand), (EntityPlayerMP)sender);
                }
                return;
            }
            if (!this.isNumeric(args[1])) throw new CommandException("Can't understand what you just typed in...", new Object[0]);
            long seed = Long.parseLong(args[1]);
            rand.setSeed(seed);
            KillTheRNG.NETWORK.sendToAll((IMessage)new ChangeSeedPacket(args[0], seed));
            CommandKillTheRNG.func_152373_a((ICommandSender)sender, (ICommand)this, (String)"Set seed %s for %s", (Object[])new Object[]{args[1], args[0]});
        }
    }

    @SideOnly(value=Side.CLIENT)
    public static void sendHelp(RandomData data) {
        EntityPlayerSP sender = Minecraft.func_71410_x().field_71439_g;
        TextComponentString seedTextComponent = new TextComponentString(ChatFormatting.GRAY + "Current Seed: " + ChatFormatting.YELLOW + data.getSeed());
        String style = "/killtherng " + data.getName() + " " + data.getSeed();
        seedTextComponent.func_150256_b().func_150241_a(new ClickEvent(ClickEvent.Action.SUGGEST_COMMAND, style));
        sender.func_145747_a((ITextComponent)new TextComponentString(ChatFormatting.GOLD + "-------------" + data.getName() + "-------------"));
        sender.func_145747_a((ITextComponent)new TextComponentString(data.getDescription()));
        sender.func_145747_a((ITextComponent)new TextComponentString(""));
        if (!data.isEnabled()) {
            sender.func_145747_a((ITextComponent)new TextComponentString(ChatFormatting.RED + "This variable has been disabled, since it causes bugs or softlocks if it is not random."));
            sender.func_145747_a((ITextComponent)new TextComponentString(ChatFormatting.RED + "Setting a seed will not do anything, but you can still view some information"));
        }
        sender.func_145747_a((ITextComponent)seedTextComponent);
        sender.func_145747_a((ITextComponent)new TextComponentString(ChatFormatting.DARK_GRAY + "The random variable has been called " + data.getTimescalled() + " times"));
        sender.func_145747_a((ITextComponent)new TextComponentString(ChatFormatting.DARK_GRAY + (data.isClient() ? "Side: CLIENT" : "Side: SERVER")));
    }

    public List<String> func_184883_a(MinecraftServer server, ICommandSender sender, String[] args, BlockPos targetPos) {
        if (args.length == 1) {
            return CommandKillTheRNG.func_175762_a((String[])args, UltimateRandomness.getNames());
        }
        if (UltimateRandomness.getRandomBothSides(args[0]) != null) {
            return CommandKillTheRNG.func_71530_a((String[])args, (String[])new String[]{"help"});
        }
        return super.func_184883_a(server, sender, args, targetPos);
    }

    private boolean isNumeric(String strNum) {
        if (strNum == null) {
            return false;
        }
        try {
            long l = Long.parseLong(strNum);
        }
        catch (NumberFormatException nfe) {
            return false;
        }
        return true;
    }

    private boolean isBoolean(String strNum) {
        return strNum.equalsIgnoreCase("true") || strNum.equalsIgnoreCase("false");
    }

    public static class RandomData {
        private String name;
        private long seed;
        private String description;
        private boolean enabled;
        private long timescalled;
        private boolean client;

        public RandomData(CustomRandom rand) {
            this.name = rand.getName();
            this.seed = rand.getSeed();
            this.description = rand.getDescription();
            this.enabled = rand.isEnabled();
            this.timescalled = rand.getTimesCalled();
            this.client = rand.isClient();
        }

        public RandomData(CustomRandom rand, long seed, long timescalled, boolean enabled) {
            this.name = rand.getName();
            this.seed = seed;
            this.description = rand.getDescription();
            this.enabled = enabled;
            this.timescalled = timescalled;
            this.client = rand.isClient();
        }

        public String getName() {
            return this.name;
        }

        public long getSeed() {
            return this.seed;
        }

        public String getDescription() {
            return this.description;
        }

        public boolean isEnabled() {
            return this.enabled;
        }

        public long getTimescalled() {
            return this.timescalled;
        }

        public boolean isClient() {
            return this.client;
        }
    }
}

