/*
 * Decompiled with CFR 0.152.
 */
package de.scribble.lp.killtherng.custom;

import de.scribble.lp.killtherng.KillTheRNG;
import java.util.Random;
import kaptainwutax.seedutils.lcg.LCG;
import kaptainwutax.seedutils.rand.CombinedJRand;
import kaptainwutax.seedutils.rand.JRand;

public class CustomRandom
extends Random {
    private static final long serialVersionUID = -2682222387413311282L;
    private String name;
    private String description;
    private long timesCalled = 0L;
    private boolean enabled;
    private boolean client;
    private boolean fired;
    private JRand jrand = new JRand(0L);

    public CustomRandom(String name, String description, boolean enabled, boolean client) {
        super(0L);
        this.name = name;
        this.description = description;
        this.enabled = enabled;
        this.client = client;
    }

    @Override
    public void setSeed(long seedIn) {
        this.timesCalled = 0L;
        super.setSeed(seedIn ^ 0x5DEECE66DL);
    }

    public void setSeed(long seedIn, boolean shouldIncrease) {
        if (shouldIncrease) {
            ++this.timesCalled;
        } else {
            this.fired = false;
        }
        super.setSeed(seedIn ^ 0x5DEECE66DL);
    }

    public long getSeed() {
        long saved = this.timesCalled;
        long seed = CustomRandom.reverse(super.nextLong()) ^ 0x5DEECE66DL;
        super.setSeed(seed);
        this.timesCalled = saved;
        return seed ^ 0x5DEECE66DL;
    }

    public static long reverse(long in) {
        return (7847617L * (24667315L * (in >>> 32) + 18218081L * (in & 0xFFFFFFFFL) + 67552711L >> 32) - 18218081L * (-4824621L * (in >>> 32) + 7847617L * (in & 0xFFFFFFFFL) + 7847617L >> 32) - 11L) * 246154705703781L & 0xFFFFFFFFFFFFL;
    }

    public String getName() {
        return this.name;
    }

    public String getDescription() {
        return this.description;
    }

    public long getTimesCalled() {
        return this.timesCalled;
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public boolean isClient() {
        return this.client;
    }

    @Override
    public long nextLong() {
        ++this.timesCalled;
        long seedstored = this.getSeed();
        long value = super.nextLong();
        this.fireEvent(seedstored, Long.toString(value));
        if (KillTheRNG.mode.isNotChangeSeed() && !this.name.startsWith("Global")) {
            this.setSeed(seedstored, false);
        }
        return value;
    }

    @Override
    public double nextDouble() {
        ++this.timesCalled;
        long seedstored = this.getSeed();
        double value = super.nextDouble();
        this.fireEvent(seedstored, Double.toString(value));
        if (KillTheRNG.mode.isNotChangeSeed()) {
            this.setSeed(seedstored, false);
        }
        return value;
    }

    @Override
    public boolean nextBoolean() {
        ++this.timesCalled;
        long seedstored = this.getSeed();
        boolean value = super.nextBoolean();
        this.fireEvent(seedstored, Boolean.toString(value));
        if (KillTheRNG.mode.isNotChangeSeed()) {
            this.setSeed(seedstored, false);
        }
        return value;
    }

    @Override
    public int nextInt() {
        ++this.timesCalled;
        long seedstored = this.getSeed();
        int value = super.nextInt();
        this.fireEvent(seedstored, Integer.toString(value));
        if (KillTheRNG.mode.isNotChangeSeed()) {
            this.setSeed(seedstored, false);
        }
        return value;
    }

    @Override
    public int nextInt(int bound) {
        ++this.timesCalled;
        long seedstored = this.getSeed();
        int value = super.nextInt(bound);
        this.fireEvent(seedstored, Integer.toString(value));
        if (KillTheRNG.mode.isNotChangeSeed()) {
            this.setSeed(seedstored, false);
        }
        return value;
    }

    @Override
    public float nextFloat() {
        ++this.timesCalled;
        long seedstored = this.getSeed();
        float value = super.nextFloat();
        this.fireEvent(seedstored, Float.toString(value));
        if (KillTheRNG.mode.isNotChangeSeed()) {
            this.setSeed(seedstored, false);
        }
        return value;
    }

    @Override
    public void nextBytes(byte[] bytes) {
        ++this.timesCalled;
        long seedstored = this.getSeed();
        super.nextBytes(bytes);
        this.fireEvent(seedstored, "");
        if (KillTheRNG.mode.isNotChangeSeed()) {
            this.setSeed(seedstored, false);
        }
    }

    @Override
    public double nextGaussian() {
        ++this.timesCalled;
        long seedstored = this.getSeed();
        double value = 0.0;
        if (KillTheRNG.mode.isNotChangeSeed()) {
            this.jrand.setSeed(seedstored);
            value = this.jrand.nextGaussian();
        } else {
            value = super.nextGaussian();
        }
        this.fireEvent(seedstored, Double.toString(value));
        return value;
    }

    public void advance() {
        this.advance(1L);
    }

    public void advance(long i) {
        JRand thing = JRand.ofInternalSeed(this.getSeed());
        thing.advance(i);
        this.setSeed(thing.getSeed());
    }

    public long getSeedAt(int steps) {
        CombinedJRand thing = new JRand(this.getSeed()).combine(steps);
        return thing.getSeed();
    }

    public long steps(CustomRandom random) {
        return LCG.JAVA.distance(this.getSeed(), random.getSeed());
    }

    public static long steps(CustomRandom random1, CustomRandom random2) {
        return LCG.JAVA.distance(random1.getSeed(), random2.getSeed());
    }

    public String toString() {
        return this.name + ": " + this.enabled;
    }

    public boolean equals(Object obj) {
        if (obj instanceof CustomRandom) {
            CustomRandom custom = (CustomRandom)obj;
            return custom.name.equals(this.name);
        }
        return super.equals(obj);
    }

    private void fireEvent(long seedstored, String value) {
        if (!this.fired) {
            this.fired = true;
            KillTheRNG.annotations.fireRandomnessEvents(this.name, seedstored, value);
        }
    }
}

