/*
 * Decompiled with CFR 0.152.
 */
package de.scribble.lp.killtherng.networking;

import com.mojang.realmsclient.gui.ChatFormatting;
import de.scribble.lp.killtherng.KillTheRNG;
import de.scribble.lp.killtherng.UltimateRandomness;
import de.scribble.lp.killtherng.UltimateRandomnessClient;
import de.scribble.lp.killtherng.UltimateRandomnessCommon;
import de.scribble.lp.killtherng.custom.CustomRandom;
import io.netty.buffer.ByteBuf;
import java.nio.charset.StandardCharsets;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.network.simpleimpl.IMessageHandler;
import net.minecraftforge.fml.common.network.simpleimpl.MessageContext;

public class ChangeSeedPacket
implements IMessage {
    private long seed;
    private String name;

    @Deprecated
    public ChangeSeedPacket() {
    }

    public ChangeSeedPacket(long seed) {
        this.seed = seed;
        this.name = "";
    }

    public ChangeSeedPacket(String name, long seed) {
        this.seed = seed;
        this.name = name;
    }

    public void fromBytes(ByteBuf buf) {
        this.seed = buf.readLong();
        int length = buf.readInt();
        this.name = (String)buf.readCharSequence(length, StandardCharsets.UTF_8);
    }

    public void toBytes(ByteBuf buf) {
        buf.writeLong(this.seed);
        buf.writeInt(this.name.length());
        buf.writeCharSequence((CharSequence)this.name, StandardCharsets.UTF_8);
    }

    public static class ChangeSeedPacketHandler
    implements IMessageHandler<ChangeSeedPacket, IMessage> {
        public IMessage onMessage(ChangeSeedPacket message, MessageContext ctx) {
            if (ctx.side.isServer()) {
                UltimateRandomnessCommon commonrandom = KillTheRNG.commonRandom;
                if (message.name.isEmpty()) {
                    commonrandom.setSeedAll(message.seed);
                    KillTheRNG.NETWORK.sendToAll((IMessage)message);
                } else {
                    CustomRandom randomToChange = UltimateRandomness.getRandomBothSides(message.name);
                    if (randomToChange != null) {
                        if (randomToChange.isClient()) {
                            KillTheRNG.NETWORK.sendToAll((IMessage)message);
                        } else {
                            randomToChange.setSeed(message.seed);
                        }
                    } else {
                        ctx.getServerHandler().field_147369_b.func_145747_a((ITextComponent)new TextComponentString(ChatFormatting.RED + "The specified random doesn't exist: " + message.name));
                    }
                }
            } else {
                UltimateRandomnessClient clientrandom = KillTheRNG.clientRandom;
                if (message.name.isEmpty()) {
                    clientrandom.setSeedAll(message.seed);
                } else {
                    clientrandom.getRandom(message.name).setSeed(message.seed);
                }
            }
            return null;
        }
    }
}

