/*
 * Decompiled with CFR 0.152.
 */
package de.scribble.lp.killtherng.networking;

import com.mojang.realmsclient.gui.ChatFormatting;
import de.scribble.lp.killtherng.KillTheRNG;
import de.scribble.lp.killtherng.UltimateRandomness;
import de.scribble.lp.killtherng.commands.CommandKillTheRNG;
import de.scribble.lp.killtherng.custom.CustomRandom;
import io.netty.buffer.ByteBuf;
import java.nio.charset.StandardCharsets;
import net.minecraft.client.Minecraft;
import net.minecraft.util.text.ChatType;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.network.simpleimpl.IMessageHandler;
import net.minecraftforge.fml.common.network.simpleimpl.MessageContext;

public class SeedInfoPacket
implements IMessage {
    private boolean client = false;
    private String name;
    private long timesCalled;
    private long seed;
    private boolean enabled;

    public SeedInfoPacket() {
    }

    public SeedInfoPacket(String name) {
        this.name = name;
        this.client = true;
    }

    public SeedInfoPacket(CustomRandom rand) {
        this.name = rand.getName();
        this.timesCalled = rand.getTimesCalled();
        this.seed = rand.getSeed();
        this.enabled = rand.isEnabled();
    }

    public void fromBytes(ByteBuf buf) {
        int length = buf.readInt();
        this.name = (String)buf.readCharSequence(length, StandardCharsets.UTF_8);
        this.client = buf.readBoolean();
        if (!this.client) {
            this.timesCalled = buf.readLong();
            this.seed = buf.readLong();
            this.enabled = buf.readBoolean();
        }
    }

    public void toBytes(ByteBuf buf) {
        buf.writeInt(this.name.length());
        buf.writeCharSequence((CharSequence)this.name, StandardCharsets.UTF_8);
        buf.writeBoolean(this.client);
        if (!this.client) {
            buf.writeLong(this.timesCalled);
            buf.writeLong(this.seed);
            buf.writeBoolean(this.enabled);
        }
    }

    public static class SeedInfoPacketHandler
    implements IMessageHandler<SeedInfoPacket, IMessage> {
        public IMessage onMessage(SeedInfoPacket message, MessageContext ctx) {
            if (ctx.side.isServer()) {
                if (message.client) {
                    CustomRandom inforand = UltimateRandomness.getRandomBothSides(message.name);
                    if (!inforand.isClient()) {
                        KillTheRNG.NETWORK.sendTo((IMessage)new SeedInfoPacket(inforand), ctx.getServerHandler().field_147369_b);
                    } else {
                        KillTheRNG.NETWORK.sendTo((IMessage)message, ctx.getServerHandler().field_147369_b);
                    }
                }
            } else if (ctx.side.isClient()) {
                CommandKillTheRNG.RandomData data = null;
                if (message.client) {
                    CustomRandom randToDisplay = KillTheRNG.clientRandom.getRandom(message.name);
                    if (randToDisplay != null) {
                        data = new CommandKillTheRNG.RandomData(randToDisplay);
                    }
                } else {
                    CustomRandom randToDisplay = UltimateRandomness.getRandomBothSides(message.name);
                    if (randToDisplay != null) {
                        data = new CommandKillTheRNG.RandomData(randToDisplay, message.seed, message.timesCalled, message.enabled);
                    }
                }
                if (data != null) {
                    CommandKillTheRNG.sendHelp(data);
                } else {
                    Minecraft.func_71410_x().field_71456_v.func_191742_a(ChatType.CHAT, (ITextComponent)new TextComponentString(ChatFormatting.RED + "The randomness you specified doesn't exist"));
                }
            }
            return null;
        }
    }
}

