/*
 * Decompiled with CFR 0.152.
 */
package de.scribble.lp.killtherng.repack.com.fasterxml.jackson.databind.ser.std;

import de.scribble.lp.killtherng.repack.com.fasterxml.jackson.core.JsonGenerator;
import de.scribble.lp.killtherng.repack.com.fasterxml.jackson.databind.SerializerProvider;
import de.scribble.lp.killtherng.repack.com.fasterxml.jackson.databind.annotation.JacksonStdImpl;
import de.scribble.lp.killtherng.repack.com.fasterxml.jackson.databind.ser.std.DateTimeSerializerBase;
import java.io.IOException;
import java.text.DateFormat;
import java.util.Date;

@JacksonStdImpl
public class DateSerializer
extends DateTimeSerializerBase<Date> {
    public static final DateSerializer instance = new DateSerializer();

    public DateSerializer() {
        this(null, null);
    }

    public DateSerializer(Boolean useTimestamp, DateFormat customFormat) {
        super(Date.class, useTimestamp, customFormat);
    }

    public DateSerializer withFormat(Boolean timestamp, DateFormat customFormat) {
        return new DateSerializer(timestamp, customFormat);
    }

    @Override
    protected long _timestamp(Date value) {
        return value == null ? 0L : value.getTime();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void serialize(Date value, JsonGenerator gen, SerializerProvider provider) throws IOException {
        if (this._asTimestamp(provider)) {
            gen.writeNumber(this._timestamp(value));
        } else if (this._customFormat != null) {
            DateFormat dateFormat = this._customFormat;
            synchronized (dateFormat) {
                gen.writeString(this._customFormat.format(value));
            }
        } else {
            provider.defaultSerializeDateValue(value, gen);
        }
    }
}

