/*
 * Decompiled with CFR 0.152.
 */
package de.scribble.lp.killtherng.repack.com.fasterxml.jackson.databind.ser.std;

import de.scribble.lp.killtherng.repack.com.fasterxml.jackson.annotation.JsonFormat;
import de.scribble.lp.killtherng.repack.com.fasterxml.jackson.annotation.JsonInclude;
import de.scribble.lp.killtherng.repack.com.fasterxml.jackson.core.JsonGenerator;
import de.scribble.lp.killtherng.repack.com.fasterxml.jackson.core.JsonParser;
import de.scribble.lp.killtherng.repack.com.fasterxml.jackson.databind.AnnotationIntrospector;
import de.scribble.lp.killtherng.repack.com.fasterxml.jackson.databind.BeanProperty;
import de.scribble.lp.killtherng.repack.com.fasterxml.jackson.databind.JavaType;
import de.scribble.lp.killtherng.repack.com.fasterxml.jackson.databind.JsonMappingException;
import de.scribble.lp.killtherng.repack.com.fasterxml.jackson.databind.JsonNode;
import de.scribble.lp.killtherng.repack.com.fasterxml.jackson.databind.JsonSerializer;
import de.scribble.lp.killtherng.repack.com.fasterxml.jackson.databind.SerializationFeature;
import de.scribble.lp.killtherng.repack.com.fasterxml.jackson.databind.SerializerProvider;
import de.scribble.lp.killtherng.repack.com.fasterxml.jackson.databind.introspect.AnnotatedMember;
import de.scribble.lp.killtherng.repack.com.fasterxml.jackson.databind.jsonFormatVisitors.JsonArrayFormatVisitor;
import de.scribble.lp.killtherng.repack.com.fasterxml.jackson.databind.jsonFormatVisitors.JsonFormatTypes;
import de.scribble.lp.killtherng.repack.com.fasterxml.jackson.databind.jsonFormatVisitors.JsonFormatVisitable;
import de.scribble.lp.killtherng.repack.com.fasterxml.jackson.databind.jsonFormatVisitors.JsonFormatVisitorWrapper;
import de.scribble.lp.killtherng.repack.com.fasterxml.jackson.databind.jsonFormatVisitors.JsonIntegerFormatVisitor;
import de.scribble.lp.killtherng.repack.com.fasterxml.jackson.databind.jsonFormatVisitors.JsonNumberFormatVisitor;
import de.scribble.lp.killtherng.repack.com.fasterxml.jackson.databind.jsonFormatVisitors.JsonStringFormatVisitor;
import de.scribble.lp.killtherng.repack.com.fasterxml.jackson.databind.jsonFormatVisitors.JsonValueFormat;
import de.scribble.lp.killtherng.repack.com.fasterxml.jackson.databind.jsonschema.SchemaAware;
import de.scribble.lp.killtherng.repack.com.fasterxml.jackson.databind.node.JsonNodeFactory;
import de.scribble.lp.killtherng.repack.com.fasterxml.jackson.databind.node.ObjectNode;
import de.scribble.lp.killtherng.repack.com.fasterxml.jackson.databind.ser.FilterProvider;
import de.scribble.lp.killtherng.repack.com.fasterxml.jackson.databind.ser.PropertyFilter;
import de.scribble.lp.killtherng.repack.com.fasterxml.jackson.databind.ser.std.StdDelegatingSerializer;
import de.scribble.lp.killtherng.repack.com.fasterxml.jackson.databind.util.ClassUtil;
import de.scribble.lp.killtherng.repack.com.fasterxml.jackson.databind.util.Converter;
import java.io.IOException;
import java.io.Serializable;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Type;

public abstract class StdSerializer<T>
extends JsonSerializer<T>
implements JsonFormatVisitable,
SchemaAware,
Serializable {
    private static final Object CONVERTING_CONTENT_CONVERTER_LOCK = new Object();
    private static final long serialVersionUID = 1L;
    protected final Class<T> _handledType;

    protected StdSerializer(Class<T> t) {
        this._handledType = t;
    }

    protected StdSerializer(JavaType type) {
        this._handledType = type.getRawClass();
    }

    protected StdSerializer(Class<?> t, boolean dummy) {
        this._handledType = t;
    }

    protected StdSerializer(StdSerializer<?> src) {
        this._handledType = src._handledType;
    }

    @Override
    public Class<T> handledType() {
        return this._handledType;
    }

    @Override
    public abstract void serialize(T var1, JsonGenerator var2, SerializerProvider var3) throws IOException;

    @Override
    public void acceptJsonFormatVisitor(JsonFormatVisitorWrapper visitor, JavaType typeHint) throws JsonMappingException {
        visitor.expectAnyFormat(typeHint);
    }

    @Override
    public JsonNode getSchema(SerializerProvider provider, Type typeHint) throws JsonMappingException {
        return this.createSchemaNode("string");
    }

    @Override
    public JsonNode getSchema(SerializerProvider provider, Type typeHint, boolean isOptional) throws JsonMappingException {
        ObjectNode schema = (ObjectNode)this.getSchema(provider, typeHint);
        if (!isOptional) {
            schema.put("required", !isOptional);
        }
        return schema;
    }

    protected ObjectNode createObjectNode() {
        return JsonNodeFactory.instance.objectNode();
    }

    protected ObjectNode createSchemaNode(String type) {
        ObjectNode schema = this.createObjectNode();
        schema.put("type", type);
        return schema;
    }

    protected ObjectNode createSchemaNode(String type, boolean isOptional) {
        ObjectNode schema = this.createSchemaNode(type);
        if (!isOptional) {
            schema.put("required", !isOptional);
        }
        return schema;
    }

    protected void visitStringFormat(JsonFormatVisitorWrapper visitor, JavaType typeHint) throws JsonMappingException {
        if (visitor != null) {
            visitor.expectStringFormat(typeHint);
        }
    }

    protected void visitStringFormat(JsonFormatVisitorWrapper visitor, JavaType typeHint, JsonValueFormat format) throws JsonMappingException {
        JsonStringFormatVisitor v2;
        if (visitor != null && (v2 = visitor.expectStringFormat(typeHint)) != null) {
            v2.format(format);
        }
    }

    protected void visitIntFormat(JsonFormatVisitorWrapper visitor, JavaType typeHint, JsonParser.NumberType numberType) throws JsonMappingException {
        JsonIntegerFormatVisitor v2;
        if (visitor != null && (v2 = visitor.expectIntegerFormat(typeHint)) != null && numberType != null) {
            v2.numberType(numberType);
        }
    }

    protected void visitIntFormat(JsonFormatVisitorWrapper visitor, JavaType typeHint, JsonParser.NumberType numberType, JsonValueFormat format) throws JsonMappingException {
        JsonIntegerFormatVisitor v2;
        if (visitor != null && (v2 = visitor.expectIntegerFormat(typeHint)) != null) {
            if (numberType != null) {
                v2.numberType(numberType);
            }
            if (format != null) {
                v2.format(format);
            }
        }
    }

    protected void visitFloatFormat(JsonFormatVisitorWrapper visitor, JavaType typeHint, JsonParser.NumberType numberType) throws JsonMappingException {
        JsonNumberFormatVisitor v2;
        if (visitor != null && (v2 = visitor.expectNumberFormat(typeHint)) != null) {
            v2.numberType(numberType);
        }
    }

    protected void visitArrayFormat(JsonFormatVisitorWrapper visitor, JavaType typeHint, JsonSerializer<?> itemSerializer, JavaType itemType) throws JsonMappingException {
        JsonArrayFormatVisitor v2;
        if (visitor != null && (v2 = visitor.expectArrayFormat(typeHint)) != null && itemSerializer != null) {
            v2.itemsFormat(itemSerializer, itemType);
        }
    }

    protected void visitArrayFormat(JsonFormatVisitorWrapper visitor, JavaType typeHint, JsonFormatTypes itemType) throws JsonMappingException {
        JsonArrayFormatVisitor v2;
        if (visitor != null && (v2 = visitor.expectArrayFormat(typeHint)) != null) {
            v2.itemsFormat(itemType);
        }
    }

    public void wrapAndThrow(SerializerProvider provider, Throwable t, Object bean, String fieldName) throws IOException {
        boolean wrap;
        while (t instanceof InvocationTargetException && t.getCause() != null) {
            t = t.getCause();
        }
        if (t instanceof Error) {
            throw (Error)t;
        }
        boolean bl = wrap = provider == null || provider.isEnabled(SerializationFeature.WRAP_EXCEPTIONS);
        if (t instanceof IOException) {
            if (!wrap || !(t instanceof JsonMappingException)) {
                throw (IOException)t;
            }
        } else if (!wrap && t instanceof RuntimeException) {
            throw (RuntimeException)t;
        }
        throw JsonMappingException.wrapWithPath(t, bean, fieldName);
    }

    public void wrapAndThrow(SerializerProvider provider, Throwable t, Object bean, int index) throws IOException {
        boolean wrap;
        while (t instanceof InvocationTargetException && t.getCause() != null) {
            t = t.getCause();
        }
        if (t instanceof Error) {
            throw (Error)t;
        }
        boolean bl = wrap = provider == null || provider.isEnabled(SerializationFeature.WRAP_EXCEPTIONS);
        if (t instanceof IOException) {
            if (!wrap || !(t instanceof JsonMappingException)) {
                throw (IOException)t;
            }
        } else if (!wrap && t instanceof RuntimeException) {
            throw (RuntimeException)t;
        }
        throw JsonMappingException.wrapWithPath(t, bean, index);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected JsonSerializer<?> findConvertingContentSerializer(SerializerProvider provider, BeanProperty prop, JsonSerializer<?> existingSerializer) throws JsonMappingException {
        AnnotatedMember m;
        Object ob = provider.getAttribute(CONVERTING_CONTENT_CONVERTER_LOCK);
        if (ob != null && ob == Boolean.TRUE) {
            return existingSerializer;
        }
        AnnotationIntrospector intr = provider.getAnnotationIntrospector();
        if (intr != null && prop != null && (m = prop.getMember()) != null) {
            Object convDef;
            provider.setAttribute(CONVERTING_CONTENT_CONVERTER_LOCK, Boolean.TRUE);
            try {
                convDef = intr.findSerializationContentConverter(m);
            }
            finally {
                provider.setAttribute(CONVERTING_CONTENT_CONVERTER_LOCK, null);
            }
            if (convDef != null) {
                Converter<Object, Object> conv = provider.converterInstance(prop.getMember(), convDef);
                JavaType delegateType = conv.getOutputType(provider.getTypeFactory());
                if (existingSerializer == null && !delegateType.isJavaLangObject()) {
                    existingSerializer = provider.findValueSerializer(delegateType);
                }
                return new StdDelegatingSerializer(conv, delegateType, existingSerializer);
            }
        }
        return existingSerializer;
    }

    protected PropertyFilter findPropertyFilter(SerializerProvider provider, Object filterId, Object valueToFilter) throws JsonMappingException {
        FilterProvider filters = provider.getFilterProvider();
        if (filters == null) {
            throw JsonMappingException.from(provider, "Can not resolve PropertyFilter with id '" + filterId + "'; no FilterProvider configured");
        }
        return filters.findPropertyFilter(filterId, valueToFilter);
    }

    protected JsonFormat.Value findFormatOverrides(SerializerProvider provider, BeanProperty prop, Class<?> typeForDefaults) {
        if (prop != null) {
            return prop.findPropertyFormat(provider.getConfig(), typeForDefaults);
        }
        return provider.getDefaultPropertyFormat(typeForDefaults);
    }

    protected Boolean findFormatFeature(SerializerProvider provider, BeanProperty prop, Class<?> typeForDefaults, JsonFormat.Feature feat) {
        JsonFormat.Value format = this.findFormatOverrides(provider, prop, typeForDefaults);
        if (format != null) {
            return format.getFeature(feat);
        }
        return null;
    }

    protected JsonInclude.Value findIncludeOverrides(SerializerProvider provider, BeanProperty prop, Class<?> typeForDefaults) {
        if (prop != null) {
            return prop.findPropertyInclusion(provider.getConfig(), typeForDefaults);
        }
        return provider.getDefaultPropertyInclusion(typeForDefaults);
    }

    protected JsonSerializer<?> findAnnotatedContentSerializer(SerializerProvider serializers, BeanProperty property) throws JsonMappingException {
        if (property != null) {
            Object serDef;
            AnnotatedMember m = property.getMember();
            AnnotationIntrospector intr = serializers.getAnnotationIntrospector();
            if (m != null && (serDef = intr.findContentSerializer(m)) != null) {
                return serializers.serializerInstance(m, serDef);
            }
        }
        return null;
    }

    protected boolean isDefaultSerializer(JsonSerializer<?> serializer) {
        return ClassUtil.isJacksonStdImpl(serializer);
    }
}

