/*
 * Decompiled with CFR 0.152.
 */
package de.scribble.lp.killtherng.repack.org.msgpack.jackson.dataformat;

import de.scribble.lp.killtherng.repack.com.fasterxml.jackson.core.type.TypeReference;
import de.scribble.lp.killtherng.repack.com.fasterxml.jackson.databind.ObjectMapper;
import de.scribble.lp.killtherng.repack.org.msgpack.jackson.dataformat.MessagePackFactory;
import java.io.IOException;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public class ExtensionTypeCustomDeserializers {
    private final ObjectMapper objectMapper;
    private Map<Byte, Deser> deserTable = new ConcurrentHashMap<Byte, Deser>();

    public ExtensionTypeCustomDeserializers() {
        this.objectMapper = new ObjectMapper(new MessagePackFactory().setReuseResourceInParser(false));
    }

    public ExtensionTypeCustomDeserializers(ExtensionTypeCustomDeserializers extensionTypeCustomDeserializers) {
        this();
        this.deserTable.putAll(extensionTypeCustomDeserializers.deserTable);
    }

    public <T> void addTargetClass(byte by, final Class<T> clazz) {
        this.deserTable.put(by, new Deser(){

            @Override
            public Object deserialize(byte[] byArray) throws IOException {
                return ExtensionTypeCustomDeserializers.this.objectMapper.readValue(byArray, clazz);
            }
        });
    }

    public void addTargetTypeReference(byte by, final TypeReference typeReference) {
        this.deserTable.put(by, new Deser(){

            @Override
            public Object deserialize(byte[] byArray) throws IOException {
                return ExtensionTypeCustomDeserializers.this.objectMapper.readValue(byArray, typeReference);
            }
        });
    }

    public void addCustomDeser(byte by, final Deser deser) {
        this.deserTable.put(by, new Deser(){

            @Override
            public Object deserialize(byte[] byArray) throws IOException {
                return deser.deserialize(byArray);
            }
        });
    }

    public Deser getDeser(byte by) {
        return this.deserTable.get(by);
    }

    public void clearEntries() {
        this.deserTable.clear();
    }

    public static interface Deser {
        public Object deserialize(byte[] var1) throws IOException;
    }
}

