/*
 * Decompiled with CFR 0.152.
 */
package com.dselent.bigarraylist;

import com.dselent.bigarraylist.CacheMapping;
import com.dselent.bigarraylist.SoftMapping;
import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;

public class BigArrayList<E extends Serializable> {
    private List<List<E>> arrayLists;
    private final SoftMapping<E> softMapping;
    private final CacheMapping<E> cacheMapping;
    private long wholeListSize;
    private static final int DEFAULT_BLOCK_SIZE = 1000000;
    private static final int DEFAULT_CACHE_BLOCKS = 2;
    private static final int MIN_CACHE_SIZE = 5;
    private static final int MAX_CACHE_SIZE = Integer.MAX_VALUE;
    private static final int MIN_CACHE_BLOCKS = 2;
    private static final int MAX_CACHE_BLOCKS = Integer.MAX_VALUE;
    private int blockSize;
    private int cacheBlocks;
    private boolean liveObject;
    private IOTypes ioType;

    public BigArrayList() {
        this.blockSize = 1000000;
        this.cacheBlocks = 2;
        this.softMapping = new SoftMapping();
        this.cacheMapping = new CacheMapping(this, this.blockSize, this.cacheBlocks);
        this.arrayLists = new ArrayList<List<E>>();
        for (int i = 0; i < this.cacheBlocks; ++i) {
            ArrayList arrayList = new ArrayList();
            arrayList.ensureCapacity(this.blockSize);
            this.arrayLists.add(arrayList);
        }
        this.wholeListSize = 0L;
        this.ioType = IOTypes.FST_OBJECT;
        this.liveObject = true;
    }

    public BigArrayList(String memoryPath) {
        this.blockSize = 1000000;
        this.cacheBlocks = 2;
        this.softMapping = new SoftMapping();
        this.cacheMapping = new CacheMapping(this, this.blockSize, this.cacheBlocks, memoryPath);
        this.arrayLists = new ArrayList<List<E>>();
        for (int i = 0; i < this.cacheBlocks; ++i) {
            ArrayList arrayList = new ArrayList();
            arrayList.ensureCapacity(this.blockSize);
            this.arrayLists.add(arrayList);
        }
        this.wholeListSize = 0L;
        this.ioType = IOTypes.FST_OBJECT;
        this.liveObject = true;
    }

    public BigArrayList(String memoryPath, IOTypes ioType) {
        this.blockSize = 1000000;
        this.cacheBlocks = 2;
        this.softMapping = new SoftMapping();
        this.cacheMapping = new CacheMapping(this, this.blockSize, this.cacheBlocks, memoryPath);
        this.arrayLists = new ArrayList<List<E>>();
        for (int i = 0; i < this.cacheBlocks; ++i) {
            ArrayList arrayList = new ArrayList();
            arrayList.ensureCapacity(this.blockSize);
            this.arrayLists.add(arrayList);
        }
        this.wholeListSize = 0L;
        this.ioType = ioType;
        this.liveObject = true;
    }

    public BigArrayList(int blockSize, int cacheBlocks) {
        if (blockSize < 5 || blockSize > Integer.MAX_VALUE) {
            throw new IllegalArgumentException("Cache size is " + blockSize + " but must be >= " + 5 + " and <= " + Integer.MAX_VALUE);
        }
        if (cacheBlocks < 2 || cacheBlocks > Integer.MAX_VALUE) {
            throw new IllegalArgumentException("Number of cache blocks is " + cacheBlocks + " but must be >= " + 2 + " and <= " + Integer.MAX_VALUE);
        }
        this.blockSize = blockSize;
        this.cacheBlocks = cacheBlocks;
        this.softMapping = new SoftMapping();
        this.cacheMapping = new CacheMapping(this, blockSize, cacheBlocks);
        this.arrayLists = new ArrayList<List<E>>();
        for (int i = 0; i < cacheBlocks; ++i) {
            ArrayList arrayList = new ArrayList();
            arrayList.ensureCapacity(blockSize);
            this.arrayLists.add(arrayList);
        }
        this.wholeListSize = 0L;
        this.ioType = IOTypes.FST_OBJECT;
        this.liveObject = true;
    }

    public BigArrayList(int blockSize, int cacheBlocks, IOTypes ioType) {
        if (blockSize < 5 || blockSize > Integer.MAX_VALUE) {
            throw new IllegalArgumentException("Cache size is " + blockSize + " but must be >= " + 5 + " and <= " + Integer.MAX_VALUE);
        }
        if (cacheBlocks < 2 || cacheBlocks > Integer.MAX_VALUE) {
            throw new IllegalArgumentException("Number of cache blocks is " + cacheBlocks + " but must be >= " + 2 + " and <= " + Integer.MAX_VALUE);
        }
        this.blockSize = blockSize;
        this.cacheBlocks = cacheBlocks;
        this.softMapping = new SoftMapping();
        this.cacheMapping = new CacheMapping(this, blockSize, cacheBlocks);
        this.arrayLists = new ArrayList<List<E>>();
        for (int i = 0; i < cacheBlocks; ++i) {
            ArrayList arrayList = new ArrayList();
            arrayList.ensureCapacity(blockSize);
            this.arrayLists.add(arrayList);
        }
        this.wholeListSize = 0L;
        this.ioType = ioType;
        this.liveObject = true;
    }

    public BigArrayList(int blockSize, int cacheBlocks, String memoryPath) {
        if (blockSize < 5 || blockSize > Integer.MAX_VALUE) {
            throw new IllegalArgumentException("Cache size is " + blockSize + " but must be >= " + 5 + " and <= " + Integer.MAX_VALUE);
        }
        if (cacheBlocks < 2 || cacheBlocks > Integer.MAX_VALUE) {
            throw new IllegalArgumentException("Number of cache blocks is " + cacheBlocks + " but must be >= " + 2 + " and <= " + Integer.MAX_VALUE);
        }
        this.blockSize = blockSize;
        this.cacheBlocks = cacheBlocks;
        this.softMapping = new SoftMapping();
        this.cacheMapping = new CacheMapping(this, blockSize, cacheBlocks, memoryPath);
        this.arrayLists = new ArrayList<List<E>>();
        for (int i = 0; i < cacheBlocks; ++i) {
            ArrayList arrayList = new ArrayList();
            arrayList.ensureCapacity(blockSize);
            this.arrayLists.add(arrayList);
        }
        this.wholeListSize = 0L;
        this.ioType = IOTypes.FST_OBJECT;
        this.liveObject = true;
    }

    public BigArrayList(int blockSize, int cacheBlocks, String memoryPath, IOTypes ioType) {
        if (blockSize < 5 || blockSize > Integer.MAX_VALUE) {
            throw new IllegalArgumentException("Cache size is " + blockSize + " but must be >= " + 5 + " and <= " + Integer.MAX_VALUE);
        }
        if (cacheBlocks < 2 || cacheBlocks > Integer.MAX_VALUE) {
            throw new IllegalArgumentException("Number of cache blocks is " + cacheBlocks + " but must be >= " + 2 + " and <= " + Integer.MAX_VALUE);
        }
        this.blockSize = blockSize;
        this.cacheBlocks = cacheBlocks;
        this.softMapping = new SoftMapping();
        this.cacheMapping = new CacheMapping(this, blockSize, cacheBlocks, memoryPath);
        this.arrayLists = new ArrayList<List<E>>();
        for (int i = 0; i < cacheBlocks; ++i) {
            ArrayList arrayList = new ArrayList();
            arrayList.ensureCapacity(blockSize);
            this.arrayLists.add(arrayList);
        }
        this.wholeListSize = 0L;
        this.ioType = ioType;
        this.liveObject = true;
    }

    protected CacheMapping<E> getCacheMapping() {
        return this.cacheMapping;
    }

    public int getNumberOfBlocks() {
        return this.cacheBlocks;
    }

    public int getBlockSize() {
        return this.blockSize;
    }

    protected int getNumberOfUsedBlocks() {
        long blockSizeLong = this.blockSize;
        long usedBlocks = (long)Math.ceil((double)this.size() * 1.0 / (double)blockSizeLong * 1.0);
        return (int)usedBlocks;
    }

    protected int getNumberOfUsedBlocks(long index) {
        long blockSizeLong = this.blockSize;
        long usedVirtualBlocks = (long)Math.ceil((double)index * 1.0 / (double)blockSizeLong * 1.0);
        long usedRealBlocks = this.getNumberOfUsedBlocks();
        long usedBlocks = Math.max(usedRealBlocks, usedVirtualBlocks);
        return (int)usedBlocks;
    }

    public String getFilePath() {
        return this.cacheMapping.getFileAccessor().getMemoryFilePath();
    }

    public void setList(int index, List<E> arrayList) {
        this.arrayLists.set(index, arrayList);
    }

    protected List<E> getList(int index) {
        return this.arrayLists.get(index);
    }

    protected void clearList(int index) {
        this.arrayLists.get(index).clear();
    }

    public long size() {
        return this.wholeListSize;
    }

    public IOTypes getIOType() {
        return this.ioType;
    }

    protected int getArraySize(int index) {
        return this.arrayLists.get(index).size();
    }

    public boolean isLive() {
        return this.liveObject;
    }

    public void clearMemory() throws IOException {
        this.cacheMapping.clearMemory();
        this.liveObject = false;
    }

    public void flushMemory() {
        this.cacheMapping.flushCache();
    }

    public static <T extends Comparable<? super T> & Serializable> BigArrayList<T> sort(BigArrayList<T> unsortedList) throws IOException {
        return BigArrayList.sort(unsortedList, Comparator.naturalOrder());
    }

    public static <T extends Serializable> BigArrayList<T> sort(BigArrayList<T> unsortedList, Comparator<? super T> comparator) throws IOException {
        if (unsortedList.size() <= 1L) {
            return unsortedList;
        }
        super.purgeActionBuffer();
        CacheMapping<T> unsortedCacheMapping = unsortedList.getCacheMapping();
        int blockSize = unsortedList.getBlockSize();
        int cacheBlocks = unsortedList.getNumberOfBlocks();
        int usedCacheBlocks = unsortedList.getNumberOfUsedBlocks();
        String filePath = unsortedList.getFilePath();
        IOTypes ioType = unsortedList.getIOType();
        BigArrayList<Object> sortedList = new BigArrayList(blockSize, cacheBlocks, filePath, ioType);
        for (int i = usedCacheBlocks - 1; i >= 0; --i) {
            int cacheBlockSpot = -1;
            if (!unsortedCacheMapping.isFileInCache(i)) {
                unsortedCacheMapping.bringFileIntoCache(i);
            }
            cacheBlockSpot = unsortedCacheMapping.getCacheBlockSpot(i);
            unsortedCacheMapping.setDirtyBit(cacheBlockSpot, true);
            Collections.sort(unsortedList.getList(cacheBlockSpot), comparator);
        }
        if (usedCacheBlocks > 1) {
            int currentRun = 0;
            long totalRuns = 64 - Long.numberOfLeadingZeros(usedCacheBlocks - 1);
            while ((long)currentRun < totalRuns) {
                sortedList = BigArrayList.merge(unsortedList, comparator, currentRun);
                unsortedList.clearMemory();
                unsortedList = sortedList;
                ++currentRun;
            }
        } else {
            sortedList = unsortedList;
        }
        return sortedList;
    }

    private static <T extends Serializable> BigArrayList<T> merge(BigArrayList<T> unsortedList, Comparator<? super T> comparator, int currentRun) {
        int blockSize = unsortedList.getBlockSize();
        int cacheBlocks = unsortedList.getNumberOfBlocks();
        long usedCacheBlocksLong = unsortedList.getNumberOfUsedBlocks();
        String filePath = unsortedList.getFilePath();
        IOTypes ioType = unsortedList.getIOType();
        BigArrayList<T> sortedList = new BigArrayList<T>(blockSize, cacheBlocks, filePath, ioType);
        int blockIncrement = BigArrayList.ipow(2, currentRun);
        long i = 0L;
        while (i < usedCacheBlocksLong) {
            T element1;
            long mergePiece1 = i;
            long mergePiece2 = -1L;
            long mergePiece3 = -1L;
            long firstElementStart = mergePiece1 * (long)blockSize;
            long secondElementStart = -1L;
            long firstElementEnd = -1L;
            long secondElementEnd = -1L;
            long currentMergeElements = 0L;
            long totalMergeElements = -1L;
            if (i + (long)blockIncrement < usedCacheBlocksLong) {
                mergePiece2 = i + (long)blockIncrement;
                mergePiece3 = i + (long)blockIncrement + (long)blockIncrement;
                firstElementEnd = secondElementStart = mergePiece2 * (long)blockSize;
                secondElementEnd = unsortedList.size() >= mergePiece3 * (long)blockSize ? mergePiece3 * (long)blockSize : unsortedList.size();
                totalMergeElements = secondElementEnd - firstElementStart;
            } else {
                firstElementEnd = unsortedList.size() >= (i + (long)blockIncrement) * (long)blockSize ? (i + (long)blockIncrement) * (long)blockSize : unsortedList.size();
                totalMergeElements = firstElementEnd - firstElementStart;
            }
            long index1 = firstElementStart;
            long index2 = secondElementStart;
            if (mergePiece2 == -1L || mergePiece2 >= usedCacheBlocksLong) {
                element1 = unsortedList.get(index1);
                while (currentMergeElements < totalMergeElements) {
                    sortedList.add(element1);
                    if (++index1 < firstElementEnd) {
                        element1 = unsortedList.get(index1);
                    }
                    ++currentMergeElements;
                }
            } else {
                element1 = unsortedList.get(index1);
                T element2 = unsortedList.get(index2);
                while (currentMergeElements < totalMergeElements) {
                    if (index2 >= secondElementEnd) {
                        sortedList.add(element1);
                        if (++index1 < firstElementEnd) {
                            element1 = unsortedList.get(index1);
                        }
                    } else if (index1 >= firstElementEnd) {
                        sortedList.add(element2);
                        if (++index2 < secondElementEnd) {
                            element2 = unsortedList.get(index2);
                        }
                    } else if (comparator.compare(element1, element2) <= 0) {
                        sortedList.add(element1);
                        if (++index1 < firstElementEnd) {
                            element1 = unsortedList.get(index1);
                        }
                    } else {
                        sortedList.add(element2);
                        if (++index2 < secondElementEnd) {
                            element2 = unsortedList.get(index2);
                        }
                    }
                    ++currentMergeElements;
                }
            }
            i = i + (long)blockIncrement + (long)blockIncrement;
        }
        return sortedList;
    }

    private static int ipow(int base, int exp) {
        int result = 1;
        while (exp != 0) {
            if ((exp & 1) == 1) {
                result *= base;
            }
            exp >>= 1;
            base *= base;
        }
        return result;
    }

    private void purgeActionBuffer() {
        if (this.softMapping.getBufferSize() > 0) {
            long startIndex = this.softMapping.getShiftIndex(0);
            int fileNumber = this.cacheMapping.getFileNumber(startIndex);
            int nextFileNumber = fileNumber + 1;
            long virtualSize = this.wholeListSize + this.softMapping.getLastShiftAmount();
            int usedCacheBlocks = this.getNumberOfUsedBlocks(virtualSize);
            int cacheBlockSpot = -1;
            int nextCacheBlockSpot = -1;
            if (!this.cacheMapping.isFileInCache(fileNumber)) {
                cacheBlockSpot = this.cacheMapping.bringFileIntoCache(fileNumber);
            } else {
                cacheBlockSpot = this.cacheMapping.getCacheBlockSpot(fileNumber);
                this.cacheMapping.updateUsedList(cacheBlockSpot);
            }
            this.cacheMapping.setDirtyBit(cacheBlockSpot, true);
            if (!this.cacheMapping.isFileInCache(nextFileNumber)) {
                nextCacheBlockSpot = this.cacheMapping.bringFileIntoCache(nextFileNumber);
                this.cacheMapping.setDirtyBit(nextCacheBlockSpot, true);
            } else {
                nextCacheBlockSpot = this.cacheMapping.getCacheBlockSpot(nextFileNumber);
                this.cacheMapping.setDirtyBit(nextCacheBlockSpot, true);
            }
            while (nextFileNumber < usedCacheBlocks) {
                List<E> cacheBlock = this.arrayLists.get(cacheBlockSpot);
                List<E> nextCacheBlock = this.arrayLists.get(nextCacheBlockSpot);
                while (cacheBlock.size() < this.getBlockSize() && nextFileNumber < usedCacheBlocks) {
                    if (nextCacheBlock.size() > 0) {
                        cacheBlock.add(nextCacheBlock.remove(0));
                        this.cacheMapping.removeEntry(nextCacheBlockSpot);
                        this.cacheMapping.addEntry(cacheBlockSpot);
                        continue;
                    }
                    this.cacheMapping.updateUsedList(cacheBlockSpot);
                    if (++nextFileNumber >= usedCacheBlocks) continue;
                    nextCacheBlockSpot = !this.cacheMapping.isFileInCache(nextFileNumber) ? this.cacheMapping.bringFileIntoCache(nextFileNumber) : this.cacheMapping.getCacheBlockSpot(nextFileNumber);
                    nextCacheBlock = this.arrayLists.get(nextCacheBlockSpot);
                    this.cacheMapping.setDirtyBit(nextCacheBlockSpot, true);
                }
                if (++fileNumber == nextFileNumber) {
                    nextFileNumber = fileNumber + 1;
                }
                if (nextFileNumber >= usedCacheBlocks) continue;
                if (!this.cacheMapping.isFileInCache(fileNumber)) {
                    cacheBlockSpot = this.cacheMapping.bringFileIntoCache(fileNumber);
                } else {
                    cacheBlockSpot = this.cacheMapping.getCacheBlockSpot(fileNumber);
                    this.cacheMapping.updateUsedList(cacheBlockSpot);
                }
                this.cacheMapping.setDirtyBit(cacheBlockSpot, true);
                nextCacheBlockSpot = !this.cacheMapping.isFileInCache(nextFileNumber) ? this.cacheMapping.bringFileIntoCache(nextFileNumber) : this.cacheMapping.getCacheBlockSpot(nextFileNumber);
                this.cacheMapping.setDirtyBit(nextCacheBlockSpot, true);
            }
            this.softMapping.removeAllShifts();
        }
    }

    private void purgeActionBufferInCache(long startIndex) {
        if (this.softMapping.getBufferSize() > 0) {
            boolean done = false;
            int fileNumber = this.cacheMapping.getFileNumber(startIndex);
            int nextFileNumber = fileNumber + 1;
            long virtualSize = this.wholeListSize + this.softMapping.getLastShiftAmount();
            int usedCacheBlocks = this.getNumberOfUsedBlocks(virtualSize);
            int cacheBlockSpot = -1;
            int nextCacheBlockSpot = -1;
            cacheBlockSpot = !this.cacheMapping.isFileInCache(fileNumber) ? this.cacheMapping.bringFileIntoCache(fileNumber) : this.cacheMapping.getCacheBlockSpot(fileNumber);
            this.cacheMapping.setDirtyBit(cacheBlockSpot, true);
            if (!this.cacheMapping.isFileInCache(nextFileNumber)) {
                done = true;
            } else {
                nextCacheBlockSpot = this.cacheMapping.getCacheBlockSpot(nextFileNumber);
                this.cacheMapping.setDirtyBit(nextCacheBlockSpot, true);
            }
            long lastIndexInBlock = this.cacheMapping.getLastIndexInFile(fileNumber);
            long lastIndexInNextBlock = this.cacheMapping.getLastIndexInFile(nextFileNumber);
            while (nextFileNumber < usedCacheBlocks && !done) {
                long shiftAmount = this.softMapping.getCurrentShiftAmount(lastIndexInBlock);
                this.softMapping.removeShift(lastIndexInBlock);
                long shiftCount = 0L;
                long nextShiftCount = 0L;
                List<E> cacheBlock = this.arrayLists.get(cacheBlockSpot);
                List<E> nextCacheBlock = this.arrayLists.get(nextCacheBlockSpot);
                while (cacheBlock.size() < this.getBlockSize() && !done) {
                    if (nextCacheBlock.size() > 0) {
                        cacheBlock.add(nextCacheBlock.remove(0));
                        this.cacheMapping.removeEntry(nextCacheBlockSpot);
                        this.cacheMapping.addEntry(cacheBlockSpot);
                        ++shiftCount;
                        ++nextShiftCount;
                        continue;
                    }
                    if (nextShiftCount > 0L) {
                        this.softMapping.addShift(lastIndexInNextBlock, nextShiftCount);
                        nextShiftCount = 0L;
                    }
                    if (++nextFileNumber < usedCacheBlocks) {
                        if (!this.cacheMapping.isFileInCache(nextFileNumber)) {
                            done = true;
                            continue;
                        }
                        nextCacheBlockSpot = this.cacheMapping.getCacheBlockSpot(nextFileNumber);
                        nextCacheBlock = this.arrayLists.get(nextCacheBlockSpot);
                        lastIndexInNextBlock = this.cacheMapping.getLastIndexInFile(nextFileNumber);
                        this.cacheMapping.setDirtyBit(nextCacheBlockSpot, true);
                        continue;
                    }
                    done = true;
                }
                if (shiftAmount - shiftCount > 0L) {
                    this.softMapping.addShift(lastIndexInBlock, shiftAmount - shiftCount);
                    continue;
                }
                if (++fileNumber == nextFileNumber) {
                    nextFileNumber = fileNumber + 1;
                }
                if (nextFileNumber >= usedCacheBlocks) continue;
                this.softMapping.addShift(lastIndexInNextBlock, nextShiftCount);
                if (!this.cacheMapping.isFileInCache(fileNumber)) {
                    done = true;
                } else {
                    cacheBlockSpot = this.cacheMapping.getCacheBlockSpot(fileNumber);
                    lastIndexInBlock = this.cacheMapping.getLastIndexInFile(fileNumber);
                    this.cacheMapping.setDirtyBit(cacheBlockSpot, true);
                }
                if (!this.cacheMapping.isFileInCache(nextFileNumber)) {
                    done = true;
                    continue;
                }
                nextCacheBlockSpot = this.cacheMapping.getCacheBlockSpot(nextFileNumber);
                lastIndexInNextBlock = this.cacheMapping.getLastIndexInFile(nextFileNumber);
                this.cacheMapping.setDirtyBit(nextCacheBlockSpot, true);
            }
        }
    }

    public boolean add(E element) {
        boolean added = false;
        long adjustedIndex = this.softMapping.getAdjustedIndex(this.wholeListSize);
        int lastFile = this.cacheMapping.getFileNumber(adjustedIndex);
        int cacheBlockSpot = -1;
        if (!this.cacheMapping.isFileInCache(lastFile)) {
            this.cacheMapping.bringFileIntoCache(lastFile);
        }
        if (!this.cacheMapping.isCacheFull(cacheBlockSpot = this.cacheMapping.getCacheBlockSpot(lastFile))) {
            added = this.arrayLists.get(cacheBlockSpot).add(element);
            if (added) {
                this.cacheMapping.addEntry(cacheBlockSpot);
                this.cacheMapping.setDirtyBit(cacheBlockSpot, true);
                ++this.wholeListSize;
            }
        } else {
            throw new RuntimeException("Failed to add " + element + " at the end of the list");
        }
        return added;
    }

    public E get(long index) {
        if (index < 0L || index >= this.wholeListSize) {
            throw new IndexOutOfBoundsException(" " + index + " ");
        }
        long adjustedIndex = this.softMapping.getAdjustedIndex(index);
        int fileNumber = this.cacheMapping.getFileNumber(adjustedIndex);
        if (!this.cacheMapping.isFileInCache(fileNumber)) {
            this.cacheMapping.bringFileIntoCache(fileNumber);
        }
        int cacheBlockSpot = this.cacheMapping.getCacheBlockSpot(fileNumber);
        int spotInCache = this.cacheMapping.getSpotInCache(adjustedIndex);
        return (E)((Serializable)this.arrayLists.get(cacheBlockSpot).get(spotInCache));
    }

    public E get(int index) {
        long longIndex = index;
        return this.get(longIndex);
    }

    public E remove(long index) {
        long adjustedIndex;
        int fileNumber;
        if (index < 0L || index >= this.wholeListSize) {
            throw new IndexOutOfBoundsException(" " + index + " ");
        }
        if (this.softMapping.isBufferFull() || this.softMapping.isShiftMaxed()) {
            this.purgeActionBuffer();
        }
        if (!this.cacheMapping.isFileInCache(fileNumber = this.cacheMapping.getFileNumber(adjustedIndex = this.softMapping.getAdjustedIndex(index)))) {
            this.cacheMapping.bringFileIntoCache(fileNumber);
        }
        int cacheBlockSpot = this.cacheMapping.getCacheBlockSpot(fileNumber);
        int spotInCache = this.cacheMapping.getSpotInCache(adjustedIndex);
        long virtualSize = this.wholeListSize + this.softMapping.getLastShiftAmount();
        int usedCacheBlocks = this.getNumberOfUsedBlocks(virtualSize);
        List<E> cacheBlock = this.arrayLists.get(cacheBlockSpot);
        Serializable element = (Serializable)cacheBlock.remove(spotInCache);
        this.cacheMapping.removeEntry(cacheBlockSpot);
        this.cacheMapping.setDirtyBit(cacheBlockSpot, true);
        long lastIndexInBlock = this.cacheMapping.getLastIndexInFile(fileNumber);
        if (fileNumber + 1 < usedCacheBlocks) {
            this.softMapping.addShift(lastIndexInBlock, 1L);
            this.purgeActionBufferInCache(lastIndexInBlock);
        }
        --this.wholeListSize;
        return (E)element;
    }

    public E remove(int index) {
        long longIndex = index;
        return this.remove(longIndex);
    }

    public E set(long index, E element) {
        if (index < 0L || index >= this.wholeListSize) {
            throw new IndexOutOfBoundsException(" " + index + " ");
        }
        long adjustedIndex = this.softMapping.getAdjustedIndex(index);
        int fileNumber = this.cacheMapping.getFileNumber(adjustedIndex);
        if (!this.cacheMapping.isFileInCache(fileNumber)) {
            this.cacheMapping.bringFileIntoCache(fileNumber);
        }
        int cacheBlockSpot = this.cacheMapping.getCacheBlockSpot(fileNumber);
        int spotInCache = this.cacheMapping.getSpotInCache(adjustedIndex);
        this.cacheMapping.setDirtyBit(cacheBlockSpot, true);
        return (E)((Serializable)this.arrayLists.get(cacheBlockSpot).set(spotInCache, element));
    }

    public E set(int index, E element) {
        long longIndex = index;
        return this.set(longIndex, element);
    }

    public boolean isEmpty() {
        boolean empty = true;
        if (this.size() > 0L) {
            empty = false;
        }
        return empty;
    }

    public boolean equals(Object otherObject) {
        boolean isEqual = true;
        if (otherObject == null) {
            isEqual = false;
        } else if (this == otherObject) {
            isEqual = true;
        } else if (!(otherObject instanceof BigArrayList)) {
            isEqual = false;
        } else {
            BigArrayList otherBigArrayList = (BigArrayList)otherObject;
            if (this.wholeListSize != otherBigArrayList.size()) {
                isEqual = false;
            } else if (this.liveObject != otherBigArrayList.isLive()) {
                isEqual = false;
            } else if (this.ioType != otherBigArrayList.ioType) {
                isEqual = false;
            } else {
                for (long i = 0L; i < this.wholeListSize && isEqual; ++i) {
                    if (this.get(i).equals(otherBigArrayList.get(i))) continue;
                    isEqual = false;
                }
            }
        }
        return isEqual;
    }

    public static enum IOTypes {
        OBJECT,
        MMAP_OBJECT,
        FST_OBJECT,
        MMAP_FST_OBJECT;

    }
}

