/*
 * Decompiled with CFR 0.152.
 */
package com.dselent.bigarraylist;

import com.dselent.bigarraylist.BigArrayList;
import com.dselent.bigarraylist.FileAccessor;
import java.io.IOException;
import java.io.Serializable;

class CacheMapping<E extends Serializable> {
    private int[] cacheTableSpots;
    private int[] cacheTableFiles;
    private int[] mostRecentlyUsedList;
    private boolean[] dirtyBits;
    private BigArrayList<E> bigArrayList;
    private FileAccessor<E> fileAccessor;

    protected CacheMapping(BigArrayList<E> theList, int blockSize, int cacheBlocks, String memoryPath) {
        this.cacheTableSpots = new int[cacheBlocks];
        this.cacheTableFiles = new int[cacheBlocks];
        this.mostRecentlyUsedList = new int[cacheBlocks];
        this.dirtyBits = new boolean[cacheBlocks];
        for (int i = 0; i < cacheBlocks; ++i) {
            this.cacheTableSpots[i] = 0;
            this.cacheTableFiles[i] = -1;
            this.mostRecentlyUsedList[i] = -1;
            this.dirtyBits[i] = false;
        }
        this.bigArrayList = theList;
        this.fileAccessor = new FileAccessor(memoryPath);
    }

    protected CacheMapping(BigArrayList<E> theList, int blockSize, int cacheBlocks) {
        this.cacheTableSpots = new int[cacheBlocks];
        this.cacheTableFiles = new int[cacheBlocks];
        this.mostRecentlyUsedList = new int[cacheBlocks];
        this.dirtyBits = new boolean[cacheBlocks];
        for (int i = 0; i < cacheBlocks; ++i) {
            this.cacheTableSpots[i] = 0;
            this.cacheTableFiles[i] = -1;
            this.mostRecentlyUsedList[i] = -1;
            this.dirtyBits[i] = false;
        }
        this.bigArrayList = theList;
        this.fileAccessor = new FileAccessor();
    }

    protected FileAccessor<E> getFileAccessor() {
        return this.fileAccessor;
    }

    private void setCacheTableSpots(int cacheBlockIndex, int indexToAdd) {
        this.cacheTableSpots[cacheBlockIndex] = indexToAdd;
    }

    private void setCacheTableFiles(int index, int fileNumber) {
        this.cacheTableFiles[index] = fileNumber;
    }

    protected boolean isCacheFull(int block) {
        boolean full = false;
        if (this.cacheTableSpots[block] >= this.bigArrayList.getBlockSize()) {
            full = true;
        }
        return full;
    }

    protected void setDirtyBit(int blockIndex, boolean dirty) {
        this.dirtyBits[blockIndex] = dirty;
    }

    protected void addEntry(int cacheBlockIndex) {
        int n = cacheBlockIndex;
        this.cacheTableSpots[n] = this.cacheTableSpots[n] + 1;
        this.updateUsedList(cacheBlockIndex);
    }

    protected void removeEntry(int cacheBlockIndex) {
        int n = cacheBlockIndex;
        this.cacheTableSpots[n] = this.cacheTableSpots[n] - 1;
        this.updateUsedList(cacheBlockIndex);
    }

    protected int getFileNumber(long index) {
        long blockSizeLong = this.bigArrayList.getBlockSize();
        long longFileNumber = index / blockSizeLong;
        return (int)longFileNumber;
    }

    protected long getLastIndexInFile(int fileNumber) {
        long blockSizeLong = this.bigArrayList.getBlockSize();
        long fileNumberLong = fileNumber;
        long index = blockSizeLong * fileNumberLong + blockSizeLong - 1L;
        return index;
    }

    protected int getCacheBlockSpot(int fileNumber) {
        int blockSpot = -1;
        for (int i = 0; i < this.cacheTableFiles.length && blockSpot == -1; ++i) {
            if (this.cacheTableFiles[i] != fileNumber) continue;
            blockSpot = i;
        }
        return blockSpot;
    }

    protected int getSpotInCache(long index) {
        long longTableSize = this.bigArrayList.getBlockSize();
        long spotInFile = index % longTableSize;
        return (int)spotInFile;
    }

    protected boolean isFileInCache(int fileNumber) {
        boolean inCache = false;
        for (int i = 0; i < this.cacheTableFiles.length && !inCache; ++i) {
            if (this.cacheTableFiles[i] != fileNumber) continue;
            inCache = true;
        }
        return inCache;
    }

    protected int getFirstOpenCacheBlock() {
        int firstOpen = -1;
        for (int i = 0; i < this.cacheTableFiles.length && firstOpen == -1; ++i) {
            if (this.cacheTableFiles[i] != -1) continue;
            firstOpen = i;
        }
        return firstOpen;
    }

    protected void updateUsedList(int blockNumber) {
        int i;
        int oldPosition = -1;
        int newPosition = this.mostRecentlyUsedList.length - 1;
        int shiftPosition = 0;
        for (i = 0; i < this.mostRecentlyUsedList.length; ++i) {
            if (this.mostRecentlyUsedList[i] != blockNumber) continue;
            oldPosition = i;
        }
        if (oldPosition != -1) {
            this.mostRecentlyUsedList[oldPosition] = -1;
        }
        for (i = 0; i < this.mostRecentlyUsedList.length; ++i) {
            if (this.mostRecentlyUsedList[i] != -1) continue;
            shiftPosition = i;
        }
        for (i = shiftPosition; i < this.mostRecentlyUsedList.length - 1; ++i) {
            this.mostRecentlyUsedList[i] = this.mostRecentlyUsedList[i + 1];
        }
        this.mostRecentlyUsedList[newPosition] = blockNumber;
    }

    private void removeFromUsedList(int blockIndex) {
        for (int i = 0; i < this.mostRecentlyUsedList.length; ++i) {
            if (this.mostRecentlyUsedList[i] != blockIndex) continue;
            this.mostRecentlyUsedList[i] = -1;
        }
    }

    protected void flushCache() {
        for (int i = 0; i < this.cacheTableFiles.length; ++i) {
            this.flushCacheBlock(i);
        }
    }

    private void flushCacheBlock(int blockIndex) {
        int fileNumber = this.cacheTableFiles[blockIndex];
        if (this.dirtyBits[blockIndex]) {
            try {
                if (this.bigArrayList.getIOType() == BigArrayList.IOTypes.OBJECT) {
                    this.fileAccessor.writeToFileObject(fileNumber, blockIndex, this.bigArrayList);
                } else if (this.bigArrayList.getIOType() == BigArrayList.IOTypes.MMAP_OBJECT) {
                    this.fileAccessor.writeToFileMMapObject(fileNumber, blockIndex, this.bigArrayList);
                } else if (this.bigArrayList.getIOType() == BigArrayList.IOTypes.FST_OBJECT) {
                    this.fileAccessor.writeToFileFSTObject(fileNumber, blockIndex, this.bigArrayList);
                } else if (this.bigArrayList.getIOType() == BigArrayList.IOTypes.MMAP_FST_OBJECT) {
                    this.fileAccessor.writeToFileMMapFSTObject(fileNumber, blockIndex, this.bigArrayList);
                } else {
                    this.fileAccessor.writeToFileObject(fileNumber, blockIndex, this.bigArrayList);
                }
                this.setDirtyBit(blockIndex, false);
            }
            catch (Exception e) {
                e.printStackTrace();
                System.exit(-1);
            }
        }
        this.bigArrayList.clearList(blockIndex);
        this.removeFromUsedList(blockIndex);
        this.clearCacheBlock(blockIndex);
    }

    private void clearCacheBlock(int blockToClear) {
        this.cacheTableSpots[blockToClear] = 0;
        this.cacheTableFiles[blockToClear] = -1;
    }

    protected int bringFileIntoCache(int fileNumber) {
        int openCacheBlock = this.getFirstOpenCacheBlock();
        if (openCacheBlock == -1) {
            int blockToFlush = this.mostRecentlyUsedList[0];
            this.flushCacheBlock(blockToFlush);
        }
        openCacheBlock = this.getFirstOpenCacheBlock();
        this.readFromFile(fileNumber, openCacheBlock);
        this.setCacheTableFiles(openCacheBlock, fileNumber);
        this.setCacheTableSpots(openCacheBlock, this.bigArrayList.getArraySize(openCacheBlock));
        this.updateUsedList(openCacheBlock);
        return openCacheBlock;
    }

    private void readFromFile(int fileNumber, int cacheIndex) {
        try {
            if (this.bigArrayList.getIOType() == BigArrayList.IOTypes.OBJECT) {
                this.fileAccessor.readFromFileObject(fileNumber, cacheIndex, this.bigArrayList);
            } else if (this.bigArrayList.getIOType() == BigArrayList.IOTypes.MMAP_OBJECT) {
                this.fileAccessor.readFromFileMMapObject(fileNumber, cacheIndex, this.bigArrayList);
            } else if (this.bigArrayList.getIOType() == BigArrayList.IOTypes.FST_OBJECT) {
                this.fileAccessor.readFromFileFSTObject(fileNumber, cacheIndex, this.bigArrayList);
            } else if (this.bigArrayList.getIOType() == BigArrayList.IOTypes.MMAP_FST_OBJECT) {
                this.fileAccessor.readFromFileMMapFSTObject(fileNumber, cacheIndex, this.bigArrayList);
            } else {
                this.fileAccessor.readFromFileObject(fileNumber, cacheIndex, this.bigArrayList);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            System.exit(-1);
        }
    }

    protected void clearMemory() throws IOException {
        this.fileAccessor.clearMemory();
    }
}

