/*
 * Decompiled with CFR 0.152.
 */
package com.dselent.bigarraylist;

import com.dselent.bigarraylist.BigArrayList;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.RandomAccessFile;
import java.io.Serializable;
import java.nio.MappedByteBuffer;
import java.nio.channels.FileChannel;
import java.util.ArrayList;
import org.nustaq.serialization.FSTConfiguration;
import org.nustaq.serialization.FSTObjectInput;
import org.nustaq.serialization.FSTObjectOutput;

class FileAccessor<E extends Serializable> {
    private static int nextMemoryInstance = 0;
    private final String DEFAULT_MEMORY_FILE_PATH = "memory";
    private final String DEFAULT_MEMORY_FILE_EXTENSION = ".jobj";
    private final int BUFFER_SIZE = 262144;
    private final File memoryFolder;
    private String memoryPath;
    private String memoryExtension;
    private int memoryInstance;
    private static FSTConfiguration fstConfiguration;

    public FileAccessor() {
        this.memoryPath = "memory";
        this.memoryExtension = ".jobj";
        this.memoryFolder = new File(this.memoryPath);
        try {
            if (!this.memoryFolder.exists()) {
                this.memoryFolder.mkdir();
            }
            this.memoryInstance = this.findMemoryInstance();
        }
        catch (Exception e) {
            e.printStackTrace();
            System.exit(-1);
        }
        if (fstConfiguration == null) {
            fstConfiguration = FSTConfiguration.createDefaultConfiguration();
        }
    }

    public FileAccessor(String memoryPath) {
        this.memoryPath = memoryPath;
        this.memoryExtension = ".jobj";
        this.memoryFolder = new File(memoryPath);
        try {
            if (!this.memoryFolder.exists()) {
                this.memoryFolder.mkdir();
            }
            this.memoryInstance = this.findMemoryInstance();
        }
        catch (Exception e) {
            e.printStackTrace();
            System.exit(-1);
        }
        if (fstConfiguration == null) {
            fstConfiguration = FSTConfiguration.createDefaultConfiguration();
        }
    }

    protected boolean doesFileExist(int fileNumber) {
        boolean exists = false;
        File file = new File(this.memoryPath + File.separator + this.memoryInstance + "_memory_" + fileNumber + this.memoryExtension);
        if (file.exists()) {
            exists = true;
        }
        return exists;
    }

    private int findMemoryInstance() {
        int memoryInstanceNumber = nextMemoryInstance;
        File memoryFile = new File(this.memoryPath + File.separator + memoryInstanceNumber + "_memory_0" + this.memoryExtension);
        while (memoryFile.exists()) {
            memoryFile = new File(this.memoryPath + File.separator + ++memoryInstanceNumber + "_memory_0" + this.memoryExtension);
        }
        nextMemoryInstance = memoryInstanceNumber + 1;
        return memoryInstanceNumber;
    }

    protected void createFile(int fileNumber) {
        int memoryInstance = this.findMemoryInstance();
        File file = new File(this.memoryPath + File.separator + memoryInstance + "_memory_" + fileNumber + this.memoryExtension);
        try {
            if (file.exists()) {
                throw new Exception("File already exists " + file.toString());
            }
            file.createNewFile();
        }
        catch (Exception e) {
            e.printStackTrace();
            System.exit(-1);
        }
    }

    private void deleteFile(String filePath) {
        File file = new File(filePath);
        if (file.exists()) {
            file.delete();
        }
    }

    protected void deleteFile(int fileNumber) {
        String filePath = this.memoryPath + File.separator + this.memoryInstance + "_memory_" + fileNumber + this.memoryExtension;
        this.deleteFile(filePath);
    }

    protected String getMemoryFilePath() {
        return this.memoryPath;
    }

    protected void readFromFileObject(int fileNumber, int cacheSpot, BigArrayList<E> arrayList) throws IOException, ClassNotFoundException {
        String filePath = this.memoryPath + File.separator + this.memoryInstance + "_memory_" + fileNumber + this.memoryExtension;
        File file = new File(filePath);
        if (file.exists()) {
            FileInputStream fileInputStream = new FileInputStream(filePath);
            BufferedInputStream bufferedInputStream = new BufferedInputStream(fileInputStream, 262144);
            ObjectInputStream objectInputStream = new ObjectInputStream(bufferedInputStream);
            try {
                arrayList.setList(cacheSpot, (ArrayList)objectInputStream.readObject());
            }
            catch (IOException ioe) {
                throw ioe;
            }
            catch (ClassNotFoundException ce) {
                throw ce;
            }
            finally {
                fileInputStream.close();
                bufferedInputStream.close();
                objectInputStream.close();
            }
        } else {
            arrayList.setList(cacheSpot, new ArrayList());
        }
    }

    protected void readFromFileMMapObject(int fileNumber, int cacheSpot, BigArrayList<E> arrayList) throws IOException, ClassNotFoundException {
        String filePath = this.memoryPath + File.separator + this.memoryInstance + "_memory_" + fileNumber + this.memoryExtension;
        File file = new File(filePath);
        if (file.exists()) {
            RandomAccessFile tempFile = new RandomAccessFile(filePath, "rw");
            long tempFileLength = tempFile.length();
            int fileLength = -1;
            if (tempFile.length() > Integer.MAX_VALUE) {
                tempFile.close();
                throw new IllegalArgumentException(tempFileLength + " cannot be cast to an int");
            }
            fileLength = (int)tempFileLength;
            MappedByteBuffer tempByteBuffer = tempFile.getChannel().map(FileChannel.MapMode.READ_ONLY, 0L, tempFile.length());
            tempByteBuffer.load();
            byte[] byteArray = new byte[fileLength];
            tempByteBuffer.get(byteArray);
            ByteArrayInputStream bais = new ByteArrayInputStream(byteArray);
            ObjectInputStream objectInputStream = new ObjectInputStream(bais);
            try {
                arrayList.setList(cacheSpot, (ArrayList)objectInputStream.readObject());
            }
            catch (IOException ioe) {
                throw ioe;
            }
            finally {
                bais.close();
                objectInputStream.close();
                tempByteBuffer.clear();
                tempByteBuffer = null;
                tempFile.close();
                System.gc();
            }
        } else {
            arrayList.setList(cacheSpot, new ArrayList());
        }
    }

    protected void readFromFileFSTObject(int fileNumber, int cacheSpot, BigArrayList<E> arrayList) throws IOException, ClassNotFoundException {
        String filePath = this.memoryPath + File.separator + this.memoryInstance + "_memory_" + fileNumber + this.memoryExtension;
        File file = new File(filePath);
        if (file.exists()) {
            FileInputStream fileInputStream = new FileInputStream(filePath);
            FSTObjectInput fstObjectInputStream = new FSTObjectInput(fileInputStream);
            try {
                arrayList.setList(cacheSpot, (ArrayList)fstObjectInputStream.readObject());
            }
            catch (IOException ioe) {
                throw ioe;
            }
            catch (ClassNotFoundException ce) {
                throw ce;
            }
            finally {
                fileInputStream.close();
                fstObjectInputStream.close();
            }
        } else {
            arrayList.setList(cacheSpot, new ArrayList());
        }
    }

    protected void readFromFileMMapFSTObject(int fileNumber, int cacheSpot, BigArrayList<E> arrayList) throws IOException, ClassNotFoundException {
        String filePath = this.memoryPath + File.separator + this.memoryInstance + "_memory_" + fileNumber + this.memoryExtension;
        File file = new File(filePath);
        if (file.exists()) {
            RandomAccessFile tempFile = new RandomAccessFile(filePath, "rw");
            long tempFileLength = tempFile.length();
            int fileLength = -1;
            if (tempFile.length() > Integer.MAX_VALUE) {
                tempFile.close();
                throw new IllegalArgumentException(tempFileLength + " cannot be cast to an int");
            }
            fileLength = (int)tempFileLength;
            try {
                MappedByteBuffer tempByteBuffer = tempFile.getChannel().map(FileChannel.MapMode.READ_ONLY, 0L, tempFile.length());
                tempByteBuffer.load();
                byte[] byteArray = new byte[fileLength];
                tempByteBuffer.get(byteArray);
                arrayList.setList(cacheSpot, (ArrayList)fstConfiguration.asObject(byteArray));
                tempByteBuffer.clear();
            }
            catch (IOException ioe) {
                throw ioe;
            }
            finally {
                Object tempByteBuffer = null;
                tempFile.close();
                System.gc();
            }
        } else {
            arrayList.setList(cacheSpot, new ArrayList());
        }
    }

    protected void writeToFileObject(int fileNumber, int cacheSpot, BigArrayList<E> arrayList) throws IOException {
        String filePath = this.memoryPath + File.separator + this.memoryInstance + "_memory_" + fileNumber + this.memoryExtension;
        File tempFile = new File(filePath);
        if (!arrayList.getList(cacheSpot).isEmpty()) {
            tempFile.deleteOnExit();
            FileOutputStream fileOutputStream = new FileOutputStream(filePath);
            BufferedOutputStream bufferedOutputStream = new BufferedOutputStream(fileOutputStream, 262144);
            ObjectOutputStream objectOutputStream = new ObjectOutputStream(bufferedOutputStream);
            try {
                objectOutputStream.writeObject(arrayList.getList(cacheSpot));
                objectOutputStream.flush();
            }
            catch (IOException ioe) {
                throw ioe;
            }
            finally {
                fileOutputStream.close();
                bufferedOutputStream.close();
                objectOutputStream.close();
            }
        } else {
            tempFile.delete();
        }
    }

    protected void writeToFileMMapObject(int fileNumber, int cacheSpot, BigArrayList<E> arrayList) throws IOException {
        String filePath = this.memoryPath + File.separator + this.memoryInstance + "_memory_" + fileNumber + this.memoryExtension;
        if (!arrayList.getList(cacheSpot).isEmpty()) {
            RandomAccessFile tempFile = new RandomAccessFile(filePath, "rw");
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            ObjectOutputStream objectOutputStream = new ObjectOutputStream(baos);
            try {
                objectOutputStream.writeObject(arrayList.getList(cacheSpot));
                objectOutputStream.flush();
                byte[] byteArray = baos.toByteArray();
                MappedByteBuffer tempByteBuffer = tempFile.getChannel().map(FileChannel.MapMode.READ_WRITE, 0L, byteArray.length);
                tempByteBuffer.put(byteArray);
                tempByteBuffer.force();
                tempByteBuffer.clear();
            }
            catch (IOException ioe) {
                throw ioe;
            }
            finally {
                objectOutputStream.close();
                Object tempByteBuffer = null;
                tempFile.close();
                System.gc();
            }
        } else {
            File tempFile = new File(filePath);
            tempFile.delete();
        }
    }

    protected void writeToFileFSTObject(int fileNumber, int cacheSpot, BigArrayList<E> arrayList) throws IOException {
        String filePath = this.memoryPath + File.separator + this.memoryInstance + "_memory_" + fileNumber + this.memoryExtension;
        File tempFile = new File(filePath);
        if (!arrayList.getList(cacheSpot).isEmpty()) {
            tempFile.deleteOnExit();
            FileOutputStream fileOutputStream = new FileOutputStream(filePath);
            FSTObjectOutput fstObjectOutputStream = new FSTObjectOutput(fileOutputStream);
            try {
                byte[] byteArray = fstConfiguration.asByteArray(arrayList.getList(cacheSpot));
                fstObjectOutputStream.write(byteArray);
                fstObjectOutputStream.flush();
            }
            catch (IOException ioe) {
                throw ioe;
            }
            finally {
                fileOutputStream.close();
                fstObjectOutputStream.close();
            }
        } else {
            tempFile.delete();
        }
    }

    protected void writeToFileMMapFSTObject(int fileNumber, int cacheSpot, BigArrayList<E> arrayList) throws IOException {
        String filePath = this.memoryPath + File.separator + this.memoryInstance + "_memory_" + fileNumber + this.memoryExtension;
        if (!arrayList.getList(cacheSpot).isEmpty()) {
            RandomAccessFile tempFile = new RandomAccessFile(filePath, "rw");
            try {
                byte[] byteArray = fstConfiguration.asByteArray(arrayList.getList(cacheSpot));
                MappedByteBuffer tempByteBuffer = tempFile.getChannel().map(FileChannel.MapMode.READ_WRITE, 0L, byteArray.length);
                tempByteBuffer.put(byteArray);
                tempByteBuffer.force();
                tempByteBuffer.clear();
            }
            catch (IOException ioe) {
                throw ioe;
            }
            finally {
                Object tempByteBuffer = null;
                tempFile.close();
                System.gc();
            }
        } else {
            File tempFile = new File(filePath);
            tempFile.delete();
        }
    }

    protected void clearMemory() throws IOException {
        File[] fileList = this.memoryFolder.listFiles();
        for (int i = 0; i < fileList.length; ++i) {
            boolean deleted;
            String path = fileList[i].getAbsolutePath();
            if (!path.startsWith(this.memoryFolder.getAbsolutePath() + File.separator + this.memoryInstance) || (deleted = fileList[i].delete())) continue;
            throw new IOException("Unable to delete file: " + path);
        }
    }
}

