/*
 * Decompiled with CFR 0.152.
 */
package com.minecrafttas.tasmod;

import com.minecrafttas.tasmod.CommonProxy;
import com.minecrafttas.tasmod.commands.clearinputs.CommandClearInputs;
import com.minecrafttas.tasmod.commands.folder.CommandFolder;
import com.minecrafttas.tasmod.commands.fullplay.CommandFullPlay;
import com.minecrafttas.tasmod.commands.fullrecord.CommandFullRecord;
import com.minecrafttas.tasmod.commands.loadtas.CommandLoadTAS;
import com.minecrafttas.tasmod.commands.playback.CommandPlay;
import com.minecrafttas.tasmod.commands.playuntil.CommandPlayUntil;
import com.minecrafttas.tasmod.commands.recording.CommandRecord;
import com.minecrafttas.tasmod.commands.restartandplay.CommandRestartAndPlay;
import com.minecrafttas.tasmod.commands.savetas.CommandSaveTAS;
import com.minecrafttas.tasmod.commands.tutorial.CommandPlaybacktutorial;
import com.minecrafttas.tasmod.inputcontainer.server.ContainerStateServer;
import com.minecrafttas.tasmod.ktrng.KillTheRNGHandler;
import com.minecrafttas.tasmod.networking.TASmodNetworkServer;
import com.minecrafttas.tasmod.savestates.server.SavestateCommand;
import com.minecrafttas.tasmod.savestates.server.SavestateHandler;
import com.minecrafttas.tasmod.savestates.server.files.SavestateTrackerFile;
import com.minecrafttas.tasmod.tickratechanger.CommandTickrate;
import com.minecrafttas.tasmod.tickratechanger.TickrateChangerServer;
import com.minecrafttas.tasmod.util.ModIncompatibleException;
import java.io.File;
import java.io.IOException;
import net.minecraft.command.ICommand;
import net.minecraft.server.MinecraftServer;
import net.minecraftforge.fml.common.Loader;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.ModContainer;
import net.minecraftforge.fml.common.SidedProxy;
import net.minecraftforge.fml.common.event.FMLInitializationEvent;
import net.minecraftforge.fml.common.event.FMLPostInitializationEvent;
import net.minecraftforge.fml.common.event.FMLPreInitializationEvent;
import net.minecraftforge.fml.common.event.FMLServerStartingEvent;
import net.minecraftforge.fml.common.event.FMLServerStoppingEvent;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@Mod(modid="tasmod", name="Tool-Assisted Speedrun Mod", version="Alpha9-WIP", acceptedMinecraftVersions="[1.12.2]")
public class TASmod {
    @SidedProxy(serverSide="com.minecrafttas.tasmod.CommonProxy", clientSide="com.minecrafttas.tasmod.ClientProxy")
    public static CommonProxy proxy;
    public static final String VERSION = "Alpha9-WIP";
    public static final String MCVERSION = "1.12.2";
    private static MinecraftServer serverInstance;
    public static final Logger logger;
    public static ContainerStateServer containerStateServer;
    public static SavestateHandler savestateHandler;
    public static KillTheRNGHandler ktrngHandler;
    public static TASmodNetworkServer packetServer;

    @Mod.EventHandler
    public void preInit(FMLPreInitializationEvent ev) throws Exception {
        logger.info("Initializing TASmod");
        logger.info("Testing connection with KillTheRNG");
        ktrngHandler = new KillTheRNGHandler(Loader.isModLoaded((String)"killtherng"));
        proxy.preInit(ev);
        if (Loader.isModLoaded((String)"tastools")) {
            throw new ModIncompatibleException("\n========================================================================\n\nDetected TASTools to be loaded. TASMod and TASTools are incompatible!\n\n========================================================================");
        }
        if (Loader.isModLoaded((String)"dupemod")) {
            throw new ModIncompatibleException("\n========================================================================\n\nDetected Dupemod to be loaded. TASMod and Dupemod are incompatible!\n\n========================================================================");
        }
        if (Loader.isModLoaded((String)"tickratechanger")) {
            throw new ModIncompatibleException("\n========================================================================\n\nDetected Tickratechanger to be loaded. TASMod and Tickratechanger are incompatible!\n\n========================================================================");
        }
        if (Loader.isModLoaded((String)"lotas")) {
            throw new ModIncompatibleException("\n========================================================================\n\nDetected LoTAS to be loaded. TASMod and LoTAS are incompatible!\n\n========================================================================");
        }
        for (ModContainer mod : Loader.instance().getModList()) {
            if (!mod.getModId().equals("forge")) continue;
            String[] versionsplit = mod.getVersion().split("\\.");
            int forgeversion = Integer.parseInt(versionsplit[3]);
            if (!MCVERSION.equals(MCVERSION) || forgeversion >= 2857) continue;
            throw new SecurityException("\n========================================================================\n\nThe forge version you are using contains a critical Log4J exploit: 14.23.5." + forgeversion + "\nPlease update the forge version to something above 14.23.5.2857.\nYou can find new versions under https://files.minecraftforge.net/net/minecraftforge/forge/index_1.12.2.html\n\n ========================================================================");
        }
    }

    @Mod.EventHandler
    public void init(FMLInitializationEvent ev) {
        proxy.init(ev);
    }

    @Mod.EventHandler
    public void postInit(FMLPostInitializationEvent ev) {
        proxy.postInit(ev);
    }

    @Mod.EventHandler
    public void serverStart(FMLServerStartingEvent ev) {
        serverInstance = ev.getServer();
        containerStateServer = new ContainerStateServer();
        ev.registerServerCommand((ICommand)new CommandTickrate());
        ev.registerServerCommand((ICommand)new CommandRecord());
        ev.registerServerCommand((ICommand)new CommandPlay());
        ev.registerServerCommand((ICommand)new CommandSaveTAS());
        ev.registerServerCommand((ICommand)new CommandLoadTAS());
        ev.registerServerCommand((ICommand)new CommandPlaybacktutorial());
        ev.registerServerCommand((ICommand)new CommandFolder());
        ev.registerServerCommand((ICommand)new CommandClearInputs());
        ev.registerServerCommand((ICommand)new SavestateCommand());
        ev.registerServerCommand((ICommand)new CommandFullRecord());
        ev.registerServerCommand((ICommand)new CommandFullPlay());
        ev.registerServerCommand((ICommand)new CommandRestartAndPlay());
        ev.registerServerCommand((ICommand)new CommandPlayUntil());
        File savestateDirectory = new File(serverInstance.func_71238_n() + File.separator + "saves" + File.separator + "savestates" + File.separator);
        try {
            new SavestateTrackerFile(new File(savestateDirectory, ev.getServer().func_71270_I() + "-info.txt"));
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        savestateHandler = new SavestateHandler(ev.getServer(), logger);
        try {
            packetServer = new TASmodNetworkServer(logger);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        if (!serverInstance.func_71262_S()) {
            TickrateChangerServer.ticksPerSecond = 0.0f;
            TickrateChangerServer.tickrateSaved = 20.0f;
        }
    }

    @Mod.EventHandler
    public void serverStop(FMLServerStoppingEvent ev) {
        serverInstance = null;
        packetServer.close();
    }

    public static MinecraftServer getServerInstance() {
        return serverInstance;
    }

    static {
        logger = LogManager.getLogger((String)"TASMod");
    }
}

