/*
 * Decompiled with CFR 0.152.
 */
package com.minecrafttas.tasmod.events;

import com.minecrafttas.tasmod.ClientProxy;
import com.minecrafttas.tasmod.TASmod;
import com.minecrafttas.tasmod.inputcontainer.server.InitialSyncStatePacket;
import com.minecrafttas.tasmod.networking.TASmodNetworkClient;
import com.minecrafttas.tasmod.tickratechanger.TickrateChangerServer;
import com.mojang.authlib.GameProfile;
import java.io.IOException;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.EntityPlayerSP;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraftforge.event.entity.EntityJoinWorldEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class PlayerJoinLeaveEvents {
    public static void firePlayerJoinedServerSide(EntityPlayerMP player) {
        TASmod.logger.info("Firing login events for {} on the SERVER", (Object)player.func_70005_c_());
        TickrateChangerServer.joinServer(player);
    }

    public static void firePlayerLeaveServerSide(EntityPlayerMP player) {
        TASmod.containerStateServer.leaveServer(player);
    }

    @SideOnly(value=Side.CLIENT)
    public static void firePlayerJoinedClientSide(EntityPlayerSP player) {
        TASmod.logger.info("Firing login events for {} on the CLIENT", (Object)player.func_70005_c_());
        Minecraft mc = Minecraft.func_71410_x();
        ClientProxy.packetClient = mc.func_71387_A() ? new TASmodNetworkClient(TASmod.logger) : new TASmodNetworkClient(TASmod.logger, mc.func_147104_D().field_78845_b, 3111);
        ClientProxy.packetClient.sendToServer(new InitialSyncStatePacket(ClientProxy.virtual.getContainer().getState()));
        ClientProxy.virtual.unpressNext();
        ClientProxy.shieldDownloader.onPlayerJoin(player.func_146103_bH());
        TASmod.ktrngHandler.setInitialSeed();
    }

    @SideOnly(value=Side.CLIENT)
    public static void firePlayerLeaveClientSide(EntityPlayerSP player) {
        TASmod.logger.info("Firing logout events for {} on the CLIENT", (Object)player.func_70005_c_());
        try {
            if (ClientProxy.packetClient != null) {
                ClientProxy.packetClient.killClient();
                ClientProxy.packetClient = null;
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    @SubscribeEvent
    public void fireOtherPlayerJoinedClientSide(EntityJoinWorldEvent event) {
        if (event.getWorld().field_72995_K && event.getEntity() instanceof EntityPlayer) {
            GameProfile profile = ((EntityPlayer)event.getEntity()).func_146103_bH();
            TASmod.logger.info("Firing other login events for {} on the CLIENT", (Object)profile.getName());
            ClientProxy.shieldDownloader.onPlayerJoin(profile);
        }
    }

    public static void fireOtherPlayerJoinedClientSide(GameProfile profile) {
        TASmod.logger.info("Firing other login events for {} on the CLIENT", (Object)profile.getName());
        ClientProxy.shieldDownloader.onPlayerJoin(profile);
    }
}

