/*
 * Decompiled with CFR 0.152.
 */
package com.minecrafttas.tasmod.externalGui;

import com.minecrafttas.tasmod.inputcontainer.InputContainer;
import com.minecrafttas.tasmod.inputcontainer.TickInputContainer;
import com.minecrafttas.tasmod.virtual.VirtualInput;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.EventQueue;
import java.awt.Font;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.util.Vector;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.UIManager;
import javax.swing.border.EmptyBorder;
import javax.swing.table.DefaultTableModel;

public class InputContainerView
extends JFrame {
    private static final long serialVersionUID = -1823965270972132025L;
    private JPanel contentPane;
    private static JTable table;
    private static DefaultTableModel model;
    private static int prevCount;

    public static void main(String[] args) {
        EventQueue.invokeLater(new Runnable(){

            @Override
            public void run() {
                try {
                    InputContainerView frame = new InputContainerView();
                    frame.setVisible(true);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        });
    }

    public InputContainerView() {
        try {
            UIManager.setLookAndFeel(UIManager.getSystemLookAndFeelClassName());
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.setIconImage(Toolkit.getDefaultToolkit().getImage(InputContainerView.class.getResource("/assets/tasmod/textures/potion2.png")));
        this.setBackground(Color.WHITE);
        this.setTitle("InputContainer View");
        this.setFont(new Font("Arial", 0, 12));
        this.setDefaultCloseOperation(2);
        this.setBounds(100, 100, 673, 448);
        this.contentPane = new JPanel();
        this.contentPane.setBackground(Color.WHITE);
        this.contentPane.setBorder(new EmptyBorder(5, 5, 5, 5));
        this.contentPane.setLayout(new BorderLayout(0, 0));
        this.setContentPane(this.contentPane);
        JScrollPane scrollPane = new JScrollPane();
        this.contentPane.add((Component)scrollPane, "Center");
        Vector<String> title = new Vector<String>();
        title.add("Ticks");
        title.add("Keyboard");
        title.add("Mouse");
        title.add("CameraX");
        title.add("CameraY");
        model = new DefaultTableModel(title, 0);
        table = new JTable(model);
        table.getColumnModel().getColumn(0).setPreferredWidth(5);
        table.setBackground(Color.DARK_GRAY);
        table.setForeground(Color.LIGHT_GRAY);
        scrollPane.setViewportView(table);
        this.contentPane.add((Component)table.getTableHeader(), "First");
    }

    private static void addRow(int ticks, String keyboard, String mouse, float cameraX, float cameraY) {
        Vector<Object> row = new Vector<Object>(5);
        row.add(ticks);
        row.add(keyboard);
        row.add(mouse);
        row.add(Float.valueOf(cameraX));
        row.add(Float.valueOf(cameraY));
        model.addRow(row);
    }

    private static void selectRow(int ticks) {
        if (ticks >= table.getRowCount()) {
            ticks = table.getRowCount() - 1;
        }
        table.setRowSelectionInterval(ticks, ticks);
        table.scrollRectToVisible(new Rectangle(table.getCellRect(ticks, 0, true)));
    }

    public static void update(VirtualInput input) {
        if (model == null) {
            return;
        }
        InputContainer container = input.getContainer();
        if (container == null || container.isEmpty()) {
            return;
        }
        if (prevCount != container.size()) {
            prevCount = container.size();
            model.getDataVector().clear();
            for (int i = 0; i < container.size(); ++i) {
                TickInputContainer tickContainer = container.get(i);
                InputContainerView.addRow(i + 1, tickContainer.getKeyboard().toString(), tickContainer.getMouse().toString(), tickContainer.getSubticks().getPitch(), tickContainer.getSubticks().getYaw());
            }
            InputContainerView.selectRow(container.index());
        }
        if (!container.isNothingPlaying()) {
            InputContainerView.selectRow(container.index());
        }
    }

    public static void startBufferView() {
        EventQueue.invokeLater(new Runnable(){

            @Override
            public void run() {
                try {
                    InputContainerView frame = new InputContainerView();
                    frame.setVisible(true);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        });
    }

    static {
        prevCount = 0;
    }
}

