/*
 * Decompiled with CFR 0.152.
 */
package com.minecrafttas.tasmod.gui;

import com.minecrafttas.tasmod.ClientProxy;
import com.minecrafttas.tasmod.TASmod;
import com.minecrafttas.tasmod.events.CameraInterpolationEvents;
import com.minecrafttas.tasmod.inputcontainer.TASstate;
import com.minecrafttas.tasmod.inputcontainer.controlbytes.ControlByteHandler;
import com.minecrafttas.tasmod.mixin.accessors.AccessorWorld;
import com.minecrafttas.tasmod.monitoring.DesyncMonitoring;
import com.minecrafttas.tasmod.tickratechanger.TickrateChangerClient;
import com.minecrafttas.tasmod.util.PlayerPositionCalculator;
import com.minecrafttas.tasmod.util.TrajectoriesCalculator;
import com.mojang.realmsclient.gui.ChatFormatting;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import java.util.concurrent.Callable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.util.math.Vec3d;
import org.lwjgl.opengl.GL11;

public class InfoHud
extends GuiScreen {
    private int currentlyDraggedIndex = -1;
    private int xOffset;
    private int yOffset;
    private int gridSizeX = 14;
    private int gridSizeY = 14;
    public Properties configuration;
    public static List<InfoLabel> lists = new ArrayList<InfoLabel>();

    private void setDefaults(String string, int y) {
        this.configuration.setProperty(string + "_x", "0");
        this.configuration.setProperty(string + "_y", y + "");
        this.configuration.setProperty(string + "_visible", "false");
        this.configuration.setProperty(string + "_rect", "false");
        this.saveConfig();
    }

    public void identify(int mouseX, int mouseY) {
        int index = 0;
        for (InfoLabel label : lists) {
            int x = 0;
            int y = 0;
            try {
                x = Integer.parseInt(this.configuration.getProperty(label.displayName + "_x"));
                y = Integer.parseInt(this.configuration.getProperty(label.displayName + "_y"));
            }
            catch (NumberFormatException e) {
                this.configuration.setProperty(label.displayName + "_x", "0");
                this.configuration.setProperty(label.displayName + "_y", "0");
                this.saveConfig();
            }
            int w = x + Minecraft.func_71410_x().field_71466_p.func_78256_a(label.renderText);
            int h = y + 15;
            if (mouseX >= x && mouseX <= w && mouseY >= y && mouseY <= h) {
                this.currentlyDraggedIndex = index;
                this.xOffset = mouseX - x;
                this.yOffset = mouseY - y;
                return;
            }
            ++index;
        }
        this.currentlyDraggedIndex = -1;
        this.xOffset = -1;
        this.yOffset = -1;
    }

    protected void func_73864_a(int mouseX, int mouseY, int mouseButton) throws IOException {
        if (mouseButton == 1) {
            this.identify(mouseX, mouseY);
            if (this.currentlyDraggedIndex != -1) {
                String id = InfoHud.lists.get((int)this.currentlyDraggedIndex).displayName;
                InfoHud.lists.get((int)this.currentlyDraggedIndex).renderRect = !InfoHud.lists.get((int)this.currentlyDraggedIndex).renderRect;
                this.configuration.setProperty(id + "_rect", this.configuration.getProperty(id + "_rect").equalsIgnoreCase("true") ? "false" : "true");
                this.saveConfig();
                this.currentlyDraggedIndex = -1;
            }
            return;
        }
        if (mouseButton == 2) {
            this.identify(mouseX, mouseY);
            if (this.currentlyDraggedIndex != -1) {
                String id = InfoHud.lists.get((int)this.currentlyDraggedIndex).displayName;
                InfoHud.lists.get((int)this.currentlyDraggedIndex).visible = !InfoHud.lists.get((int)this.currentlyDraggedIndex).visible;
                this.configuration.setProperty(id + "_visible", this.configuration.getProperty(id + "_visible").equalsIgnoreCase("true") ? "false" : "true");
                this.saveConfig();
                this.currentlyDraggedIndex = -1;
            }
            return;
        }
        this.identify(mouseX, mouseY);
        super.func_73864_a(mouseX, mouseY, mouseButton);
    }

    protected void func_146286_b(int p_mouseReleased_1_, int p_mouseReleased_2_, int p_mouseReleased_3_) {
        this.currentlyDraggedIndex = -1;
        this.saveConfig();
        super.func_146286_b(p_mouseReleased_1_, p_mouseReleased_2_, p_mouseReleased_3_);
    }

    protected void func_146273_a(int mouseX, int mouseY, int k, long millis) {
        if (this.currentlyDraggedIndex != -1) {
            String dragging = InfoHud.lists.get((int)this.currentlyDraggedIndex).displayName;
            int mousePosX = mouseX - this.xOffset;
            int mousePosY = mouseY - this.yOffset;
            if (ClientProxy.virtual.isKeyDown(42)) {
                mousePosX = this.snapToGridX(mousePosX);
                mousePosY = this.snapToGridY(mousePosY);
            }
            InfoHud.lists.get((int)this.currentlyDraggedIndex).x = mousePosX;
            InfoHud.lists.get((int)this.currentlyDraggedIndex).y = mousePosY;
            this.configuration.setProperty(dragging + "_x", InfoHud.lists.get((int)this.currentlyDraggedIndex).x + "");
            this.configuration.setProperty(dragging + "_y", InfoHud.lists.get((int)this.currentlyDraggedIndex).y + "");
        }
        super.func_146273_a(mouseX, mouseY, k, millis);
    }

    private int snapToGridX(int x) {
        return Math.round(x / this.gridSizeX) * this.gridSizeX;
    }

    private int snapToGridY(int y) {
        return Math.round(y / this.gridSizeY) * this.gridSizeY;
    }

    private void saveConfig() {
        try {
            File tasmodDir = new File(Minecraft.func_71410_x().field_71412_D, "tasmod");
            tasmodDir.mkdir();
            File configFile = new File(tasmodDir, "infogui2.cfg");
            if (!configFile.exists()) {
                configFile.createNewFile();
            }
            this.configuration.store(new FileOutputStream(configFile, false), "DO NOT EDIT MANUALLY");
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public void tick() {
        if (this.checkInit()) {
            return;
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean checkInit() {
        if (this.configuration != null) {
            return false;
        }
        try {
            this.configuration = new Properties();
            File tasmodDir = new File(Minecraft.func_71410_x().field_71412_D, "tasmod");
            tasmodDir.mkdir();
            File configFile = new File(tasmodDir, "infogui2.cfg");
            if (!configFile.exists()) {
                configFile.createNewFile();
            }
            this.configuration.load(new FileReader(configFile));
            lists = new ArrayList<InfoLabel>();
            String title = "tickrate";
            int y = 0;
            if (this.configuration.getProperty(title + "_x", "err").equals("err")) {
                this.setDefaults(title, y);
            }
            lists.add(new InfoLabel(title, Integer.parseInt(this.configuration.getProperty(title + "_x")), Integer.parseInt(this.configuration.getProperty(title + "_y")), Boolean.parseBoolean(this.configuration.getProperty(title + "_visible")), Boolean.parseBoolean(this.configuration.getProperty(title + "_rect")), () -> {
                if (Minecraft.func_71410_x().field_71462_r == this) {
                    return "Tickrate";
                }
                return String.format("Tickrate: %s", Float.valueOf(TickrateChangerClient.ticksPerSecond));
            }));
            title = "position";
            y += 14;
            if (this.configuration.getProperty(title + "_x", "err").equals("err")) {
                this.setDefaults(title, y);
            }
            lists.add(new InfoLabel(title, Integer.parseInt(this.configuration.getProperty(title + "_x")), Integer.parseInt(this.configuration.getProperty(title + "_y")), Boolean.parseBoolean(this.configuration.getProperty(title + "_visible")), Boolean.parseBoolean(this.configuration.getProperty(title + "_rect")), () -> {
                if (Minecraft.func_71410_x().field_71462_r == this) {
                    return "XYZ";
                }
                return String.format("%.2f %.2f %.2f", Minecraft.func_71410_x().field_71439_g.field_70165_t, Minecraft.func_71410_x().field_71439_g.field_70163_u, Minecraft.func_71410_x().field_71439_g.field_70161_v);
            }));
            title = "position2";
            y += 14;
            if (this.configuration.getProperty(title + "_x", "err").equals("err")) {
                this.setDefaults(title, y);
            }
            lists.add(new InfoLabel(title, Integer.parseInt(this.configuration.getProperty(title + "_x")), Integer.parseInt(this.configuration.getProperty(title + "_y")), Boolean.parseBoolean(this.configuration.getProperty(title + "_visible")), Boolean.parseBoolean(this.configuration.getProperty(title + "_rect")), () -> {
                if (Minecraft.func_71410_x().field_71462_r == this) {
                    return "Precise XYZ";
                }
                return String.format("%f %f %f", Minecraft.func_71410_x().field_71439_g.field_70165_t, Minecraft.func_71410_x().field_71439_g.field_70163_u, Minecraft.func_71410_x().field_71439_g.field_70161_v);
            }));
            title = "chunkpos";
            y += 14;
            if (this.configuration.getProperty(title + "_x", "err").equals("err")) {
                this.setDefaults(title, y);
            }
            lists.add(new InfoLabel(title, Integer.parseInt(this.configuration.getProperty(title + "_x")), Integer.parseInt(this.configuration.getProperty(title + "_y")), Boolean.parseBoolean(this.configuration.getProperty(title + "_visible")), Boolean.parseBoolean(this.configuration.getProperty(title + "_rect")), () -> {
                if (Minecraft.func_71410_x().field_71462_r == this) {
                    return "Chunk Position";
                }
                return String.format("%d %d", Minecraft.func_71410_x().field_71439_g.field_70176_ah, Minecraft.func_71410_x().field_71439_g.field_70164_aj);
            }));
            title = "worldseed";
            y += 14;
            if (this.configuration.getProperty(title + "_x", "err").equals("err")) {
                this.setDefaults(title, y);
            }
            lists.add(new InfoLabel(title, Integer.parseInt(this.configuration.getProperty(title + "_x")), Integer.parseInt(this.configuration.getProperty(title + "_y")), Boolean.parseBoolean(this.configuration.getProperty(title + "_visible")), Boolean.parseBoolean(this.configuration.getProperty(title + "_rect")), () -> {
                if (Minecraft.func_71410_x().field_71462_r == this) {
                    return "Worldseed";
                }
                return "World Seed: " + ((AccessorWorld)Minecraft.func_71410_x().field_71441_e).worldInfo().func_76063_b();
            }));
            y += 14;
            if (TASmod.ktrngHandler.isLoaded()) {
                title = "ktrng_randomseed";
                if (this.configuration.getProperty(title + "_x", "err").equals("err")) {
                    this.setDefaults(title, y);
                }
                lists.add(new InfoLabel(title, Integer.parseInt(this.configuration.getProperty(title + "_x")), Integer.parseInt(this.configuration.getProperty(title + "_y")), Boolean.parseBoolean(this.configuration.getProperty(title + "_visible")), Boolean.parseBoolean(this.configuration.getProperty(title + "_rect")), () -> {
                    if (Minecraft.func_71410_x().field_71462_r == this) {
                        return "KTRNG";
                    }
                    return "RandomSeed: " + TASmod.ktrngHandler.getGlobalSeedClient();
                }));
            }
            title = "facing";
            y += 14;
            if (this.configuration.getProperty(title + "_x", "err").equals("err")) {
                this.setDefaults(title, y);
            }
            lists.add(new InfoLabel(title, Integer.parseInt(this.configuration.getProperty(title + "_x")), Integer.parseInt(this.configuration.getProperty(title + "_y")), Boolean.parseBoolean(this.configuration.getProperty(title + "_visible")), Boolean.parseBoolean(this.configuration.getProperty(title + "_rect")), () -> {
                if (Minecraft.func_71410_x().field_71462_r == this) {
                    return "Facing";
                }
                return String.format("%.2f %.2f", Float.valueOf(CameraInterpolationEvents.rotationYaw), Float.valueOf(CameraInterpolationEvents.rotationPitch));
            }));
            title = "cticks";
            y += 14;
            title = "sticks";
            y += 14;
            title = "nextxyz";
            y += 14;
            if (this.configuration.getProperty(title + "_x", "err").equals("err")) {
                this.setDefaults(title, y);
            }
            lists.add(new InfoLabel(title, Integer.parseInt(this.configuration.getProperty(title + "_x")), Integer.parseInt(this.configuration.getProperty(title + "_y")), Boolean.parseBoolean(this.configuration.getProperty(title + "_visible")), Boolean.parseBoolean(this.configuration.getProperty(title + "_rect")), () -> {
                if (Minecraft.func_71410_x().field_71462_r == this) {
                    return "Predicted Position";
                }
                return String.format("%f %f %f", PlayerPositionCalculator.xNew, PlayerPositionCalculator.yNew, PlayerPositionCalculator.zNew);
            }));
            title = "state";
            y += 14;
            if (this.configuration.getProperty(title + "_x", "err").equals("err")) {
                this.setDefaults(title, y);
            }
            lists.add(new InfoLabel(title, Integer.parseInt(this.configuration.getProperty(title + "_x")), Integer.parseInt(this.configuration.getProperty(title + "_y")), Boolean.parseBoolean(this.configuration.getProperty(title + "_visible")), Boolean.parseBoolean(this.configuration.getProperty(title + "_rect")), () -> {
                if (Minecraft.func_71410_x().field_71462_r == this) {
                    return "State";
                }
                TASstate state = ClientProxy.virtual.getContainer().getState();
                ChatFormatting format = ChatFormatting.WHITE;
                String out = "";
                if (state == TASstate.PLAYBACK) {
                    out = "Playback";
                    format = ChatFormatting.GREEN;
                } else if (state == TASstate.RECORDING) {
                    out = "Recording";
                    format = ChatFormatting.RED;
                } else if (state == TASstate.PAUSED) {
                    out = "Paused";
                    format = ChatFormatting.YELLOW;
                } else if (state == TASstate.NONE) {
                    out = "";
                }
                return String.format("%s%s", format, out);
            }));
            title = "cursor";
            y += 14;
            if (this.configuration.getProperty(title + "_x", "err").equals("err")) {
                this.setDefaults(title, y);
            }
            lists.add(new InfoLabel(title, Integer.parseInt(this.configuration.getProperty(title + "_x")), Integer.parseInt(this.configuration.getProperty(title + "_y")), Boolean.parseBoolean(this.configuration.getProperty(title + "_visible")), Boolean.parseBoolean(this.configuration.getProperty(title + "_rect")), () -> {
                if (Minecraft.func_71410_x().field_71462_r == this) {
                    return "Mouse Position";
                }
                return String.format("Mouse Cursor: " + ClientProxy.virtual.getNextMouse().getPath().get((int)0).cursorX + " " + ClientProxy.virtual.getNextMouse().getPath().get((int)0).cursorY, new Object[0]);
            }));
            title = "trajectories";
            y += 14;
            if (this.configuration.getProperty(title + "_x", "err").equals("err")) {
                this.setDefaults(title, y);
            }
            lists.add(new InfoLabel(title, Integer.parseInt(this.configuration.getProperty(title + "_x")), Integer.parseInt(this.configuration.getProperty(title + "_y")), Boolean.parseBoolean(this.configuration.getProperty(title + "_visible")), Boolean.parseBoolean(this.configuration.getProperty(title + "_rect")), () -> {
                if (Minecraft.func_71410_x().field_71462_r == this) {
                    return "Trajectories";
                }
                String message = "Invalid Item";
                Vec3d vec = TrajectoriesCalculator.calculate();
                if (vec != null) {
                    message = String.format("%.3f %.3f %.3f", vec.field_72450_a, vec.field_72448_b, vec.field_72449_c);
                }
                return String.format("Trajectories: " + message, new Object[0]);
            }));
            title = "velocity";
            y += 14;
            if (this.configuration.getProperty(title + "_x", "err").equals("err")) {
                this.setDefaults(title, y);
            }
            lists.add(new InfoLabel(title, Integer.parseInt(this.configuration.getProperty(title + "_x")), Integer.parseInt(this.configuration.getProperty(title + "_y")), Boolean.parseBoolean(this.configuration.getProperty(title + "_visible")), Boolean.parseBoolean(this.configuration.getProperty(title + "_rect")), () -> {
                if (Minecraft.func_71410_x().field_71462_r == this) {
                    return "Velocity";
                }
                return "Velocity: " + Minecraft.func_71410_x().field_71439_g.field_70159_w + " " + Minecraft.func_71410_x().field_71439_g.field_70181_x + " " + Minecraft.func_71410_x().field_71439_g.field_70179_y;
            }));
            title = "desyncstatus";
            y += 14;
            if (this.configuration.getProperty(title + "_x", "err").equals("err")) {
                this.setDefaults(title, y);
            }
            lists.add(new InfoLabel(title, Integer.parseInt(this.configuration.getProperty(title + "_x")), Integer.parseInt(this.configuration.getProperty(title + "_y")), Boolean.parseBoolean(this.configuration.getProperty(title + "_visible")), Boolean.parseBoolean(this.configuration.getProperty(title + "_rect")), () -> {
                if (Minecraft.func_71410_x().field_71462_r == this) {
                    return "Desync";
                }
                return ClientProxy.virtual.getContainer().dMonitor.getMonitoring(ClientProxy.virtual.getContainer(), Minecraft.func_71410_x().field_71439_g);
            }));
            title = "desyncstatusMotion";
            y += 14;
            if (this.configuration.getProperty(title + "_x", "err").equals("err")) {
                this.setDefaults(title, y);
            }
            lists.add(new InfoLabel(title, Integer.parseInt(this.configuration.getProperty(title + "_x")), Integer.parseInt(this.configuration.getProperty(title + "_y")), Boolean.parseBoolean(this.configuration.getProperty(title + "_visible")), Boolean.parseBoolean(this.configuration.getProperty(title + "_rect")), () -> {
                if (Minecraft.func_71410_x().field_71462_r == this) {
                    return "Desync Motion";
                }
                DesyncMonitoring dMonitor = ClientProxy.virtual.getContainer().dMonitor;
                return dMonitor.getMx() + " " + dMonitor.getMy() + " " + dMonitor.getMz();
            }));
            title = "desyncstatusPos";
            y += 14;
            if (this.configuration.getProperty(title + "_x", "err").equals("err")) {
                this.setDefaults(title, y);
            }
            lists.add(new InfoLabel(title, Integer.parseInt(this.configuration.getProperty(title + "_x")), Integer.parseInt(this.configuration.getProperty(title + "_y")), Boolean.parseBoolean(this.configuration.getProperty(title + "_visible")), Boolean.parseBoolean(this.configuration.getProperty(title + "_rect")), () -> {
                if (Minecraft.func_71410_x().field_71462_r == this) {
                    return "Desync Position";
                }
                DesyncMonitoring dMonitor = ClientProxy.virtual.getContainer().dMonitor;
                return dMonitor.getX() + " " + dMonitor.getY() + " " + dMonitor.getZ();
            }));
            y += 14;
            if (!TASmod.ktrngHandler.isLoaded()) return true;
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return true;
    }

    public void drawHud() {
        if (!ControlByteHandler.hideInfoBox && ClientProxy.virtual.getContainer().isPlayingback()) {
            this.drawRectWithText(ControlByteHandler.text, 10, 10, true);
        }
        if (!ControlByteHandler.shouldRenderHud && ClientProxy.virtual.getContainer().isPlayingback()) {
            return;
        }
        int xpos = 40;
        int ypos = 190;
        for (InfoLabel label : lists) {
            label.tick();
            if (label.visible) {
                this.drawRectWithText(label.renderText, label.x, label.y, label.renderRect);
            } else if (Minecraft.func_71410_x().field_71462_r != null && Minecraft.func_71410_x().field_71462_r.getClass().getSimpleName().contains("InfoHud")) {
                GL11.glPushMatrix();
                GL11.glEnable((int)3042);
                GL11.glBlendFunc((int)770, (int)771);
                Minecraft.func_71410_x().field_71466_p.func_175063_a(label.renderText, (float)(label.x + 2), (float)(label.y + 3), 0x60FFFFFF);
                GL11.glDisable((int)3042);
                GL11.glPopMatrix();
            }
            if (!(Minecraft.func_71410_x().field_71462_r instanceof InfoHud)) continue;
            Minecraft.func_71410_x().field_71466_p.func_175063_a("Leftclick to move", (float)(this.field_146294_l - ypos), (float)(xpos - 30), 0x60FF00);
            Minecraft.func_71410_x().field_71466_p.func_175063_a("Middleclick to enable", (float)(this.field_146294_l - ypos), (float)(xpos - 20), 0x60FF00);
            Minecraft.func_71410_x().field_71466_p.func_175063_a("Rightclick to add black background", (float)(this.field_146294_l - ypos), (float)(xpos - 10), 0x60FF00);
            Minecraft.func_71410_x().field_71466_p.func_175063_a("Hold Shift to snap to grid", (float)(this.field_146294_l - ypos), (float)xpos, 0x60FF00);
        }
    }

    private void drawRectWithText(String text, int x, int y, boolean rect) {
        if (rect) {
            InfoHud.func_73734_a((int)x, (int)y, (int)(x + Minecraft.func_71410_x().field_71466_p.func_78256_a(text) + 4), (int)(y + 14), (int)Integer.MIN_VALUE);
        }
        Minecraft.func_71410_x().field_71466_p.func_175063_a(text, (float)(x + 2), (float)(y + 3), 0xFFFFFF);
        GL11.glEnable((int)3042);
    }

    public static class InfoLabel {
        public String displayName;
        public int x;
        public int y;
        public boolean visible;
        public boolean renderRect;
        public String renderText;
        private Callable<String> text;

        public InfoLabel(String displayName, int x, int y, boolean visible, boolean renderRect, Callable<String> text) {
            this.displayName = displayName;
            this.visible = visible;
            this.x = x;
            this.y = y;
            this.renderRect = renderRect;
            this.text = text;
        }

        public void tick() {
            try {
                this.renderText = this.text.call();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }
}

