/*
 * Decompiled with CFR 0.152.
 */
package com.minecrafttas.tasmod.inputcontainer;

import com.dselent.bigarraylist.BigArrayList;
import com.minecrafttas.tasmod.ClientProxy;
import com.minecrafttas.tasmod.TASmod;
import com.minecrafttas.tasmod.inputcontainer.TASstate;
import com.minecrafttas.tasmod.inputcontainer.TickInputContainer;
import com.minecrafttas.tasmod.inputcontainer.controlbytes.ControlByteHandler;
import com.minecrafttas.tasmod.inputcontainer.server.ContainerStateClient;
import com.minecrafttas.tasmod.monitoring.DesyncMonitoring;
import com.minecrafttas.tasmod.networking.Packet;
import com.minecrafttas.tasmod.networking.PacketSide;
import com.minecrafttas.tasmod.tickratechanger.TickrateChangerClient;
import com.minecrafttas.tasmod.virtual.VirtualKeyboard;
import com.minecrafttas.tasmod.virtual.VirtualMouse;
import com.minecrafttas.tasmod.virtual.VirtualSubticks;
import com.mojang.realmsclient.gui.ChatFormatting;
import com.mojang.realmsclient.util.Pair;
import java.io.File;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.EntityPlayerSP;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import net.minecraft.util.text.TextFormatting;
import org.lwjgl.opengl.Display;

public class InputContainer {
    private TASstate state = TASstate.NONE;
    private TASstate tempPause = TASstate.NONE;
    private int index;
    private VirtualKeyboard keyboard = new VirtualKeyboard();
    private VirtualMouse mouse = new VirtualMouse();
    private VirtualSubticks subticks = new VirtualSubticks();
    public final File directory;
    private BigArrayList<TickInputContainer> inputs;
    private Map<Integer, List<Pair<String, String[]>>> controlBytes;
    private Map<Integer, List<String>> comments;
    public DesyncMonitoring dMonitor;
    private String title;
    private String authors;
    private String playtime;
    private int rerecords;
    private String startLocation;
    private long startSeed;
    private boolean creditsPrinted;
    private Integer playUntil;

    public InputContainer() {
        this.directory = new File(Minecraft.func_71410_x().field_71412_D.getAbsolutePath() + File.separator + "saves" + File.separator + "tasfiles");
        this.inputs = new BigArrayList(this.directory + File.separator + "temp");
        this.controlBytes = new HashMap<Integer, List<Pair<String, String[]>>>();
        this.comments = new HashMap<Integer, List<String>>();
        this.dMonitor = new DesyncMonitoring();
        this.title = "Insert TAS category here";
        this.authors = "Insert author here";
        this.playtime = "00:00.0";
        this.rerecords = 0;
        this.startLocation = "";
        this.startSeed = TASmod.ktrngHandler.getGlobalSeedClient();
        this.creditsPrinted = false;
        this.playUntil = null;
    }

    public String setTASState(TASstate stateIn) {
        return this.setTASState(stateIn, true);
    }

    public String setTASState(TASstate stateIn, boolean verbose) {
        ControlByteHandler.reset();
        if (this.state == stateIn) {
            switch (stateIn) {
                case PLAYBACK: {
                    return verbose ? TextFormatting.RED + "A playback is already running" : "";
                }
                case RECORDING: {
                    return verbose ? TextFormatting.RED + "A recording is already running" : "";
                }
                case PAUSED: {
                    return verbose ? TextFormatting.RED + "The game is already paused" : "";
                }
                case NONE: {
                    return verbose ? TextFormatting.RED + "Nothing is running" : "";
                }
            }
        } else if (this.state == TASstate.NONE) {
            switch (stateIn) {
                case PLAYBACK: {
                    if (Minecraft.func_71410_x().field_71439_g != null && !this.startLocation.isEmpty()) {
                        try {
                            this.tpPlayer(this.startLocation);
                        }
                        catch (NumberFormatException e) {
                            this.state = TASstate.NONE;
                            e.printStackTrace();
                            return verbose ? TextFormatting.RED + "An error occured while reading the start location of the TAS. The file might be broken" : "";
                        }
                    }
                    Minecraft.func_71410_x().field_71474_y.field_74359_p = false;
                    this.index = 0;
                    this.state = TASstate.PLAYBACK;
                    this.creditsPrinted = false;
                    TASmod.ktrngHandler.setInitialSeed(this.startSeed);
                    return verbose ? TextFormatting.GREEN + "Starting playback" : "";
                }
                case RECORDING: {
                    if (Minecraft.func_71410_x().field_71439_g != null && this.startLocation.isEmpty()) {
                        this.startLocation = this.getStartLocation(Minecraft.func_71410_x().field_71439_g);
                    }
                    this.state = TASstate.RECORDING;
                    return verbose ? TextFormatting.GREEN + "Starting a recording" : "";
                }
                case PAUSED: {
                    return verbose ? TextFormatting.RED + "Can't pause anything because nothing is running" : "";
                }
                case NONE: {
                    return TextFormatting.RED + "Please report this message to the mod author, because you should never be able to see this (Error: None)";
                }
            }
        } else if (this.state == TASstate.RECORDING) {
            switch (stateIn) {
                case PLAYBACK: {
                    return verbose ? TextFormatting.RED + "A recording is currently running. Please stop the recording first before starting a playback" : "";
                }
                case RECORDING: {
                    return TextFormatting.RED + "Please report this message to the mod author, because you should never be able to see this (Error: Recording)";
                }
                case PAUSED: {
                    this.state = TASstate.PAUSED;
                    this.tempPause = TASstate.RECORDING;
                    return verbose ? TextFormatting.GREEN + "Pausing a recording" : "";
                }
                case NONE: {
                    ClientProxy.virtual.unpressEverything();
                    this.state = TASstate.NONE;
                    return verbose ? TextFormatting.GREEN + "Stopping the recording" : "";
                }
            }
        } else if (this.state == TASstate.PLAYBACK) {
            switch (stateIn) {
                case PLAYBACK: {
                    return TextFormatting.RED + "Please report this message to the mod author, because you should never be able to see this (Error: Playback)";
                }
                case RECORDING: {
                    return verbose ? TextFormatting.RED + "A playback is currently running. Please stop the playback first before starting a recording" : "";
                }
                case PAUSED: {
                    this.state = TASstate.PAUSED;
                    this.tempPause = TASstate.PLAYBACK;
                    ClientProxy.virtual.unpressEverything();
                    return verbose ? TextFormatting.GREEN + "Pausing a playback" : "";
                }
                case NONE: {
                    Minecraft.func_71410_x().field_71474_y.field_74359_p = true;
                    ClientProxy.virtual.unpressEverything();
                    this.state = TASstate.NONE;
                    return verbose ? TextFormatting.GREEN + "Stopping the playback" : "";
                }
            }
        } else if (this.state == TASstate.PAUSED) {
            switch (stateIn) {
                case PLAYBACK: {
                    this.state = TASstate.PLAYBACK;
                    this.tempPause = TASstate.NONE;
                    return verbose ? TextFormatting.GREEN + "Resuming a playback" : "";
                }
                case RECORDING: {
                    this.state = TASstate.RECORDING;
                    this.tempPause = TASstate.NONE;
                    return verbose ? TextFormatting.GREEN + "Resuming a recording" : "";
                }
                case PAUSED: {
                    return TextFormatting.RED + "Please report this message to the mod author, because you should never be able to see this (Error: Paused)";
                }
                case NONE: {
                    this.state = TASstate.NONE;
                    TASstate statey = this.tempPause;
                    this.tempPause = TASstate.NONE;
                    return TextFormatting.GREEN + "Aborting a " + statey.toString().toLowerCase() + " that was paused";
                }
            }
        }
        return "Something went wrong ._.";
    }

    public TASstate togglePause() {
        if (this.state != TASstate.PAUSED) {
            this.setTASState(TASstate.PAUSED);
        } else {
            this.setTASState(this.tempPause);
        }
        return this.state;
    }

    public void pause(boolean pause) {
        if (pause) {
            if (this.state != TASstate.NONE) {
                this.setTASState(TASstate.PAUSED, false);
            }
        } else if (this.state == TASstate.PAUSED) {
            this.setTASState(this.tempPause, false);
        }
    }

    public boolean isPlayingback() {
        return this.state == TASstate.PLAYBACK;
    }

    public boolean isRecording() {
        return this.state == TASstate.RECORDING;
    }

    public boolean isPaused() {
        return this.state == TASstate.PAUSED;
    }

    public boolean isNothingPlaying() {
        return this.state == TASstate.NONE;
    }

    public TASstate getState() {
        return this.state;
    }

    public VirtualKeyboard addKeyboardToContainer(VirtualKeyboard keyboard) {
        if (this.state == TASstate.RECORDING) {
            this.keyboard = keyboard.clone();
        } else if (this.state == TASstate.PLAYBACK) {
            keyboard = this.keyboard.clone();
        }
        return keyboard;
    }

    public VirtualMouse addMouseToContainer(VirtualMouse mouse) {
        if (this.state == TASstate.RECORDING) {
            this.mouse = mouse.clone();
        } else if (this.state == TASstate.PLAYBACK) {
            mouse = this.mouse.clone();
        }
        return mouse;
    }

    public VirtualSubticks addSubticksToContainer(VirtualSubticks subticks) {
        if (this.state == TASstate.RECORDING) {
            this.subticks = subticks.clone();
        } else if (this.state == TASstate.PLAYBACK) {
            subticks = this.subticks.clone();
        }
        return subticks;
    }

    public void nextTick() {
        EntityPlayerSP player = Minecraft.func_71410_x().field_71439_g;
        if (player != null && player.field_70175_ag && this.isPaused() && this.tempPause != TASstate.NONE) {
            ContainerStateClient.setOrSend(this.tempPause);
            this.pause(false);
            this.printCredits();
        }
        if (this.state == TASstate.RECORDING) {
            this.recordNextTick();
        } else if (this.state == TASstate.PLAYBACK) {
            this.playbackNextTick();
        }
    }

    private void recordNextTick() {
        ++this.index;
        if (this.inputs.size() <= (long)this.index) {
            this.inputs.add(new TickInputContainer(this.index, this.keyboard.clone(), this.mouse.clone(), this.subticks.clone()));
        } else {
            this.inputs.set(this.index, new TickInputContainer(this.index, this.keyboard.clone(), this.mouse.clone(), this.subticks.clone()));
        }
        this.dMonitor.recordMonitor();
    }

    private void playbackNextTick() {
        if (!Display.isActive()) {
            this.setTASState(TASstate.NONE);
        }
        ++this.index;
        if (this.playUntil != null && this.playUntil == this.index + 1) {
            TickrateChangerClient.pauseGame(true);
            this.playUntil = null;
            this.setTASState(TASstate.NONE);
            for (long i = this.inputs.size() - 1L; i >= (long)(this.index + 1); --i) {
                this.inputs.remove(i);
            }
            this.setTASState(TASstate.RECORDING);
        }
        if ((long)this.index >= this.inputs.size()) {
            this.unpressContainer();
            ContainerStateClient.setOrSend(TASstate.NONE);
        } else {
            TickInputContainer tickcontainer = this.inputs.get(this.index);
            this.keyboard = tickcontainer.getKeyboard().clone();
            this.mouse = tickcontainer.getMouse().clone();
            this.subticks = tickcontainer.getSubticks().clone();
            ControlByteHandler.readCotrolByte(this.controlBytes.get(this.index));
        }
    }

    public int size() {
        return (int)this.inputs.size();
    }

    public boolean isEmpty() {
        return this.inputs.isEmpty();
    }

    public int index() {
        return this.index;
    }

    public BigArrayList<TickInputContainer> getInputs() {
        return this.inputs;
    }

    public Map<Integer, List<Pair<String, String[]>>> getControlBytes() {
        return this.controlBytes;
    }

    public Map<Integer, List<String>> getComments() {
        return this.comments;
    }

    public void setIndex(int index) throws IndexOutOfBoundsException {
        if (index <= this.size()) {
            this.index = index;
            if (this.state == TASstate.PLAYBACK) {
                TickInputContainer tickcontainer = this.inputs.get(index);
                this.keyboard = tickcontainer.getKeyboard();
                this.mouse = tickcontainer.getMouse();
                this.subticks = tickcontainer.getSubticks();
            }
        } else {
            throw new IndexOutOfBoundsException("Index is bigger than the container");
        }
    }

    public TickInputContainer get(int index) {
        TickInputContainer tickcontainer = null;
        try {
            tickcontainer = this.inputs.get(index);
        }
        catch (IndexOutOfBoundsException e) {
            return null;
        }
        return tickcontainer;
    }

    public void clear() {
        this.inputs = new BigArrayList(this.directory + File.separator + "temp");
        this.controlBytes.clear();
        this.comments.clear();
        this.index = 0;
        this.startLocation = "";
        this.dMonitor.getPos().clear();
        this.clearCredits();
    }

    private void clearCredits() {
        this.title = "Insert Author here";
        this.authors = "Insert author here";
        this.playtime = "00:00.0";
        this.rerecords = 0;
    }

    public String toString() {
        if (this.inputs.isEmpty()) {
            return "null";
        }
        String out = "";
        int i = 0;
        while ((long)i < this.inputs.size()) {
            out = out.concat(this.inputs.get(i).toString() + "\n");
            ++i;
        }
        return out;
    }

    public String getAuthors() {
        return this.authors;
    }

    public void setAuthors(String authors) {
        this.authors = authors;
    }

    public String getTitle() {
        return this.title;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public int getRerecords() {
        return this.rerecords;
    }

    public void setRerecords(int rerecords) {
        this.rerecords = rerecords;
    }

    public String getPlaytime() {
        return this.playtime;
    }

    public void setPlaytime(String playtime) {
        this.playtime = playtime;
    }

    public void setSavestates(String playtime) {
        this.playtime = playtime;
    }

    public void fixTicks() {
        int i = 0;
        while ((long)i < this.inputs.size()) {
            this.inputs.get(i).setTick(i + 1);
            ++i;
        }
    }

    public long getStartSeed() {
        return this.startSeed;
    }

    public void setStartSeed(long startSeed) {
        this.startSeed = startSeed;
    }

    public String getStartLocation() {
        return this.startLocation;
    }

    public void setStartLocation(String startLocation) {
        this.startLocation = startLocation;
    }

    private String getStartLocation(EntityPlayerSP player) {
        String pos = player.field_70165_t + "," + player.field_70163_u + "," + player.field_70161_v;
        String pitch = Float.toString(player.field_70125_A);
        String yaw = Float.toString(player.field_70177_z);
        return pos + "," + yaw + "," + pitch;
    }

    private void tpPlayer(String startLocation) throws NumberFormatException {
        String[] section = startLocation.split(",");
        double x = Double.parseDouble(section[0]);
        double y = Double.parseDouble(section[1]);
        double z = Double.parseDouble(section[2]);
        float angleYaw = Float.parseFloat(section[3]);
        float anglePitch = Float.parseFloat(section[4]);
        ClientProxy.packetClient.sendToServer(new TeleportPlayerPacket(x, y, z, angleYaw, anglePitch));
    }

    public void unpressContainer() {
        this.keyboard.clear();
        this.mouse.clear();
    }

    public void printCredits() {
        if (this.state == TASstate.PLAYBACK && !this.creditsPrinted) {
            this.creditsPrinted = true;
            this.printMessage(this.title, ChatFormatting.GOLD);
            this.printMessage("", null);
            this.printMessage("by " + this.authors, ChatFormatting.AQUA);
            this.printMessage("", null);
            this.printMessage("in " + this.playtime, null);
            this.printMessage("", null);
            this.printMessage("Rerecords: " + this.rerecords, null);
        }
    }

    private void printMessage(String msg, ChatFormatting format) {
        String formatString = "";
        if (format != null) {
            formatString = format.toString();
        }
        Minecraft.func_71410_x().field_71456_v.func_146158_b().func_146227_a((ITextComponent)new TextComponentString(formatString + msg));
    }

    public void setPlayUntil(int until) {
        this.playUntil = until;
    }

    public static class TeleportPlayerPacket
    implements Packet {
        double x;
        double y;
        double z;
        float angleYaw;
        float anglePitch;

        public TeleportPlayerPacket(double x, double y, double z, float angleYaw, float anglePitch) {
            this.x = x;
            this.y = y;
            this.z = z;
            this.angleYaw = angleYaw;
            this.anglePitch = anglePitch;
        }

        public TeleportPlayerPacket() {
        }

        @Override
        public void handle(PacketSide side, EntityPlayer playerz) {
            if (side.isServer()) {
                EntityPlayerMP player = (EntityPlayerMP)playerz;
                player.func_71121_q().func_152344_a(() -> {
                    player.field_70125_A = this.anglePitch;
                    player.field_70177_z = this.angleYaw;
                    player.func_70634_a(this.x, this.y, this.z);
                });
            }
        }

        @Override
        public void serialize(PacketBuffer buf) {
            buf.writeDouble(this.x);
            buf.writeDouble(this.y);
            buf.writeDouble(this.z);
            buf.writeFloat(this.angleYaw);
            buf.writeFloat(this.anglePitch);
        }

        @Override
        public void deserialize(PacketBuffer buf) {
            this.x = buf.readDouble();
            this.y = buf.readDouble();
            this.z = buf.readDouble();
            this.angleYaw = buf.readFloat();
            this.anglePitch = buf.readFloat();
        }
    }
}

