/*
 * Decompiled with CFR 0.152.
 */
package com.minecrafttas.tasmod.inputcontainer;

import com.minecrafttas.tasmod.virtual.VirtualKeyboard;
import com.minecrafttas.tasmod.virtual.VirtualMouse;
import com.minecrafttas.tasmod.virtual.VirtualSubticks;
import java.io.Serializable;

public class TickInputContainer
implements Serializable {
    private static final long serialVersionUID = -3420565284438152474L;
    private int tick;
    private VirtualKeyboard keyboard;
    private VirtualMouse mouse;
    private VirtualSubticks subticks;

    public TickInputContainer(int tick, VirtualKeyboard keyboard, VirtualMouse mouse, VirtualSubticks subticks) {
        this.tick = tick;
        this.keyboard = keyboard;
        this.mouse = mouse;
        this.subticks = subticks;
    }

    public TickInputContainer(int tick) {
        this.tick = tick;
        this.keyboard = new VirtualKeyboard();
        this.mouse = new VirtualMouse();
        this.subticks = new VirtualSubticks(0.0f, 0.0f);
    }

    public String toString() {
        return this.tick + "|" + this.keyboard.toString() + "|" + this.mouse.toString() + "|" + this.subticks.toString();
    }

    public VirtualKeyboard getKeyboard() {
        return this.keyboard;
    }

    public VirtualMouse getMouse() {
        return this.mouse;
    }

    public VirtualSubticks getSubticks() {
        return this.subticks;
    }

    public int getTick() {
        return this.tick;
    }

    public void setTick(int tick) {
        this.tick = tick;
    }

    public TickInputContainer clone() {
        return new TickInputContainer(this.tick, this.keyboard, this.mouse, this.subticks);
    }
}

