/*
 * Decompiled with CFR 0.152.
 */
package com.minecrafttas.tasmod.inputcontainer.server;

import com.minecrafttas.tasmod.TASmod;
import com.minecrafttas.tasmod.inputcontainer.TASstate;
import com.minecrafttas.tasmod.inputcontainer.server.SyncStatePacket;
import com.minecrafttas.tasmod.networking.Packet;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.server.MinecraftServer;

public class ContainerStateServer {
    private TASstate state = TASstate.NONE;
    private boolean shouldChange = true;

    public void onInitialPacket(EntityPlayerMP player, TASstate tasState) {
        if (player.func_70003_b(2, "") && this.shouldChange) {
            this.setState(tasState);
            this.shouldChange = false;
        } else {
            TASmod.packetServer.sendTo((Packet)new SyncStatePacket(tasState), player);
        }
    }

    public void onPacket(EntityPlayerMP player, TASstate tasState) {
        if (player.func_70003_b(2, "")) {
            this.setState(tasState);
        }
    }

    public void leaveServer(EntityPlayerMP player) {
        MinecraftServer server = TASmod.getServerInstance();
        if (server != null && server.func_184103_al().func_181057_v().size() == 1) {
            this.state = TASstate.NONE;
            this.shouldChange = true;
        }
    }

    public void setState(TASstate stateIn) {
        this.setServerState(stateIn);
        TASmod.packetServer.sendToAll(new SyncStatePacket(this.state, true));
    }

    public void setServerState(TASstate stateIn) {
        if (this.state != stateIn) {
            if (this.state == TASstate.RECORDING && stateIn == TASstate.PLAYBACK || this.state == TASstate.PLAYBACK && stateIn == TASstate.RECORDING) {
                return;
            }
            if (this.state == TASstate.NONE && this.state == TASstate.PAUSED) {
                return;
            }
            this.state = stateIn;
            TASmod.logger.info(String.format("Set the server state to %s", stateIn.toString()));
        }
    }

    public void toggleRecording() {
        this.setState(this.state == TASstate.RECORDING ? TASstate.NONE : TASstate.RECORDING);
    }

    public void togglePlayback() {
        this.setState(this.state == TASstate.PLAYBACK ? TASstate.NONE : TASstate.PLAYBACK);
    }

    public TASstate getState() {
        return this.state;
    }
}

