/*
 * Decompiled with CFR 0.152.
 */
package com.minecrafttas.tasmod.inputcontainer.server;

import com.minecrafttas.tasmod.ClientProxy;
import com.minecrafttas.tasmod.TASmod;
import com.minecrafttas.tasmod.inputcontainer.InputContainer;
import com.minecrafttas.tasmod.inputcontainer.TASstate;
import com.minecrafttas.tasmod.networking.Packet;
import com.minecrafttas.tasmod.networking.PacketSide;
import com.minecrafttas.tasmod.util.TickScheduler;
import net.minecraft.client.Minecraft;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;

public class SyncStatePacket
implements Packet {
    private short state;
    private boolean verbose;

    public SyncStatePacket() {
        this.state = 0;
    }

    public SyncStatePacket(TASstate state) {
        this.verbose = true;
        this.state = (short)state.getIndex();
    }

    public SyncStatePacket(TASstate state, boolean verbose) {
        this.verbose = verbose;
        this.state = (short)state.getIndex();
    }

    @Override
    public void serialize(PacketBuffer buf) {
        buf.writeShort((int)this.state);
        buf.writeBoolean(this.verbose);
    }

    @Override
    public void deserialize(PacketBuffer buf) {
        this.state = buf.readShort();
        this.verbose = buf.readBoolean();
    }

    protected TASstate getState() {
        return TASstate.fromIndex(this.state);
    }

    public boolean isVerbose() {
        return this.verbose;
    }

    @Override
    public void handle(PacketSide side, EntityPlayer player) {
        if (side.isServer()) {
            TASmod.containerStateServer.onPacket((EntityPlayerMP)player, this.getState());
        } else {
            TASstate state = this.getState();
            TickScheduler.TickTask task = () -> {
                String chatMessage;
                InputContainer container = ClientProxy.virtual.getContainer();
                if (state != container.getState() && !(chatMessage = container.setTASState(state, this.verbose)).isEmpty()) {
                    Minecraft.func_71410_x().field_71456_v.func_146158_b().func_146227_a((ITextComponent)new TextComponentString(chatMessage));
                }
            };
            if (state == TASstate.RECORDING || state == TASstate.PLAYBACK) {
                ClientProxy.tickSchedulerClient.add(task);
            } else {
                ClientProxy.gameLoopSchedulerClient.add(task);
            }
        }
    }
}

