/*
 * Decompiled with CFR 0.152.
 */
package com.minecrafttas.tasmod.ktrng;

import com.minecrafttas.tasmod.ClientProxy;
import com.minecrafttas.tasmod.TASmod;
import com.minecrafttas.tasmod.inputcontainer.TASstate;
import com.minecrafttas.tasmod.ktrng.KTRNGMonitor;
import com.minecrafttas.tasmod.ktrng.KTRNGSeedPacket;
import com.minecrafttas.tasmod.ktrng.KTRNGStartSeedPacket;
import de.scribble.lp.killtherng.KillTheRNG;
import de.scribble.lp.killtherng.SeedingModes;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class KillTheRNGHandler {
    private boolean isLoaded;

    public KillTheRNGHandler(boolean isLoaded) {
        this.isLoaded = isLoaded;
        if (isLoaded) {
            KillTheRNG.LOGGER.info("Connection established with TASmod");
            KillTheRNG.isLibrary = true;
            KillTheRNG.mode = SeedingModes.TickChange;
            KillTheRNG.annotations.register((Object)new KTRNGMonitor());
        } else {
            TASmod.logger.info("KillTheRNG doesn't appear to be loaded");
        }
    }

    public long advanceGlobalSeedServer() {
        if (this.isLoaded()) {
            return KillTheRNG.commonRandom.nextSeed();
        }
        return 0L;
    }

    public long getGlobalSeedServer() {
        if (this.isLoaded()) {
            return KillTheRNG.commonRandom.GlobalServer.getSeed();
        }
        return 0L;
    }

    public boolean isLoaded() {
        return this.isLoaded;
    }

    @SideOnly(value=Side.CLIENT)
    public long getGlobalSeedClient() {
        if (this.isLoaded()) {
            return KillTheRNG.clientRandom.GlobalClient.getSeed();
        }
        return 0L;
    }

    @SideOnly(value=Side.CLIENT)
    public void setGlobalSeedClient(long seedIn) {
        if (this.isLoaded()) {
            KillTheRNG.clientRandom.setSeedAll(seedIn);
        }
    }

    public void setGlobalSeedServer(long seedIn) {
        if (this.isLoaded()) {
            KillTheRNG.commonRandom.setSeedAll(seedIn);
        }
    }

    @SideOnly(value=Side.CLIENT)
    public void sendGlobalSeedToServer(long seedIn) {
        if (this.isLoaded()) {
            if (ClientProxy.packetClient != null) {
                ClientProxy.packetClient.sendToServer(new KTRNGSeedPacket(seedIn));
            } else {
                this.setGlobalSeedClient(seedIn);
            }
        }
    }

    @SideOnly(value=Side.CLIENT)
    public void updateClient() {
    }

    public void updateServer() {
        if (this.isLoaded() && TASmod.containerStateServer.getState() != TASstate.PAUSED) {
            TASmod.packetServer.sendToAll(new KTRNGSeedPacket(this.advanceGlobalSeedServer()));
        }
    }

    public void broadcastStartSeed() {
        if (this.isLoaded()) {
            long seed = this.getGlobalSeedServer();
            TASmod.packetServer.sendToAll(new KTRNGStartSeedPacket(seed));
        }
    }

    @SideOnly(value=Side.CLIENT)
    public void setInitialSeed() {
        this.setInitialSeed(this.getGlobalSeedClient());
    }

    @SideOnly(value=Side.CLIENT)
    public void setInitialSeed(long initialSeed) {
        if (ClientProxy.packetClient != null) {
            TASmod.logger.info("Sending initial client seed: {}", (Object)initialSeed);
            ClientProxy.packetClient.sendToServer(new KTRNGStartSeedPacket(initialSeed));
        } else {
            TASmod.ktrngHandler.setGlobalSeedClient(initialSeed);
        }
    }
}

