/*
 * Decompiled with CFR 0.152.
 */
package com.minecrafttas.tasmod.monitoring;

import com.minecrafttas.tasmod.inputcontainer.InputContainer;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.EntityPlayerSP;
import net.minecraft.util.text.TextFormatting;

public class DesyncMonitoring {
    private List<String> pos = new ArrayList<String>();
    private String lastDesync = "";
    private String x;
    private String y;
    private String z;
    private String Mx;
    private String My;
    private String Mz;

    public void recordMonitor() {
        EntityPlayerSP player = Minecraft.func_71410_x().field_71439_g;
        if (player != null) {
            this.pos.add(player.field_70165_t + " " + player.field_70163_u + " " + player.field_70161_v + " " + player.field_70159_w + " " + player.field_70181_x + " " + player.field_70179_y);
        } else {
            this.pos.add("0 0 0 0 0 0 0");
        }
    }

    public List<String> getPos() {
        return this.pos;
    }

    public void setPos(List<String> pos) {
        this.pos = pos;
    }

    public String get(int index) {
        String out = "";
        try {
            out = this.pos.get(index);
        }
        catch (IndexOutOfBoundsException e) {
            return "";
        }
        return out;
    }

    public String getMonitoring(InputContainer inputContainer, EntityPlayerSP player) {
        boolean isModerate;
        TextFormatting format;
        boolean isWarning;
        boolean isEqual;
        int index = inputContainer.index() - 1;
        String position = this.get(index);
        if (position.isEmpty()) {
            this.clearDelta();
            return TextFormatting.GRAY + "Empty";
        }
        if (inputContainer.isNothingPlaying()) {
            return this.lastDesync;
        }
        String[] split = position.split(" ");
        double x = 0.0;
        double y = 0.0;
        double z = 0.0;
        double mx = 0.0;
        double my = 0.0;
        double mz = 0.0;
        try {
            x = Double.parseDouble(split[0]);
            y = Double.parseDouble(split[1]);
            z = Double.parseDouble(split[2]);
            mx = Double.parseDouble(split[3]);
            my = Double.parseDouble(split[4]);
            mz = Double.parseDouble(split[5]);
        }
        catch (Exception e) {
            return TextFormatting.DARK_PURPLE + "Error";
        }
        boolean bl = isEqual = player.field_70165_t == x && player.field_70163_u == y && player.field_70161_v == z && player.field_70159_w == mx && player.field_70181_x == my && player.field_70179_y == mz;
        if (isEqual) {
            this.x = "";
            this.y = "";
            this.z = "";
            this.Mx = "";
            this.My = "";
            this.Mz = "";
            this.lastDesync = TextFormatting.GREEN + "In sync";
            return this.lastDesync;
        }
        double dx = 0.0;
        double dy = 0.0;
        double dz = 0.0;
        double dMx = 0.0;
        double dMy = 0.0;
        double dMz = 0.0;
        dx = player.field_70165_t - x;
        dy = player.field_70163_u - y;
        dz = player.field_70161_v - z;
        dMx = player.field_70159_w - mx;
        dMy = player.field_70181_x - my;
        dMz = player.field_70179_y - mz;
        boolean bl2 = isWarning = Math.abs(dx) < 1.0E-5 && Math.abs(dy) < 1.0E-5 && Math.abs(dz) < 1.0E-5 && Math.abs(dMx) < 1.0E-5 && Math.abs(dMy) < 1.0E-5 && Math.abs(dMz) < 1.0E-5;
        if (dx != 0.0) {
            format = this.desyncColor(dx);
            this.x = format + " X: " + dx;
        } else {
            this.x = "";
        }
        if (dy != 0.0) {
            format = this.desyncColor(dy);
            this.y = format + " Y: " + dy;
        } else {
            this.y = "";
        }
        if (dz != 0.0) {
            format = this.desyncColor(dz);
            this.z = format + " Z: " + dz;
        } else {
            this.z = "";
        }
        if (dMx != 0.0) {
            format = this.desyncColor(dMx);
            this.Mx = format + " MotionX: " + dMx;
        } else {
            this.Mx = "";
        }
        if (dMy != 0.0) {
            format = this.desyncColor(dMy);
            this.My = format + " MotionY: " + dMy;
        } else {
            this.My = "";
        }
        if (dMz != 0.0) {
            format = this.desyncColor(dMz);
            this.Mz = format + " MotionZ: " + dMz;
        } else {
            this.Mz = "";
        }
        if (isWarning) {
            this.lastDesync = TextFormatting.YELLOW + "Slight desync ";
            return this.lastDesync;
        }
        boolean bl3 = isModerate = Math.abs(dx) < 0.01 && Math.abs(dy) < 0.01 && Math.abs(dz) < 0.01 && Math.abs(dMx) < 0.01 && Math.abs(dMy) < 0.01 && Math.abs(dMz) < 0.01;
        if (isModerate) {
            this.lastDesync = TextFormatting.RED + "Moderate desync ";
            return this.lastDesync;
        }
        this.lastDesync = TextFormatting.DARK_RED + "Total desync ";
        return this.lastDesync;
    }

    private TextFormatting desyncColor(double val) {
        if ((val = Math.abs(val)) > 0.0 && val < 1.0E-5) {
            return TextFormatting.YELLOW;
        }
        if (val > 1.0E-5 && val < 0.01) {
            return TextFormatting.RED;
        }
        return TextFormatting.DARK_RED;
    }

    public String getX() {
        return this.x;
    }

    public String getY() {
        return this.y;
    }

    public String getZ() {
        return this.z;
    }

    public String getMx() {
        return this.Mx;
    }

    public String getMy() {
        return this.My;
    }

    public String getMz() {
        return this.Mz;
    }

    private void clearDelta() {
        this.x = "";
        this.y = "";
        this.z = "";
        this.Mx = "";
        this.My = "";
        this.Mz = "";
    }
}

