/*
 * Decompiled with CFR 0.152.
 */
package com.minecrafttas.tasmod.networking;

import com.minecrafttas.tasmod.TASmod;
import com.minecrafttas.tasmod.networking.Packet;
import io.netty.buffer.Unpooled;
import java.util.ArrayList;
import net.minecraft.network.PacketBuffer;

public class PacketSerializer {
    private static ArrayList<Class<? extends Packet>> REGISTRY = new ArrayList();

    public static Packet deserialize(PacketBuffer buf) {
        int packetId = buf.readInt();
        Packet packet = null;
        try {
            packet = REGISTRY.get(packetId).newInstance();
        }
        catch (InstantiationException e) {
            e.printStackTrace();
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
        }
        if (packet == null) {
            TASmod.logger.warn("Unregistered packet received! Packet Id: " + packetId);
            return null;
        }
        packet.deserialize(buf);
        return packet;
    }

    public static PacketBuffer serialize(Packet packet) {
        PacketBuffer buf = new PacketBuffer(Unpooled.buffer());
        int packetID = REGISTRY.indexOf(packet.getClass());
        if (packetID == -1) {
            TASmod.logger.warn("Unregistered packet was trying to be serialized! Packet Class: " + packet.getClass().getSimpleName());
            return null;
        }
        buf.writeInt(packetID);
        packet.serialize(buf);
        return buf;
    }

    public static void registerPacket(Class<? extends Packet> packet) {
        if (REGISTRY.contains(packet)) {
            TASmod.logger.warn("Trying to register packet which already exists: " + packet.getClass().getSimpleName());
        }
        REGISTRY.add(packet);
    }

    public static void unregisterPacket(Class<? extends Packet> packet) {
        if (REGISTRY.contains(packet)) {
            TASmod.logger.warn("Trying to unregister packet which doesn't exist in the registry: " + packet.getClass().getSimpleName());
        }
        REGISTRY.remove(packet);
    }
}

