/*
 * Decompiled with CFR 0.152.
 */
package com.minecrafttas.tasmod.networking;

import com.minecrafttas.tasmod.ClientProxy;
import com.minecrafttas.tasmod.networking.IdentificationPacket;
import com.minecrafttas.tasmod.networking.Packet;
import com.minecrafttas.tasmod.networking.PacketSerializer;
import com.minecrafttas.tasmod.networking.PacketSide;
import io.netty.buffer.Unpooled;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.EOFException;
import java.io.IOException;
import java.io.InterruptedIOException;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.net.SocketException;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.LinkedBlockingQueue;
import net.minecraft.client.Minecraft;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.network.PacketBuffer;
import org.apache.logging.log4j.Logger;

public class TASmodNetworkClient {
    private Logger logger;
    private Thread clientThread;
    private Socket clientSocket;
    private BlockingQueue<Packet> packetsToSend = new LinkedBlockingQueue<Packet>();
    private boolean ready = false;

    public TASmodNetworkClient(Logger logger) {
        this(logger, "127.0.0.1", 3111);
    }

    public TASmodNetworkClient(Logger logger, String serverIP, int port) {
        this.logger = logger;
        this.logger.info("Trying to connect to {}:{}", (Object)serverIP, (Object)port);
        this.createClient(serverIP, port);
    }

    public void sendToServer(Packet packet) {
        if (this.clientThread == null) {
            return;
        }
        if (!this.clientThread.isAlive()) {
            return;
        }
        this.packetsToSend.add(packet);
    }

    private void createClient(String serverIp, int port) {
        this.packetsToSend.add(new IdentificationPacket(Minecraft.func_71410_x().field_71439_g.func_110124_au()));
        this.clientThread = new Thread(() -> {
            try (Socket cSocket = new Socket();){
                cSocket.connect(new InetSocketAddress(serverIp, port));
                this.clientSocket = cSocket;
                this.clientSocket.setTcpNoDelay(true);
                DataInputStream inputStream = new DataInputStream(new BufferedInputStream(this.clientSocket.getInputStream()));
                this.createSendThread();
                while (this.clientSocket.isConnected()) {
                    int packetSize = inputStream.readInt();
                    byte[] packetData = new byte[packetSize];
                    inputStream.read(packetData, 0, packetSize);
                    PacketBuffer packetBuf = new PacketBuffer(Unpooled.wrappedBuffer((byte[])packetData));
                    Packet packet = PacketSerializer.deserialize(packetBuf);
                    packet.handle(PacketSide.CLIENT, (EntityPlayer)Minecraft.func_71410_x().field_71439_g);
                    this.logger.trace("Handled a " + packet.getClass().getSimpleName() + " from the socket.");
                }
            }
            catch (EOFException | InterruptedIOException | SocketException exception) {
                this.logger.info("Custom TASmod client was shutdown");
            }
            catch (Exception exception) {
                this.logger.error("Custom TASmod client was unexpectedly shutdown {}", (Throwable)exception);
                exception.printStackTrace();
                ClientProxy.gameLoopSchedulerClient.add(() -> {
                    throw new RuntimeException("TASmod networking was shut down. The real errors are above");
                });
            }
        });
        this.clientThread.setName("TASmod Network Client Accept");
        this.clientThread.setDaemon(true);
        this.clientThread.start();
    }

    private void createSendThread() throws IOException {
        DataOutputStream outputStream = new DataOutputStream(new BufferedOutputStream(this.clientSocket.getOutputStream()));
        Thread outputThread = new Thread(() -> {
            try {
                while (!this.clientSocket.isClosed()) {
                    boolean skip;
                    Packet packet = (Packet)this.packetsToSend.peek();
                    boolean bl = skip = !(packet instanceof IdentificationPacket) && !this.ready;
                    if (packet == null || skip) {
                        Thread.sleep(1L);
                        continue;
                    }
                    this.packetsToSend.poll();
                    byte[] packetData = PacketSerializer.serialize(packet).array();
                    outputStream.writeInt(packetData.length);
                    outputStream.write(packetData);
                    outputStream.flush();
                    this.logger.trace("Sent a " + packet.getClass().getSimpleName() + " to the socket.");
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        });
        outputThread.setDaemon(true);
        outputThread.setName("TASmod Network Client Send");
        outputThread.start();
    }

    public void killClient() throws IOException {
        if (this.clientThread != null && this.clientSocket != null) {
            this.clientSocket.close();
        }
    }

    public boolean isClosed() {
        return this.clientSocket.isClosed();
    }

    public void setReady() {
        this.ready = true;
    }
}

