/*
 * Decompiled with CFR 0.152.
 */
package com.minecrafttas.tasmod.networking;

import com.minecrafttas.tasmod.TASmod;
import com.minecrafttas.tasmod.networking.IdentificationPacket;
import com.minecrafttas.tasmod.networking.Packet;
import com.minecrafttas.tasmod.networking.PacketSerializer;
import com.minecrafttas.tasmod.networking.PacketSide;
import io.netty.buffer.Unpooled;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.EOFException;
import java.io.IOException;
import java.io.InterruptedIOException;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.SocketException;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.LinkedBlockingQueue;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.network.PacketBuffer;
import org.apache.logging.log4j.Logger;

public class TASmodNetworkServer {
    private Logger logger;
    private Thread serverThread;
    private ServerSocket serverSocket;
    private Map<Socket, UUID> connectedPlayers = Collections.synchronizedMap(new HashMap());
    private Map<UUID, BlockingQueue<Packet>> queues = Collections.synchronizedMap(new HashMap());
    private int connections = 0;

    public TASmodNetworkServer(Logger logger) throws IOException {
        this(logger, 3111);
    }

    public TASmodNetworkServer(Logger logger, int port) throws IOException {
        this.logger = logger;
        this.createServer(port);
    }

    private void createServer(int port) throws IOException {
        this.serverThread = new Thread(() -> {
            try (ServerSocket serverS = new ServerSocket(port);){
                this.serverSocket = serverS;
                while (!this.serverSocket.isClosed()) {
                    Socket socket = null;
                    socket = this.serverSocket.accept();
                    socket.setTcpNoDelay(true);
                    LinkedBlockingQueue<Packet> queue = new LinkedBlockingQueue<Packet>();
                    ++this.connections;
                    this.createSendThread(socket, queue);
                    this.createAcceptThread(socket, queue);
                }
            }
            catch (EOFException | InterruptedIOException | SocketException exception) {
                this.logger.debug("Custom TASmod server was shutdown");
            }
            catch (Exception exception) {
                this.logger.error("Custom TASmod server was unexpectedly shutdown {}", (Throwable)exception);
                exception.printStackTrace();
            }
        });
        this.serverThread.setName("TASmod Network Server Main");
        this.serverThread.setDaemon(true);
        this.serverThread.start();
    }

    private void createSendThread(Socket socket, LinkedBlockingQueue<Packet> packetQueue) throws IOException, InterruptedException {
        Thread sendThread = new Thread(() -> {
            DataOutputStream outputStream;
            try {
                outputStream = new DataOutputStream(new BufferedOutputStream(socket.getOutputStream()));
            }
            catch (IOException e) {
                e.printStackTrace();
                return;
            }
            while (!socket.isClosed()) {
                try {
                    Packet packet = (Packet)packetQueue.poll();
                    if (packet == null) {
                        Thread.sleep(1L);
                        continue;
                    }
                    byte[] packetData = PacketSerializer.serialize(packet).array();
                    outputStream.writeInt(packetData.length);
                    outputStream.write(packetData);
                    outputStream.flush();
                    this.logger.trace("Sent a " + packet.getClass().getSimpleName() + " to the socket.");
                }
                catch (Exception e) {
                    this.logger.catching((Throwable)e);
                }
            }
        });
        sendThread.setDaemon(true);
        sendThread.setName("TASmod Network Server Send #" + this.connections);
        sendThread.start();
    }

    private void createAcceptThread(Socket socket, LinkedBlockingQueue<Packet> packetQueue) throws IOException {
        Thread acceptThread = new Thread(() -> {
            DataInputStream inputStream;
            try {
                inputStream = new DataInputStream(new BufferedInputStream(socket.getInputStream()));
            }
            catch (IOException e2) {
                e2.printStackTrace();
                return;
            }
            while (!socket.isClosed()) {
                try {
                    int packetSize = inputStream.readInt();
                    byte[] packetData = new byte[packetSize];
                    inputStream.read(packetData, 0, packetSize);
                    PacketBuffer packetBuf = new PacketBuffer(Unpooled.wrappedBuffer((byte[])packetData));
                    Packet packet = PacketSerializer.deserialize(packetBuf);
                    if (packet instanceof IdentificationPacket) {
                        this.handleIdentificationPacket(packet, socket, packetQueue);
                    }
                    if (!this.connectedPlayers.containsKey(socket)) continue;
                    UUID id = this.connectedPlayers.get(socket);
                    EntityPlayerMP player = TASmod.getServerInstance().func_184103_al().func_177451_a(id);
                    packet.handle(PacketSide.SERVER, (EntityPlayer)player);
                    this.logger.trace("Handled a " + packet.getClass().getSimpleName() + " from the socket.");
                }
                catch (EOFException e) {
                    this.logger.info("Client socket was shut down");
                    try {
                        socket.close();
                    }
                    catch (IOException e1) {
                        e1.printStackTrace();
                    }
                }
                catch (Exception e) {
                    this.logger.error(e.getMessage());
                    e.printStackTrace();
                    try {
                        socket.close();
                    }
                    catch (IOException e1) {
                        e1.printStackTrace();
                    }
                }
            }
            UUID id = this.connectedPlayers.get(socket);
            this.connectedPlayers.remove(socket);
            this.queues.remove(id);
            --this.connections;
        });
        acceptThread.setDaemon(true);
        acceptThread.setName("TASmod Network Server Accept #" + this.connections);
        acceptThread.start();
    }

    private void handleIdentificationPacket(Packet packet, Socket socket, LinkedBlockingQueue<Packet> packetQueue) {
        if (!this.connectedPlayers.containsKey(socket)) {
            IdentificationPacket idPacket = (IdentificationPacket)packet;
            this.logger.info("Identified player with uuid: {}", (Object)idPacket.getUuid());
            this.connectedPlayers.put(socket, idPacket.getUuid());
            this.queues.put(idPacket.getUuid(), packetQueue);
            this.sendTo((Packet)new IdentificationPacket(), idPacket.getUuid());
        }
    }

    public void sendToAll(Packet packet) {
        if (this.serverThread.isAlive()) {
            this.queues.forEach((id, queue) -> queue.add(packet));
        }
    }

    public void sendTo(Packet packet, EntityPlayerMP ... players) {
        if (this.serverThread.isAlive()) {
            this.queues.forEach((id, queue) -> {
                for (EntityPlayerMP player : players) {
                    if (!player.func_110124_au().equals(id)) continue;
                    queue.add(packet);
                }
            });
        }
    }

    public void sendTo(Packet packet, UUID ... uuids) {
        if (this.serverThread.isAlive()) {
            this.queues.forEach((id, queue) -> {
                for (UUID idToSend : uuids) {
                    if (!idToSend.equals(id)) continue;
                    queue.add(packet);
                }
            });
        }
    }

    public int getConnections() {
        return this.connections;
    }

    public void close() {
        if (this.serverSocket == null) {
            return;
        }
        try {
            this.serverSocket.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        this.connections = 0;
    }
}

