/*
 * Decompiled with CFR 0.152.
 */
package com.minecrafttas.tasmod.repack.com.fasterxml.jackson.databind.ser.std;

import com.minecrafttas.tasmod.repack.com.fasterxml.jackson.core.JsonGenerator;
import com.minecrafttas.tasmod.repack.com.fasterxml.jackson.databind.JavaType;
import com.minecrafttas.tasmod.repack.com.fasterxml.jackson.databind.JsonMappingException;
import com.minecrafttas.tasmod.repack.com.fasterxml.jackson.databind.JsonNode;
import com.minecrafttas.tasmod.repack.com.fasterxml.jackson.databind.SerializerProvider;
import com.minecrafttas.tasmod.repack.com.fasterxml.jackson.databind.annotation.JacksonStdImpl;
import com.minecrafttas.tasmod.repack.com.fasterxml.jackson.databind.jsonFormatVisitors.JsonArrayFormatVisitor;
import com.minecrafttas.tasmod.repack.com.fasterxml.jackson.databind.jsonFormatVisitors.JsonFormatTypes;
import com.minecrafttas.tasmod.repack.com.fasterxml.jackson.databind.jsonFormatVisitors.JsonFormatVisitorWrapper;
import com.minecrafttas.tasmod.repack.com.fasterxml.jackson.databind.jsontype.TypeSerializer;
import com.minecrafttas.tasmod.repack.com.fasterxml.jackson.databind.node.ObjectNode;
import com.minecrafttas.tasmod.repack.com.fasterxml.jackson.databind.ser.std.StdSerializer;
import java.io.IOException;
import java.lang.reflect.Type;

@JacksonStdImpl
public class ByteArraySerializer
extends StdSerializer<byte[]> {
    private static final long serialVersionUID = 1L;

    public ByteArraySerializer() {
        super(byte[].class);
    }

    @Override
    public boolean isEmpty(SerializerProvider prov, byte[] value) {
        return value == null || value.length == 0;
    }

    @Override
    public void serialize(byte[] value, JsonGenerator g, SerializerProvider provider) throws IOException {
        g.writeBinary(provider.getConfig().getBase64Variant(), value, 0, value.length);
    }

    @Override
    public void serializeWithType(byte[] value, JsonGenerator g, SerializerProvider provider, TypeSerializer typeSer) throws IOException {
        typeSer.writeTypePrefixForScalar(value, g);
        g.writeBinary(provider.getConfig().getBase64Variant(), value, 0, value.length);
        typeSer.writeTypeSuffixForScalar(value, g);
    }

    @Override
    public JsonNode getSchema(SerializerProvider provider, Type typeHint) {
        ObjectNode o = this.createSchemaNode("array", true);
        ObjectNode itemSchema = this.createSchemaNode("byte");
        return o.set("items", itemSchema);
    }

    @Override
    public void acceptJsonFormatVisitor(JsonFormatVisitorWrapper visitor, JavaType typeHint) throws JsonMappingException {
        JsonArrayFormatVisitor v2;
        if (visitor != null && (v2 = visitor.expectArrayFormat(typeHint)) != null) {
            v2.itemsFormat(JsonFormatTypes.INTEGER);
        }
    }
}

