/*
 * Decompiled with CFR 0.152.
 */
package com.minecrafttas.tasmod.repack.com.fasterxml.jackson.databind.ser.std;

import com.minecrafttas.tasmod.repack.com.fasterxml.jackson.annotation.JsonInclude;
import com.minecrafttas.tasmod.repack.com.fasterxml.jackson.core.JsonGenerator;
import com.minecrafttas.tasmod.repack.com.fasterxml.jackson.databind.AnnotationIntrospector;
import com.minecrafttas.tasmod.repack.com.fasterxml.jackson.databind.BeanProperty;
import com.minecrafttas.tasmod.repack.com.fasterxml.jackson.databind.JavaType;
import com.minecrafttas.tasmod.repack.com.fasterxml.jackson.databind.JsonMappingException;
import com.minecrafttas.tasmod.repack.com.fasterxml.jackson.databind.JsonSerializer;
import com.minecrafttas.tasmod.repack.com.fasterxml.jackson.databind.MapperFeature;
import com.minecrafttas.tasmod.repack.com.fasterxml.jackson.databind.RuntimeJsonMappingException;
import com.minecrafttas.tasmod.repack.com.fasterxml.jackson.databind.SerializerProvider;
import com.minecrafttas.tasmod.repack.com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.minecrafttas.tasmod.repack.com.fasterxml.jackson.databind.introspect.AnnotatedMember;
import com.minecrafttas.tasmod.repack.com.fasterxml.jackson.databind.jsonFormatVisitors.JsonFormatVisitorWrapper;
import com.minecrafttas.tasmod.repack.com.fasterxml.jackson.databind.jsontype.TypeSerializer;
import com.minecrafttas.tasmod.repack.com.fasterxml.jackson.databind.ser.ContextualSerializer;
import com.minecrafttas.tasmod.repack.com.fasterxml.jackson.databind.ser.impl.PropertySerializerMap;
import com.minecrafttas.tasmod.repack.com.fasterxml.jackson.databind.ser.std.StdSerializer;
import com.minecrafttas.tasmod.repack.com.fasterxml.jackson.databind.type.ReferenceType;
import com.minecrafttas.tasmod.repack.com.fasterxml.jackson.databind.util.NameTransformer;
import java.io.IOException;

public abstract class ReferenceTypeSerializer<T>
extends StdSerializer<T>
implements ContextualSerializer {
    private static final long serialVersionUID = 1L;
    protected final JavaType _referredType;
    protected final BeanProperty _property;
    protected final TypeSerializer _valueTypeSerializer;
    protected final JsonSerializer<Object> _valueSerializer;
    protected final NameTransformer _unwrapper;
    protected final JsonInclude.Include _contentInclusion;
    protected transient PropertySerializerMap _dynamicSerializers;

    public ReferenceTypeSerializer(ReferenceType fullType, boolean staticTyping, TypeSerializer vts, JsonSerializer<Object> ser) {
        super(fullType);
        this._referredType = fullType.getReferencedType();
        this._property = null;
        this._valueTypeSerializer = vts;
        this._valueSerializer = ser;
        this._unwrapper = null;
        this._contentInclusion = null;
        this._dynamicSerializers = PropertySerializerMap.emptyForProperties();
    }

    protected ReferenceTypeSerializer(ReferenceTypeSerializer<?> base, BeanProperty property, TypeSerializer vts, JsonSerializer<?> valueSer, NameTransformer unwrapper, JsonInclude.Include contentIncl) {
        super(base);
        this._referredType = base._referredType;
        this._dynamicSerializers = base._dynamicSerializers;
        this._property = property;
        this._valueTypeSerializer = vts;
        this._valueSerializer = valueSer;
        this._unwrapper = unwrapper;
        this._contentInclusion = contentIncl == JsonInclude.Include.USE_DEFAULTS || contentIncl == JsonInclude.Include.ALWAYS ? null : contentIncl;
    }

    @Override
    public JsonSerializer<T> unwrappingSerializer(NameTransformer transformer) {
        JsonSerializer<Object> ser = this._valueSerializer;
        if (ser != null) {
            ser = ser.unwrappingSerializer(transformer);
        }
        NameTransformer unwrapper = this._unwrapper == null ? transformer : NameTransformer.chainedTransformer(transformer, this._unwrapper);
        return this.withResolved(this._property, this._valueTypeSerializer, ser, unwrapper, this._contentInclusion);
    }

    protected abstract ReferenceTypeSerializer<T> withResolved(BeanProperty var1, TypeSerializer var2, JsonSerializer<?> var3, NameTransformer var4, JsonInclude.Include var5);

    protected abstract boolean _isValueEmpty(T var1);

    protected abstract Object _getReferenced(T var1);

    protected abstract Object _getReferencedIfPresent(T var1);

    @Override
    public JsonSerializer<?> createContextual(SerializerProvider provider, BeanProperty property) throws JsonMappingException {
        JsonSerializer<Object> ser;
        TypeSerializer typeSer = this._valueTypeSerializer;
        if (typeSer != null) {
            typeSer = typeSer.forProperty(property);
        }
        if ((ser = this.findAnnotatedContentSerializer(provider, property)) == null) {
            ser = this._valueSerializer;
            if (ser == null) {
                if (this._useStatic(provider, property, this._referredType)) {
                    ser = this._findSerializer(provider, this._referredType, property);
                }
            } else {
                ser = provider.handlePrimaryContextualization(ser, property);
            }
        }
        JsonInclude.Include contentIncl = this._contentInclusion;
        JsonInclude.Value incl = this.findIncludeOverrides(provider, property, this.handledType());
        JsonInclude.Include newIncl = incl.getContentInclusion();
        if (newIncl != contentIncl && newIncl != JsonInclude.Include.USE_DEFAULTS) {
            contentIncl = newIncl;
        }
        return this.withResolved(property, typeSer, ser, this._unwrapper, contentIncl);
    }

    protected boolean _useStatic(SerializerProvider provider, BeanProperty property, JavaType referredType) {
        AnnotatedMember ann;
        if (referredType.isJavaLangObject()) {
            return false;
        }
        if (referredType.isFinal()) {
            return true;
        }
        if (referredType.useStaticType()) {
            return true;
        }
        AnnotationIntrospector intr = provider.getAnnotationIntrospector();
        if (intr != null && property != null && (ann = property.getMember()) != null) {
            JsonSerialize.Typing t = intr.findSerializationTyping(property.getMember());
            if (t == JsonSerialize.Typing.STATIC) {
                return true;
            }
            if (t == JsonSerialize.Typing.DYNAMIC) {
                return false;
            }
        }
        return provider.isEnabled(MapperFeature.USE_STATIC_TYPING);
    }

    @Override
    public boolean isEmpty(SerializerProvider provider, T value) {
        if (value == null || this._isValueEmpty(value)) {
            return true;
        }
        if (this._contentInclusion == null) {
            return false;
        }
        Object contents = this._getReferenced(value);
        JsonSerializer<Object> ser = this._valueSerializer;
        if (ser == null) {
            try {
                ser = this._findCachedSerializer(provider, contents.getClass());
            }
            catch (JsonMappingException e) {
                throw new RuntimeJsonMappingException(e);
            }
        }
        return ser.isEmpty(provider, contents);
    }

    @Override
    public boolean isUnwrappingSerializer() {
        return this._unwrapper != null;
    }

    @Override
    public void serialize(T ref, JsonGenerator g, SerializerProvider provider) throws IOException {
        Object value = this._getReferencedIfPresent(ref);
        if (value == null) {
            if (this._unwrapper == null) {
                provider.defaultSerializeNull(g);
            }
            return;
        }
        JsonSerializer<Object> ser = this._valueSerializer;
        if (ser == null) {
            ser = this._findCachedSerializer(provider, value.getClass());
        }
        if (this._valueTypeSerializer != null) {
            ser.serializeWithType(value, g, provider, this._valueTypeSerializer);
        } else {
            ser.serialize(value, g, provider);
        }
    }

    @Override
    public void serializeWithType(T ref, JsonGenerator g, SerializerProvider provider, TypeSerializer typeSer) throws IOException {
        Object value = this._getReferencedIfPresent(ref);
        if (value == null) {
            if (this._unwrapper == null) {
                provider.defaultSerializeNull(g);
            }
            return;
        }
        JsonSerializer<Object> ser = this._valueSerializer;
        if (ser == null) {
            ser = this._findCachedSerializer(provider, value.getClass());
        }
        ser.serializeWithType(value, g, provider, typeSer);
    }

    @Override
    public void acceptJsonFormatVisitor(JsonFormatVisitorWrapper visitor, JavaType typeHint) throws JsonMappingException {
        JsonSerializer<Object> ser = this._valueSerializer;
        if (ser == null) {
            ser = this._findSerializer(visitor.getProvider(), this._referredType, this._property);
            if (this._unwrapper != null) {
                ser = ser.unwrappingSerializer(this._unwrapper);
            }
        }
        ser.acceptJsonFormatVisitor(visitor, this._referredType);
    }

    private final JsonSerializer<Object> _findCachedSerializer(SerializerProvider provider, Class<?> type) throws JsonMappingException {
        JsonSerializer<Object> ser = this._dynamicSerializers.serializerFor(type);
        if (ser == null) {
            ser = this._findSerializer(provider, type, this._property);
            if (this._unwrapper != null) {
                ser = ser.unwrappingSerializer(this._unwrapper);
            }
            this._dynamicSerializers = this._dynamicSerializers.newWith(type, ser);
        }
        return ser;
    }

    private final JsonSerializer<Object> _findSerializer(SerializerProvider provider, Class<?> type, BeanProperty prop) throws JsonMappingException {
        return provider.findValueSerializer(type, prop);
    }

    private final JsonSerializer<Object> _findSerializer(SerializerProvider provider, JavaType type, BeanProperty prop) throws JsonMappingException {
        return provider.findValueSerializer(type, prop);
    }
}

