/*
 * Decompiled with CFR 0.152.
 */
package com.minecrafttas.tasmod.repack.org.msgpack.jackson.dataformat;

import com.minecrafttas.tasmod.repack.com.fasterxml.jackson.core.JsonGenerator;
import com.minecrafttas.tasmod.repack.com.fasterxml.jackson.core.JsonProcessingException;
import com.minecrafttas.tasmod.repack.com.fasterxml.jackson.databind.JsonSerializer;
import com.minecrafttas.tasmod.repack.com.fasterxml.jackson.databind.SerializerProvider;
import com.minecrafttas.tasmod.repack.com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.minecrafttas.tasmod.repack.org.msgpack.jackson.dataformat.MessagePackGenerator;
import java.io.IOException;
import java.util.Arrays;

@JsonSerialize(using=Serializer.class)
public class MessagePackExtensionType {
    private final byte type;
    private final byte[] data;

    public MessagePackExtensionType(byte by, byte[] byArray) {
        this.type = by;
        this.data = byArray;
    }

    public byte getType() {
        return this.type;
    }

    public byte[] getData() {
        return this.data;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof MessagePackExtensionType)) {
            return false;
        }
        MessagePackExtensionType messagePackExtensionType = (MessagePackExtensionType)object;
        if (this.type != messagePackExtensionType.type) {
            return false;
        }
        return Arrays.equals(this.data, messagePackExtensionType.data);
    }

    public int hashCode() {
        int n = this.type;
        n = 31 * n + Arrays.hashCode(this.data);
        return n;
    }

    public static class Serializer
    extends JsonSerializer<MessagePackExtensionType> {
        @Override
        public void serialize(MessagePackExtensionType messagePackExtensionType, JsonGenerator jsonGenerator, SerializerProvider serializerProvider) throws IOException, JsonProcessingException {
            if (!(jsonGenerator instanceof MessagePackGenerator)) {
                throw new IllegalStateException("'gen' is expected to be MessagePackGenerator but it's " + jsonGenerator.getClass());
            }
            MessagePackGenerator messagePackGenerator = (MessagePackGenerator)jsonGenerator;
            messagePackGenerator.writeExtensionType(messagePackExtensionType);
        }
    }
}

