/*
 * Decompiled with CFR 0.152.
 */
package com.minecrafttas.tasmod.repack.org.msgpack.value.impl;

import com.minecrafttas.tasmod.repack.org.msgpack.core.MessagePacker;
import com.minecrafttas.tasmod.repack.org.msgpack.value.ImmutableBooleanValue;
import com.minecrafttas.tasmod.repack.org.msgpack.value.Value;
import com.minecrafttas.tasmod.repack.org.msgpack.value.ValueType;
import com.minecrafttas.tasmod.repack.org.msgpack.value.impl.AbstractImmutableValue;
import java.io.IOException;

public class ImmutableBooleanValueImpl
extends AbstractImmutableValue
implements ImmutableBooleanValue {
    public static final ImmutableBooleanValue TRUE = new ImmutableBooleanValueImpl(true);
    public static final ImmutableBooleanValue FALSE = new ImmutableBooleanValueImpl(false);
    private final boolean value;

    private ImmutableBooleanValueImpl(boolean bl) {
        this.value = bl;
    }

    @Override
    public ValueType getValueType() {
        return ValueType.BOOLEAN;
    }

    @Override
    public ImmutableBooleanValue asBooleanValue() {
        return this;
    }

    @Override
    public ImmutableBooleanValue immutableValue() {
        return this;
    }

    @Override
    public boolean getBoolean() {
        return this.value;
    }

    @Override
    public void writeTo(MessagePacker messagePacker) throws IOException {
        messagePacker.packBoolean(this.value);
    }

    @Override
    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!(object instanceof Value)) {
            return false;
        }
        Value value = (Value)object;
        if (!value.isBooleanValue()) {
            return false;
        }
        return this.value == value.asBooleanValue().getBoolean();
    }

    public int hashCode() {
        if (this.value) {
            return 1231;
        }
        return 1237;
    }

    @Override
    public String toJson() {
        return Boolean.toString(this.value);
    }

    public String toString() {
        return this.toJson();
    }
}

