/*
 * Decompiled with CFR 0.152.
 */
package com.minecrafttas.tasmod.repack.org.msgpack.value.impl;

import com.minecrafttas.tasmod.repack.org.msgpack.core.MessagePacker;
import com.minecrafttas.tasmod.repack.org.msgpack.value.ImmutableFloatValue;
import com.minecrafttas.tasmod.repack.org.msgpack.value.ImmutableNumberValue;
import com.minecrafttas.tasmod.repack.org.msgpack.value.Value;
import com.minecrafttas.tasmod.repack.org.msgpack.value.ValueType;
import com.minecrafttas.tasmod.repack.org.msgpack.value.impl.AbstractImmutableValue;
import java.io.IOException;
import java.math.BigDecimal;
import java.math.BigInteger;

public class ImmutableDoubleValueImpl
extends AbstractImmutableValue
implements ImmutableFloatValue {
    private final double value;

    public ImmutableDoubleValueImpl(double d) {
        this.value = d;
    }

    @Override
    public ValueType getValueType() {
        return ValueType.FLOAT;
    }

    @Override
    public ImmutableDoubleValueImpl immutableValue() {
        return this;
    }

    @Override
    public ImmutableNumberValue asNumberValue() {
        return this;
    }

    @Override
    public ImmutableFloatValue asFloatValue() {
        return this;
    }

    @Override
    public byte toByte() {
        return (byte)this.value;
    }

    @Override
    public short toShort() {
        return (short)this.value;
    }

    @Override
    public int toInt() {
        return (int)this.value;
    }

    @Override
    public long toLong() {
        return (long)this.value;
    }

    @Override
    public BigInteger toBigInteger() {
        return new BigDecimal(this.value).toBigInteger();
    }

    @Override
    public float toFloat() {
        return (float)this.value;
    }

    @Override
    public double toDouble() {
        return this.value;
    }

    @Override
    public void writeTo(MessagePacker messagePacker) throws IOException {
        messagePacker.packDouble(this.value);
    }

    @Override
    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!(object instanceof Value)) {
            return false;
        }
        Value value = (Value)object;
        if (!value.isFloatValue()) {
            return false;
        }
        return this.value == value.asFloatValue().toDouble();
    }

    public int hashCode() {
        long l = Double.doubleToLongBits(this.value);
        return (int)(l ^ l >>> 32);
    }

    @Override
    public String toJson() {
        if (Double.isNaN(this.value) || Double.isInfinite(this.value)) {
            return "null";
        }
        return Double.toString(this.value);
    }

    public String toString() {
        return Double.toString(this.value);
    }
}

