/*
 * Decompiled with CFR 0.152.
 */
package com.minecrafttas.tasmod.savestates.client;

import com.minecrafttas.tasmod.ClientProxy;
import com.minecrafttas.tasmod.CommonProxy;
import com.minecrafttas.tasmod.TASmod;
import com.minecrafttas.tasmod.inputcontainer.InputContainer;
import com.minecrafttas.tasmod.inputcontainer.TASstate;
import com.minecrafttas.tasmod.savestates.server.exceptions.SavestateException;
import com.mojang.realmsclient.gui.ChatFormatting;
import java.io.File;
import java.io.IOException;
import net.minecraft.client.Minecraft;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

@SideOnly(value=Side.CLIENT)
public class InputSavestatesHandler {
    private static final File savestateDirectory = new File(ClientProxy.tasdirectory + File.separator + "savestates");

    public static void savestate(String nameOfSavestate) throws SavestateException, IOException {
        if (nameOfSavestate.isEmpty()) {
            CommonProxy.logger.error("No recording savestate loaded since the name of savestate is empty");
            return;
        }
        savestateDirectory.mkdir();
        File targetfile = new File(savestateDirectory, nameOfSavestate + ".tas");
        InputContainer container = ClientProxy.virtual.getContainer();
        if (container.isRecording()) {
            ClientProxy.serialiser.saveToFileV1(targetfile, container);
        } else if (container.isPlayingback()) {
            ClientProxy.serialiser.saveToFileV1Until(targetfile, container, container.index());
        }
    }

    public static void loadstate(String nameOfSavestate) throws IOException {
        if (nameOfSavestate.isEmpty()) {
            CommonProxy.logger.error("No recording savestate loaded since the name of savestate is empty");
            return;
        }
        savestateDirectory.mkdir();
        File targetfile = new File(savestateDirectory, nameOfSavestate + ".tas");
        InputContainer container = ClientProxy.virtual.getContainer();
        if (!container.isNothingPlaying()) {
            if (targetfile.exists()) {
                ClientProxy.virtual.loadClientSavestate(ClientProxy.serialiser.fromEntireFileV1(targetfile));
            } else {
                ClientProxy.virtual.getContainer().setTASState(TASstate.NONE, false);
                Minecraft.func_71410_x().field_71439_g.func_145747_a((ITextComponent)new TextComponentString(ChatFormatting.YELLOW + "Inputs could not be loaded for this savestate, since the file doesn't exist. Stopping!"));
                TASmod.logger.warn("Inputs could not be loaded for this savestate, since the file doesn't exist.");
            }
        }
    }
}

