/*
 * Decompiled with CFR 0.152.
 */
package com.minecrafttas.tasmod.savestates.client;

import com.minecrafttas.tasmod.CommonProxy;
import com.minecrafttas.tasmod.networking.Packet;
import com.minecrafttas.tasmod.networking.PacketSide;
import com.minecrafttas.tasmod.savestates.client.InputSavestatesHandler;
import com.minecrafttas.tasmod.savestates.server.exceptions.SavestateException;
import java.io.IOException;
import java.nio.charset.Charset;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.network.PacketBuffer;

public class InputSavestatesPacket
implements Packet {
    private boolean mode;
    private String name;

    public InputSavestatesPacket() {
    }

    public InputSavestatesPacket(boolean mode, String name) {
        this.mode = mode;
        this.name = name;
    }

    @Override
    public void handle(PacketSide side, EntityPlayer player) {
        if (side.isClient()) {
            if (this.mode) {
                try {
                    InputSavestatesHandler.savestate(this.name);
                }
                catch (SavestateException e) {
                    CommonProxy.logger.error(e.getMessage());
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            } else {
                try {
                    InputSavestatesHandler.loadstate(this.name);
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
    }

    @Override
    public void serialize(PacketBuffer buf) {
        buf.writeInt(this.name.length());
        buf.writeCharSequence((CharSequence)this.name, Charset.defaultCharset());
        buf.writeBoolean(this.mode);
    }

    @Override
    public void deserialize(PacketBuffer buf) {
        int length = buf.readInt();
        this.name = (String)buf.readCharSequence(length, Charset.defaultCharset());
        this.mode = buf.readBoolean();
    }
}

