/*
 * Decompiled with CFR 0.152.
 */
package com.minecrafttas.tasmod.savestates.server;

import com.minecrafttas.tasmod.TASmod;
import com.minecrafttas.tasmod.networking.Packet;
import com.minecrafttas.tasmod.networking.PacketSide;
import com.minecrafttas.tasmod.savestates.server.SavestateState;
import com.minecrafttas.tasmod.savestates.server.chunkloading.SavestatesChunkControl;
import com.minecrafttas.tasmod.savestates.server.exceptions.LoadstateException;
import net.minecraft.client.Minecraft;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import net.minecraft.util.text.TextFormatting;

public class LoadstatePacket
implements Packet {
    public int index;

    public LoadstatePacket() {
        this.index = -1;
    }

    public LoadstatePacket(int index) {
        this.index = index;
    }

    @Override
    public void handle(PacketSide side, EntityPlayer playerz) {
        if (side.isServer()) {
            EntityPlayerMP player = (EntityPlayerMP)playerz;
            player.func_71121_q().func_152344_a(() -> {
                if (!player.func_70003_b(2, "tickrate")) {
                    player.func_145747_a((ITextComponent)new TextComponentString(TextFormatting.RED + "You don't have permission to do that"));
                    return;
                }
                try {
                    TASmod.savestateHandler.loadState(this.index, true);
                }
                catch (LoadstateException e) {
                    player.func_145747_a((ITextComponent)new TextComponentString(TextFormatting.RED + "Failed to load a savestate: " + e.getMessage()));
                }
                catch (Exception e) {
                    player.func_145747_a((ITextComponent)new TextComponentString(TextFormatting.RED + "Failed to load a savestate: " + e.getCause().toString()));
                    e.printStackTrace();
                }
                finally {
                    TASmod.savestateHandler.state = SavestateState.NONE;
                }
            });
        } else {
            Minecraft.func_71410_x().func_152344_a(() -> SavestatesChunkControl.unloadAllClientChunks());
        }
    }

    @Override
    public void serialize(PacketBuffer buf) {
        buf.writeInt(this.index);
    }

    @Override
    public void deserialize(PacketBuffer buf) {
        this.index = buf.readInt();
    }
}

