/*
 * Decompiled with CFR 0.152.
 */
package com.minecrafttas.tasmod.savestates.server;

import com.minecrafttas.tasmod.TASmod;
import com.minecrafttas.tasmod.savestates.server.SavestateState;
import com.minecrafttas.tasmod.savestates.server.exceptions.LoadstateException;
import com.minecrafttas.tasmod.savestates.server.exceptions.SavestateDeleteException;
import com.minecrafttas.tasmod.savestates.server.exceptions.SavestateException;
import java.io.IOException;
import java.util.List;
import net.minecraft.command.CommandBase;
import net.minecraft.command.CommandException;
import net.minecraft.command.ICommandSender;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.event.ClickEvent;

public class SavestateCommand
extends CommandBase {
    public String func_71517_b() {
        return "savestate";
    }

    public String func_71518_a(ICommandSender sender) {
        return "/savestate <save|load|delete|list> [index]";
    }

    public int func_82362_a() {
        return 2;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void func_184881_a(MinecraftServer server, ICommandSender sender, String[] args) throws CommandException {
        if (args.length == 0) {
            this.sendHelp(sender);
            return;
        }
        if (args.length < 1) return;
        if ("save".equals(args[0])) {
            if (args.length == 1) {
                this.saveLatest();
                return;
            } else {
                if (args.length != 2) throw new CommandException("Too many arguments!", new Object[0]);
                this.saveWithIndex(args);
            }
            return;
        }
        if ("load".equals(args[0])) {
            if (args.length == 1) {
                this.loadLatest();
                return;
            } else {
                if (args.length != 2) throw new CommandException("Too many arguments!", new Object[0]);
                this.loadLatest(args);
            }
            return;
        }
        if ("delete".equals(args[0])) {
            if (args.length == 2) {
                this.delete(args);
                return;
            } else {
                if (args.length != 3) throw new CommandException("Too many arguments!", new Object[0]);
                int args1 = this.processIndex(args[1]);
                int args2 = this.processIndex(args[2]);
                int count = args2 + 1 - args1;
                TextComponentString confirm = new TextComponentString(TextFormatting.YELLOW + "Are you sure you want to delete " + count + (count == 1 ? " savestate? " : " savestates? ") + TextFormatting.GREEN + "[YES]");
                confirm.func_150256_b().func_150241_a(new ClickEvent(ClickEvent.Action.RUN_COMMAND, String.format("/savestate deletDis %s %s", args[1], args[2])));
                sender.func_145747_a((ITextComponent)confirm);
            }
            return;
        }
        if ("deletDis".equals(args[0])) {
            if (args.length != 3) return;
            this.deleteMultiple(args);
            return;
        }
        if ("list".equals(args[0])) {
            sender.func_145747_a((ITextComponent)new TextComponentString(String.format("The current savestate index is %s%s", TextFormatting.AQUA, TASmod.savestateHandler.getCurrentIndex())));
            sender.func_145747_a((ITextComponent)new TextComponentString(String.format("Available indexes are %s%s", TextFormatting.AQUA, TASmod.savestateHandler.getIndexesAsString().isEmpty() ? "None" : TASmod.savestateHandler.getIndexesAsString())));
            return;
        }
        if (!"help".equals(args[0])) return;
        if (args.length == 1) {
            this.sendHelp(sender);
            return;
        }
        if (args.length != 2) throw new CommandException("Too many arguments", new Object[0]);
        int i = 1;
        try {
            i = Integer.parseInt(args[1]);
        }
        catch (NumberFormatException e) {
            throw new CommandException("Page number was not a number %s", new Object[]{args[1]});
        }
        this.sendHelp(sender, i);
    }

    private void sendHelp(ICommandSender sender) throws CommandException {
        this.sendHelp(sender, 1);
    }

    private void sendHelp(ICommandSender sender, int i) throws CommandException {
        int currentIndex = TASmod.savestateHandler.getCurrentIndex();
        if (i > 3) {
            throw new CommandException("This help page doesn't exist (yet?)", new Object[0]);
        }
        if (i == 1) {
            sender.func_145747_a((ITextComponent)new TextComponentString(TextFormatting.GOLD + "-------------------Savestate Help 1--------------------\n" + TextFormatting.RESET + "Makes a backup of the minecraft world you are currently playing.\n\nThe mod will keep track of the number of savestates you made in the 'current index' number which is currently " + TextFormatting.AQUA + currentIndex + TextFormatting.RESET + String.format(". If you make a new savestate via %s/savestate save%s or by pressing %sJ%s by default, ", TextFormatting.AQUA, TextFormatting.RESET, TextFormatting.AQUA, TextFormatting.RESET) + "the current index will increase by one. " + String.format("If you load a savestate with %s/savestate load%s or %sK%s by default, it will load the savestate at the current index.\n", TextFormatting.AQUA, TextFormatting.RESET, TextFormatting.AQUA, TextFormatting.RESET)));
        } else if (i == 2) {
            sender.func_145747_a((ITextComponent)new TextComponentString(String.format("%1$s-------------------Savestate Help 2--------------------\nYou can load or save savestates in different indexes by specifying the index: %3$s/savestate %4$s<save|load> %5$s<index>%2$s\nThis will change the %5$scurrent index%2$s to the index you specified.\n\nSo, if you have the savestates %3$s1, 2, 3%2$s and your %5$scurrent index%2$s is %3$s3%2$s, %3$s/savestate %4$sload %5$s2%2$s will load the second savestate and will set the %5$scurrent index%2$s to %3$s2%2$s.\nBut if you savestate again you will OVERWRITE the third savestate, so keep that in mind!!\n\nThe savestate at index 0 will be the savestate when you started the TAS recording and can't be deleted or overwritten with this command", TextFormatting.GOLD, TextFormatting.RESET, TextFormatting.AQUA, TextFormatting.GREEN, TextFormatting.YELLOW)));
        } else if (i == 3) {
            sender.func_145747_a((ITextComponent)new TextComponentString(String.format("%1$s-------------------Savestate Help 3--------------------\n%2$s%3$s/savestate %4$ssave%2$s - Make a savestate at the next index\n%3$s/savestate %4$ssave%5$s <index>%2$s - Make a savestate at the specified index\n%3$s/savestate %4$sload%2$s - Load the savestate at the current index\n%3$s/savestate %4$sload%5$s <index>%2$s - Load the savestate at the specified index\n%3$s/savestate %4$sdelete%5$s <index>%2$s - Delete the savestate at the specified index\n%3$s/savestate %4$sdelete%5$s <fromIndex> <toIndex>%2$s - Delete the savestates from the fromIndex to the toIndex\n%3$s/savestate %4$slist%2$s - Shows the current index as well as the available indexes\n\nInstead of %4$s<index> %2$syou can use ~ to specify an index relative to the current index e.g. %3$s~-1%2$s will currently load %6$s\n", TextFormatting.GOLD, TextFormatting.RESET, TextFormatting.AQUA, TextFormatting.GREEN, TextFormatting.YELLOW, currentIndex - 1)));
            return;
        }
        TextComponentString nextPage = new TextComponentString(TextFormatting.GOLD + "Click here to go to the next help page (" + (i + 1) + ")\n");
        nextPage.func_150256_b().func_150241_a(new ClickEvent(ClickEvent.Action.RUN_COMMAND, "/savestate help " + (i + 1) + ""));
        sender.func_145747_a((ITextComponent)nextPage);
    }

    public List<String> func_184883_a(MinecraftServer server, ICommandSender sender, String[] args, BlockPos targetPos) {
        if (args.length == 1) {
            return SavestateCommand.func_71530_a((String[])args, (String[])new String[]{"save", "load", "delete", "list", "help"});
        }
        if (args.length == 2 && !"list".equals(args[0])) {
            sender.func_145747_a((ITextComponent)new TextComponentString("Available indexes: " + TextFormatting.AQUA + TASmod.savestateHandler.getIndexesAsString()));
        }
        return super.func_184883_a(server, sender, args, targetPos);
    }

    private void saveLatest() throws CommandException {
        try {
            TASmod.savestateHandler.saveState();
        }
        catch (SavestateException e) {
            throw new CommandException(e.getMessage(), new Object[0]);
        }
        catch (IOException e) {
            e.printStackTrace();
            throw new CommandException(e.getMessage(), new Object[0]);
        }
        finally {
            TASmod.savestateHandler.state = SavestateState.NONE;
        }
    }

    private void saveWithIndex(String[] args) throws CommandException {
        try {
            int indexToSave = this.processIndex(args[1]);
            if (indexToSave <= 0) {
                indexToSave = -1;
            }
            TASmod.savestateHandler.saveState(indexToSave, true);
        }
        catch (SavestateException e) {
            throw new CommandException(e.getMessage(), new Object[0]);
        }
        catch (IOException e) {
            e.printStackTrace();
            throw new CommandException(e.getMessage(), new Object[0]);
        }
        finally {
            TASmod.savestateHandler.state = SavestateState.NONE;
        }
    }

    private void loadLatest() throws CommandException {
        try {
            TASmod.savestateHandler.loadState();
        }
        catch (LoadstateException e) {
            throw new CommandException(e.getMessage(), new Object[0]);
        }
        catch (IOException e) {
            e.printStackTrace();
            throw new CommandException(e.getMessage(), new Object[0]);
        }
        finally {
            TASmod.savestateHandler.state = SavestateState.NONE;
        }
    }

    private void loadLatest(String[] args) throws CommandException {
        try {
            TASmod.savestateHandler.loadState(this.processIndex(args[1]), true);
        }
        catch (LoadstateException e) {
            throw new CommandException(e.getMessage(), new Object[0]);
        }
        catch (IOException e) {
            e.printStackTrace();
            throw new CommandException(e.getMessage(), new Object[0]);
        }
        finally {
            TASmod.savestateHandler.state = SavestateState.NONE;
        }
    }

    private void delete(String[] args) throws CommandException {
        int arg1 = this.processIndex(args[1]);
        try {
            TASmod.savestateHandler.deleteSavestate(arg1);
        }
        catch (SavestateDeleteException e) {
            throw new CommandException(e.getMessage(), new Object[0]);
        }
    }

    private void deleteMultiple(String[] args) throws CommandException {
        try {
            TASmod.savestateHandler.deleteSavestate(this.processIndex(args[1]), this.processIndex(args[2]));
        }
        catch (SavestateDeleteException e) {
            throw new CommandException(e.getMessage(), new Object[0]);
        }
    }

    private int processIndex(String arg) throws CommandException {
        if ("~".equals(arg)) {
            return TASmod.savestateHandler.getCurrentIndex();
        }
        if (arg.matches("~-?\\d")) {
            arg = arg.replace("~", "");
            int i = Integer.parseInt(arg);
            return TASmod.savestateHandler.getCurrentIndex() + i;
        }
        int i = 0;
        try {
            i = Integer.parseInt(arg);
        }
        catch (NumberFormatException e) {
            throw new CommandException("The specified index is not a number: %s", new Object[]{arg});
        }
        return i;
    }
}

