/*
 * Decompiled with CFR 0.152.
 */
package com.minecrafttas.tasmod.savestates.server;

import com.minecrafttas.tasmod.TASmod;
import com.minecrafttas.tasmod.events.SavestateEvents;
import com.minecrafttas.tasmod.savestates.client.InputSavestatesPacket;
import com.minecrafttas.tasmod.savestates.server.LoadstatePacket;
import com.minecrafttas.tasmod.savestates.server.SavestatePacket;
import com.minecrafttas.tasmod.savestates.server.SavestateState;
import com.minecrafttas.tasmod.savestates.server.chunkloading.SavestatesChunkControl;
import com.minecrafttas.tasmod.savestates.server.exceptions.LoadstateException;
import com.minecrafttas.tasmod.savestates.server.exceptions.SavestateDeleteException;
import com.minecrafttas.tasmod.savestates.server.exceptions.SavestateException;
import com.minecrafttas.tasmod.savestates.server.files.SavestateDataFile;
import com.minecrafttas.tasmod.savestates.server.files.SavestateTrackerFile;
import com.minecrafttas.tasmod.savestates.server.motion.ClientMotionServer;
import com.minecrafttas.tasmod.savestates.server.playerloading.SavestatePlayerLoading;
import com.minecrafttas.tasmod.tickratechanger.TickrateChangerServer;
import java.io.File;
import java.io.FileFilter;
import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.minecraft.client.Minecraft;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.management.PlayerList;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraft.world.chunk.storage.AnvilChunkLoader;
import net.minecraftforge.common.DimensionManager;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.apache.commons.io.FileUtils;
import org.apache.logging.log4j.Logger;

public class SavestateHandler {
    private MinecraftServer server;
    private File savestateDirectory;
    public SavestateState state = SavestateState.NONE;
    private final List<Integer> indexList = new ArrayList<Integer>();
    private int latestIndex = 0;
    private int currentIndex;
    private final Logger logger;

    public SavestateHandler(MinecraftServer server, Logger logger) {
        this.server = server;
        this.logger = logger;
        this.createSavestateDirectory();
        this.refresh();
        this.loadCurrentIndexFromFile();
    }

    public void saveState() throws SavestateException, IOException {
        this.saveState(-1, true);
    }

    public void saveState(int savestateIndex, boolean tickrate0) throws SavestateException, IOException {
        this.saveState(savestateIndex, tickrate0, true);
    }

    public void saveState(int savestateIndex, boolean tickrate0, boolean changeIndex) throws SavestateException, IOException {
        if (this.state == SavestateState.SAVING) {
            throw new SavestateException("A savestating operation is already being carried out");
        }
        if (this.state == SavestateState.LOADING) {
            throw new SavestateException("A loadstate operation is being carried out");
        }
        this.state = SavestateState.SAVING;
        this.createSavestateDirectory();
        TickrateChangerServer.pauseGame(true);
        this.server = TASmod.getServerInstance();
        ClientMotionServer.requestMotionFromClient();
        this.server.func_184103_al().func_72389_g();
        this.server.func_71267_a(false);
        this.refresh();
        int indexToSave = savestateIndex;
        if (savestateIndex < 0) {
            indexToSave = this.currentIndex + 1;
        }
        this.setCurrentIndex(indexToSave, changeIndex);
        String worldname = this.server.func_71270_I();
        File currentfolder = new File(this.savestateDirectory, ".." + File.separator + worldname);
        File targetfolder = this.getSavestateFile(indexToSave);
        SavestateEvents.triggerSavestateEvent(targetfolder);
        if (targetfolder.exists()) {
            this.logger.warn("WARNING! Overwriting the savestate with the index {}", (Object)indexToSave);
            FileUtils.deleteDirectory((File)targetfolder);
        }
        if (savestateIndex != 0) {
            TASmod.packetServer.sendToAll(new InputSavestatesPacket(true, this.getSavestateName(indexToSave)));
        }
        for (WorldServer world : this.server.field_71305_c) {
            AnvilChunkLoader chunkloader = (AnvilChunkLoader)world.func_72863_F().field_73247_e;
            while (chunkloader.getPendingSaveCount() > 0) {
            }
        }
        this.saveSavestateDataFile(false);
        FileUtils.copyDirectory((File)currentfolder, (File)targetfolder);
        SavestateTrackerFile tracker = new SavestateTrackerFile(new File(this.savestateDirectory, worldname + "-info.txt"));
        tracker.increaseSavestates();
        tracker.saveFile();
        this.server.func_184103_al().func_148539_a((ITextComponent)new TextComponentString(TextFormatting.GREEN + "Savestate " + indexToSave + " saved"));
        TASmod.packetServer.sendToAll(new SavestatePacket());
        if (!tickrate0) {
            TickrateChangerServer.pauseGame(false);
        }
        this.state = SavestateState.NONE;
    }

    public void loadState() throws LoadstateException, IOException {
        this.loadState(-1, true);
    }

    public void loadState(int savestateIndex, boolean tickrate0) throws LoadstateException, IOException {
        this.loadState(savestateIndex, tickrate0, true);
    }

    public void loadState(int savestateIndex, boolean tickrate0, boolean changeIndex) throws LoadstateException, IOException {
        WorldServer[] worlds;
        int indexToLoad;
        if (this.state == SavestateState.SAVING) {
            throw new LoadstateException("A savestating operation is already being carried out");
        }
        if (this.state == SavestateState.LOADING) {
            throw new LoadstateException("A loadstate operation is being carried out");
        }
        this.state = SavestateState.LOADING;
        this.createSavestateDirectory();
        TickrateChangerServer.pauseGame(true);
        this.server = TASmod.getServerInstance();
        this.refresh();
        int n = indexToLoad = savestateIndex < 0 ? this.currentIndex : savestateIndex;
        if (!this.getSavestateFile(indexToLoad).exists()) {
            throw new LoadstateException("Savestate " + indexToLoad + " doesn't exist");
        }
        this.setCurrentIndex(indexToLoad, changeIndex);
        String worldname = this.server.func_71270_I();
        File currentfolder = new File(this.savestateDirectory, ".." + File.separator + worldname);
        File targetfolder = this.getSavestateFile(indexToLoad);
        SavestateEvents.triggerLoadstateEvent(targetfolder);
        if (savestateIndex != 0) {
            TASmod.packetServer.sendToAll(new InputSavestatesPacket(false, this.getSavestateName(indexToLoad)));
        }
        for (WorldServer world : this.server.field_71305_c) {
            world.field_73058_d = true;
        }
        TASmod.packetServer.sendToAll(new LoadstatePacket());
        SavestatesChunkControl.disconnectPlayersFromChunkMap();
        SavestatesChunkControl.unloadAllServerChunks();
        SavestatesChunkControl.flushSaveHandler();
        FileUtils.deleteDirectory((File)currentfolder);
        FileUtils.copyDirectory((File)targetfolder, (File)currentfolder);
        this.loadSavestateDataFile();
        SavestatePlayerLoading.loadAndSendMotionToPlayer();
        SavestatesChunkControl.updateSessionLock();
        SavestatesChunkControl.addPlayersToChunkMap();
        for (WorldServer world : this.server.field_71305_c) {
            world.field_73058_d = false;
        }
        SavestateTrackerFile tracker = new SavestateTrackerFile(new File(this.savestateDirectory, worldname + "-info.txt"));
        tracker.increaseRerecords();
        tracker.saveFile();
        this.server.func_184103_al().func_148539_a((ITextComponent)new TextComponentString(TextFormatting.GREEN + "Savestate " + indexToLoad + " loaded"));
        this.server.func_184103_al().func_181057_v().forEach(player -> SavestatesChunkControl.addPlayerToServerChunk(player));
        for (WorldServer world : worlds = DimensionManager.getWorlds()) {
            world.func_72835_b();
        }
        if (!tickrate0) {
            TickrateChangerServer.pauseGame(false);
        }
        this.state = SavestateState.WASLOADING;
    }

    private void createSavestateDirectory() {
        this.savestateDirectory = !this.server.func_71262_S() ? new File(this.server.func_71238_n() + File.separator + "saves" + File.separator + "savestates" + File.separator) : new File(this.server.func_71238_n() + File.separator + "savestates" + File.separator);
        if (!this.savestateDirectory.exists()) {
            this.savestateDirectory.mkdir();
        }
    }

    private void refresh() {
        this.indexList.clear();
        File[] files = this.savestateDirectory.listFiles(new FileFilter(){

            @Override
            public boolean accept(File pathname) {
                return pathname.getName().startsWith(SavestateHandler.this.server.func_71270_I() + "-Savestate");
            }
        });
        int index = 0;
        for (File file : files) {
            block4: {
                try {
                    Pattern patt = Pattern.compile("\\d+$");
                    Matcher matcher = patt.matcher(file.getName());
                    if (matcher.find()) {
                        index = Integer.parseInt(matcher.group(0));
                        break block4;
                    }
                    this.logger.warn(String.format("Could not process the savestate %s", file.getName()));
                }
                catch (NumberFormatException e) {
                    this.logger.warn(String.format("Could not process the savestate %s", e.getMessage()));
                }
                continue;
            }
            this.indexList.add(index);
        }
        Collections.sort(this.indexList);
        this.latestIndex = !this.indexList.isEmpty() ? this.indexList.get(this.indexList.size() - 1) : 0;
    }

    private File getSavestateFile(int index) {
        return new File(this.savestateDirectory, this.getSavestateName(index));
    }

    private String getSavestateName(int index) {
        return this.server.func_71270_I() + "-Savestate" + index;
    }

    public void deleteSavestate(int index) throws SavestateDeleteException {
        if (this.state == SavestateState.SAVING) {
            throw new SavestateDeleteException("A savestating operation is already being carried out");
        }
        if (this.state == SavestateState.LOADING) {
            throw new SavestateDeleteException("A loadstate operation is being carried out");
        }
        if (index < 0) {
            throw new SavestateDeleteException("Cannot delete the negative indexes");
        }
        if (index == 0) {
            throw new SavestateDeleteException("Cannot delete protected savestate 0");
        }
        File toDelete = this.getSavestateFile(index);
        if (toDelete.exists()) {
            try {
                FileUtils.deleteDirectory((File)toDelete);
            }
            catch (IOException e) {
                e.printStackTrace();
                throw new SavestateDeleteException("Something went wrong while trying to delete the savestate " + index);
            }
        } else {
            throw new SavestateDeleteException(TextFormatting.YELLOW + "Savestate " + index + " doesn't exist, so it can't be deleted");
        }
        this.refresh();
        if (!this.indexList.contains(this.currentIndex)) {
            this.setCurrentIndex(this.latestIndex, true);
        }
        this.server.func_184103_al().func_148539_a((ITextComponent)new TextComponentString(TextFormatting.GREEN + "Savestate " + index + " deleted"));
    }

    public void deleteSavestate(int from, int to) throws SavestateDeleteException {
        if (this.state == SavestateState.SAVING) {
            throw new SavestateDeleteException("A savestating operation is already being carried out");
        }
        if (this.state == SavestateState.LOADING) {
            throw new SavestateDeleteException("A loadstate operation is being carried out");
        }
        if (from >= to) {
            throw new SavestateDeleteException("Can't delete amounts that are negative or 0");
        }
        for (int i = from; i <= to; ++i) {
            try {
                this.deleteSavestate(i);
                continue;
            }
            catch (SavestateDeleteException e) {
                this.server.func_184103_al().func_148539_a((ITextComponent)new TextComponentString(TextFormatting.RED + e.getMessage()));
            }
        }
    }

    public String getIndexesAsString() {
        this.refresh();
        String out = "";
        for (int i : this.indexList) {
            out = out.concat(" " + i + (i == this.indexList.size() - 1 ? "" : ","));
        }
        return out;
    }

    private void saveSavestateDataFile(boolean legacy) {
        File savestateDat;
        File tasmodDir = new File(this.savestateDirectory, "../" + this.server.func_71270_I() + "/tasmod/");
        if (!tasmodDir.exists()) {
            tasmodDir.mkdir();
        }
        if ((savestateDat = new File(tasmodDir, "savestateData.txt")).exists()) {
            savestateDat.delete();
        }
        SavestateDataFile file = new SavestateDataFile();
        file.set(SavestateDataFile.DataValues.INDEX, Integer.toString(this.currentIndex));
        if (!legacy && TASmod.ktrngHandler.isLoaded()) {
            file.set(SavestateDataFile.DataValues.SEED, Long.toString(TASmod.ktrngHandler.getGlobalSeedServer()));
        }
        file.save(savestateDat);
    }

    private void loadSavestateDataFile() {
        File tasmodDir = new File(this.savestateDirectory, "../" + this.server.func_71270_I() + "/tasmod/");
        File savestateDat = new File(tasmodDir, "savestateData.txt");
        if (!savestateDat.exists()) {
            return;
        }
        SavestateDataFile datafile = new SavestateDataFile();
        datafile.load(savestateDat);
        if (TASmod.ktrngHandler.isLoaded()) {
            String seedString = datafile.get(SavestateDataFile.DataValues.SEED);
            if (seedString != null) {
                TASmod.ktrngHandler.sendGlobalSeedToServer(Long.parseLong(seedString));
            } else {
                this.logger.warn("KTRNG seed not loaded because it was not found in savestateData.txt!");
            }
        }
    }

    public void loadCurrentIndexFromFile() {
        File savestateDat;
        int index = -1;
        File tasmodDir = new File(this.savestateDirectory, "../" + this.server.func_71270_I() + "/tasmod/");
        if (!tasmodDir.exists()) {
            tasmodDir.mkdir();
        }
        if ((savestateDat = new File(tasmodDir, "savestate.data")).exists()) {
            index = this.legacyIndexFile(savestateDat);
            this.setCurrentIndex(index, true);
            this.saveSavestateDataFile(true);
            savestateDat.delete();
            return;
        }
        savestateDat = new File(tasmodDir, "savestateData.txt");
        if (savestateDat.exists()) {
            SavestateDataFile file = new SavestateDataFile();
            file.load(savestateDat);
            index = Integer.parseInt(file.get(SavestateDataFile.DataValues.INDEX));
            this.setCurrentIndex(index, true);
        }
    }

    private void setCurrentIndex(int index, boolean changeIndex) {
        if (changeIndex) {
            this.currentIndex = index < 0 ? this.latestIndex : index;
            this.logger.info("Setting the savestate index to {}", (Object)this.currentIndex);
        } else {
            this.logger.warn("Keeping the savestate index at {}", (Object)this.currentIndex);
        }
    }

    public int getCurrentIndex() {
        return this.currentIndex;
    }

    public static void playerLoadSavestateEventServer() {
        PlayerList playerList = TASmod.getServerInstance().func_184103_al();
        for (EntityPlayerMP player : playerList.func_181057_v()) {
            NBTTagCompound nbttagcompound = playerList.getPlayerNBT(player);
            SavestatePlayerLoading.reattachEntityToPlayer(nbttagcompound, (World)player.func_71121_q(), (Entity)player);
        }
        SavestatesChunkControl.updateWorldServerTickListEntries();
    }

    @SideOnly(value=Side.CLIENT)
    public static void playerLoadSavestateEventClient() {
        SavestatesChunkControl.addPlayerToClientChunk((EntityPlayer)Minecraft.func_71410_x().field_71439_g);
    }

    private int legacyIndexFile(File savestateDat) {
        int index = -1;
        List lines = new ArrayList();
        try {
            lines = FileUtils.readLines((File)savestateDat, (Charset)StandardCharsets.UTF_8);
        }
        catch (IOException e) {
            this.logger.warn("No savestate.data file found in current world folder, ignoring it");
        }
        if (!lines.isEmpty()) {
            for (String line : lines) {
                if (!line.startsWith("currentIndex=")) continue;
                try {
                    index = Integer.parseInt(line.split("=")[1]);
                }
                catch (NumberFormatException e) {
                    e.printStackTrace();
                }
            }
        }
        return index;
    }
}

