/*
 * Decompiled with CFR 0.152.
 */
package com.minecrafttas.tasmod.savestates.server;

import com.minecrafttas.tasmod.TASmod;
import com.minecrafttas.tasmod.networking.Packet;
import com.minecrafttas.tasmod.networking.PacketSide;
import com.minecrafttas.tasmod.savestates.client.gui.GuiSavestateSavingScreen;
import com.minecrafttas.tasmod.savestates.server.SavestateState;
import com.minecrafttas.tasmod.savestates.server.exceptions.SavestateException;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import net.minecraft.util.text.TextFormatting;

public class SavestatePacket
implements Packet {
    public int index;

    public SavestatePacket() {
        this.index = -1;
    }

    public SavestatePacket(int index) {
        this.index = index;
    }

    @Override
    public void handle(PacketSide side, EntityPlayer playerz) {
        if (side.isServer()) {
            EntityPlayerMP player = (EntityPlayerMP)playerz;
            player.func_71121_q().func_152344_a(() -> {
                if (!player.func_70003_b(2, "savestate")) {
                    player.func_145747_a((ITextComponent)new TextComponentString(TextFormatting.RED + "You don't have permission to do that"));
                    return;
                }
                try {
                    TASmod.savestateHandler.saveState(this.index, true);
                }
                catch (SavestateException e) {
                    player.func_145747_a((ITextComponent)new TextComponentString(TextFormatting.RED + "Failed to create a savestate: " + e.getMessage()));
                }
                catch (Exception e) {
                    e.printStackTrace();
                    player.func_145747_a((ITextComponent)new TextComponentString(TextFormatting.RED + "Failed to create a savestate: " + e.getCause().toString()));
                }
                finally {
                    TASmod.savestateHandler.state = SavestateState.NONE;
                }
            });
        } else {
            Minecraft.func_71410_x().func_152344_a(() -> {
                Minecraft mc = Minecraft.func_71410_x();
                if (!(mc.field_71462_r instanceof GuiSavestateSavingScreen)) {
                    mc.func_147108_a((GuiScreen)new GuiSavestateSavingScreen());
                } else {
                    mc.func_147108_a(null);
                }
            });
        }
    }

    @Override
    public void serialize(PacketBuffer buf) {
        buf.writeInt(this.index);
    }

    @Override
    public void deserialize(PacketBuffer buf) {
        this.index = buf.readInt();
    }
}

