/*
 * Decompiled with CFR 0.152.
 */
package com.minecrafttas.tasmod.savestates.server.chunkloading;

import com.minecrafttas.tasmod.TASmod;
import com.minecrafttas.tasmod.duck.ChunkProviderDuck;
import com.minecrafttas.tasmod.mixin.accessors.AccessorSaveHandler;
import com.minecrafttas.tasmod.mixin.accessors.AccessorWorld;
import com.minecrafttas.tasmod.mixin.accessors.AccessorWorldServer;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ChunkProviderClient;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.NextTickListEntry;
import net.minecraft.world.WorldServer;
import net.minecraft.world.chunk.Chunk;
import net.minecraft.world.gen.ChunkProviderServer;
import net.minecraftforge.common.DimensionManager;
import net.minecraftforge.fml.common.FMLCommonHandler;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class SavestatesChunkControl {
    @SideOnly(value=Side.CLIENT)
    public static void unloadAllClientChunks() {
        Minecraft mc = Minecraft.func_71410_x();
        ChunkProviderClient chunkProvider = mc.field_71441_e.func_72863_F();
        ((ChunkProviderDuck)chunkProvider).unloadAllChunks();
        Minecraft.func_71410_x().field_71438_f.func_72712_a();
    }

    public static void unloadAllServerChunks() {
        WorldServer[] worlds;
        for (WorldServer world : worlds = DimensionManager.getWorlds()) {
            ChunkProviderServer chunkProvider = world.func_72863_F();
            ((ChunkProviderDuck)chunkProvider).unloadAllChunks();
        }
    }

    public static void disconnectPlayersFromChunkMap() {
        WorldServer[] worlds;
        MinecraftServer server = FMLCommonHandler.instance().getMinecraftServerInstance();
        List players = server.func_184103_al().func_181057_v();
        for (WorldServer world : worlds = DimensionManager.getWorlds()) {
            for (EntityPlayerMP player : players) {
                world.func_184164_w().func_72695_c(player);
            }
        }
    }

    public static void addPlayersToChunkMap() {
        MinecraftServer server = FMLCommonHandler.instance().getMinecraftServerInstance();
        List players = server.func_184103_al().func_181057_v();
        for (EntityPlayerMP player : players) {
            WorldServer world = DimensionManager.getWorld((int)player.field_71093_bK);
            world.func_184164_w().func_72683_a(player);
            world.func_72863_F().func_186025_d((int)player.field_70165_t >> 4, (int)player.field_70161_v >> 4);
        }
    }

    public static void flushSaveHandler() {
        WorldServer[] worlds;
        for (WorldServer world : worlds = DimensionManager.getWorlds()) {
            world.func_72860_G().func_75759_a();
        }
    }

    public static void updateSessionLock() {
        WorldServer[] worlds;
        for (WorldServer world : worlds = DimensionManager.getWorlds()) {
            ((AccessorSaveHandler)world.func_72860_G()).invokeSetSessionLock();
        }
    }

    @SideOnly(value=Side.CLIENT)
    public static void keepPlayerInLoadedEntityList(EntityPlayer player) {
        ((AccessorWorld)Minecraft.func_71410_x().field_71441_e).unloadedEntityList().remove(player);
    }

    @SideOnly(value=Side.CLIENT)
    public static void addPlayerToClientChunk(EntityPlayer player) {
        int i = MathHelper.func_76128_c((double)(player.field_70165_t / 16.0));
        int j = MathHelper.func_76128_c((double)(player.field_70161_v / 16.0));
        Chunk chunk = Minecraft.func_71410_x().field_71441_e.func_72964_e(i, j);
        for (int k = 0; k < chunk.func_177429_s().length; ++k) {
            if (!chunk.func_177429_s()[k].contains((Object)player)) continue;
            return;
        }
        chunk.func_76612_a((Entity)player);
    }

    public static void addPlayerToServerChunk(EntityPlayerMP player) {
        int i = MathHelper.func_76128_c((double)(player.field_70165_t / 16.0));
        int j = MathHelper.func_76128_c((double)(player.field_70161_v / 16.0));
        WorldServer world = player.func_71121_q();
        Chunk chunk = world.func_72964_e(i, j);
        for (int k = 0; k < chunk.func_177429_s().length; ++k) {
            if (!chunk.func_177429_s()[k].contains((Object)player)) continue;
            return;
        }
        chunk.func_76612_a((Entity)player);
    }

    public static void updateWorldServerTickListEntries() {
        MinecraftServer server = TASmod.getServerInstance();
        for (WorldServer world : server.field_71305_c) {
            AccessorWorldServer acworld = (AccessorWorldServer)world;
            for (NextTickListEntry nextticklistentry : acworld.getTickListEntries()) {
                nextticklistentry.func_77176_a(world.func_82737_E());
            }
        }
    }
}

