/*
 * Decompiled with CFR 0.152.
 */
package com.minecrafttas.tasmod.savestates.server.files;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Reader;
import java.io.Writer;
import java.util.InvalidPropertiesFormatException;
import java.util.Properties;

public class SavestateDataFile {
    Properties properties = new Properties();

    public void set(DataValues key, String val) {
        this.properties.setProperty(key.getConfigName(), val);
    }

    public String get(DataValues key) {
        return this.properties.getProperty(key.getConfigName());
    }

    public void save(File file) {
        try {
            FileWriter writer = new FileWriter(file);
            this.properties.store(writer, "Data for this savestate from TASmod");
            ((Writer)writer).close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public void load(File file) {
        try {
            FileReader reader = new FileReader(file);
            this.properties.load(reader);
            ((Reader)reader).close();
        }
        catch (InvalidPropertiesFormatException e) {
            e.printStackTrace();
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public static enum DataValues {
        INDEX("currentIndex"),
        Name("savestateName"),
        SEED("ktrngSeed");

        private String configname;

        private DataValues(String configname) {
            this.configname = configname;
        }

        public String getConfigName() {
            return this.configname;
        }
    }
}

