/*
 * Decompiled with CFR 0.152.
 */
package com.minecrafttas.tasmod.savestates.server.files;

import java.io.File;
import java.io.IOException;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.io.FileUtils;

public class SavestateTrackerFile {
    private final File saveLocation;
    private final String top = "# This file was generated by TASmod/LoTAS and diplays info about the usage of savestates\n\n";
    public static int savestatecount;
    public static int loadstatecount;

    public SavestateTrackerFile(File saveLocation) throws IOException {
        this.saveLocation = saveLocation;
        if (!saveLocation.exists()) {
            savestatecount = 0;
            loadstatecount = 0;
        } else {
            this.loadFile();
        }
    }

    private void loadFile() throws IOException {
        List lines = FileUtils.readLines((File)this.saveLocation, (Charset)Charset.defaultCharset());
        lines.forEach(line -> {
            if (line.startsWith("Total Savestates")) {
                savestatecount = Integer.parseInt(line.split("=")[1]);
            } else if (line.startsWith("Total Rerecords")) {
                loadstatecount = Integer.parseInt(line.split("=")[1]);
            }
        });
    }

    public void increaseSavestates() {
        ++savestatecount;
    }

    public void increaseRerecords() {
        ++loadstatecount;
    }

    public void saveFile() throws IOException {
        ArrayList<String> lines = new ArrayList<String>();
        lines.add("# This file was generated by TASmod/LoTAS and diplays info about the usage of savestates\n\n");
        lines.add("Total Savestates=" + savestatecount + "\nTotal Rerecords=" + loadstatecount);
        FileUtils.writeLines((File)this.saveLocation, lines);
    }
}

