/*
 * Decompiled with CFR 0.152.
 */
package com.minecrafttas.tasmod.savestates.server.motion;

import com.minecrafttas.tasmod.networking.Packet;
import com.minecrafttas.tasmod.networking.PacketSide;
import com.minecrafttas.tasmod.savestates.server.motion.ClientMotionServer;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.network.PacketBuffer;

public class MotionPacket
implements Packet {
    private double x = 0.0;
    private double y = 0.0;
    private double z = 0.0;
    private float rx = 0.0f;
    private float ry = 0.0f;
    private float rz = 0.0f;
    private boolean sprinting;
    private float jumpMovementVector = 0.2f;

    public MotionPacket() {
    }

    public MotionPacket(double x, double y, double z, float moveForward, float moveVertical, float moveStrafe, boolean isSprinting, float jumpMovementVector) {
        this.x = x;
        this.y = y;
        this.z = z;
        this.rx = moveForward;
        this.ry = moveVertical;
        this.rz = moveStrafe;
        this.sprinting = isSprinting;
        this.jumpMovementVector = jumpMovementVector;
    }

    @Override
    public void handle(PacketSide side, EntityPlayer playercommon) {
        if (side.isServer()) {
            EntityPlayerMP player = (EntityPlayerMP)playercommon;
            ClientMotionServer.getMotion().put(player, new ClientMotionServer.Saver(this.x, this.y, this.z, this.rx, this.ry, this.rz, this.sprinting, this.jumpMovementVector));
        }
    }

    @Override
    public void serialize(PacketBuffer buf) {
        buf.writeDouble(this.x);
        buf.writeDouble(this.y);
        buf.writeDouble(this.z);
        buf.writeFloat(this.rx);
        buf.writeFloat(this.ry);
        buf.writeFloat(this.rz);
        buf.writeBoolean(this.sprinting);
        buf.writeFloat(this.jumpMovementVector);
    }

    @Override
    public void deserialize(PacketBuffer buf) {
        this.x = buf.readDouble();
        this.y = buf.readDouble();
        this.z = buf.readDouble();
        this.rx = buf.readFloat();
        this.ry = buf.readFloat();
        this.rz = buf.readFloat();
        this.sprinting = buf.readBoolean();
        this.jumpMovementVector = buf.readFloat();
    }
}

