/*
 * Decompiled with CFR 0.152.
 */
package com.minecrafttas.tasmod.savestates.server.playerloading;

import com.minecrafttas.tasmod.events.CameraInterpolationEvents;
import com.minecrafttas.tasmod.networking.Packet;
import com.minecrafttas.tasmod.networking.PacketSide;
import com.minecrafttas.tasmod.savestates.server.chunkloading.SavestatesChunkControl;
import com.minecrafttas.tasmod.savestates.server.playerloading.SavestatePlayerLoading;
import java.io.IOException;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.EntityPlayerSP;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.PacketBuffer;
import net.minecraft.world.GameType;

public class SavestatePlayerLoadingPacket
implements Packet {
    private NBTTagCompound compound;

    public SavestatePlayerLoadingPacket() {
    }

    public SavestatePlayerLoadingPacket(NBTTagCompound nbttagcompound) {
        this.compound = nbttagcompound;
    }

    @Override
    public void handle(PacketSide side, EntityPlayer playerz) {
        if (side.isClient()) {
            EntityPlayerSP player = (EntityPlayerSP)playerz;
            player.func_70020_e(this.compound);
            NBTTagCompound motion = this.compound.func_74775_l("clientMotion");
            double x = motion.func_74769_h("x");
            double y = motion.func_74769_h("y");
            double z = motion.func_74769_h("z");
            player.field_70159_w = x;
            player.field_70181_x = y;
            player.field_70179_y = z;
            float rx = motion.func_74760_g("RelativeX");
            float ry = motion.func_74760_g("RelativeY");
            float rz = motion.func_74760_g("RelativeZ");
            player.field_191988_bg = rx;
            player.field_70701_bs = ry;
            player.field_70702_br = rz;
            boolean sprinting = motion.func_74767_n("Sprinting");
            float jumpVector = motion.func_74760_g("JumpFactor");
            player.func_70031_b(sprinting);
            player.field_70747_aH = jumpVector;
            int gamemode = this.compound.func_74762_e("playerGameType");
            GameType type = GameType.func_77146_a((int)gamemode);
            Minecraft.func_71410_x().field_71442_b.func_78746_a(type);
            CameraInterpolationEvents.rotationPitch = player.field_70125_A;
            CameraInterpolationEvents.rotationYaw = player.field_70177_z + 180.0f;
            SavestatesChunkControl.keepPlayerInLoadedEntityList((EntityPlayer)player);
            SavestatePlayerLoading.wasLoading = true;
        }
    }

    @Override
    public void serialize(PacketBuffer buf) {
        buf.func_150786_a(this.compound);
    }

    @Override
    public void deserialize(PacketBuffer buf) {
        try {
            this.compound = buf.func_150793_b();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }
}

