/*
 * Decompiled with CFR 0.152.
 */
package com.minecrafttas.tasmod.shield;

import com.google.common.collect.Maps;
import com.mojang.authlib.GameProfile;
import java.awt.image.BufferedImage;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.nio.channels.Channels;
import java.nio.channels.ReadableByteChannel;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.net.ssl.HttpsURLConnection;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.IImageBuffer;
import net.minecraft.client.renderer.ThreadDownloadImageData;
import net.minecraft.client.renderer.texture.ITextureObject;
import net.minecraft.client.renderer.texture.TextureManager;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.util.ResourceLocation;

public class ShieldDownloader {
    private final ResourceLocation bottleshield = new ResourceLocation("tasmod:textures/shields/bottleshield.png");
    private final String defaultshield = "bottleshield";
    private final String cacheLocation = "tasmod/shields/";
    private Map<String, String> cacheNames;
    public static EntityLivingBase renderedEntity;

    public ResourceLocation getResourceLocation(EntityLivingBase entitylivingbaseIn) {
        String uuid = entitylivingbaseIn.func_110124_au().toString();
        ResourceLocation cachedLocation = new ResourceLocation("tasmod/shields/" + uuid);
        if (!this.rExists(cachedLocation)) {
            return this.bottleshield;
        }
        return cachedLocation;
    }

    public void onPlayerJoin(GameProfile profile) {
        String uuid = profile.getId().toString();
        this.loadTexture(uuid);
    }

    private void loadTexture(String uuid) {
        ResourceLocation cachedLocation = new ResourceLocation("tasmod/shields/" + uuid);
        if (!this.rExists(cachedLocation)) {
            String urlname = "https://minecrafttas.com/" + uuid;
            URL url = null;
            TextureManager textureManager = Minecraft.func_71410_x().func_110434_K();
            try {
                url = new URL(urlname);
                HttpsURLConnection connection = (HttpsURLConnection)url.openConnection();
                connection.setReadTimeout(5000);
                connection.setInstanceFollowRedirects(false);
                if (connection.getResponseCode() != 301) {
                    return;
                }
                urlname = connection.getHeaderField("Location");
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            IImageBuffer iib = new IImageBuffer(){

                public BufferedImage func_78432_a(BufferedImage var1) {
                    return var1;
                }

                public void func_152634_a() {
                }
            };
            ThreadDownloadImageData downloadedShield = new ThreadDownloadImageData(null, urlname, null, iib);
            textureManager.func_110579_a(cachedLocation, (ITextureObject)downloadedShield);
        }
    }

    private boolean rExists(ResourceLocation resourceLocation) {
        ITextureObject resource = Minecraft.func_71410_x().func_110434_K().func_110581_b(resourceLocation);
        return resource != null;
    }

    @Deprecated
    public ResourceLocation getResourceLocationOld(EntityLivingBase entitylivingbaseIn) {
        String playerUUID = entitylivingbaseIn.func_110124_au().toString();
        String name = this.getShieldName(playerUUID);
        if (!name.contentEquals("bottleshield")) {
            return new ResourceLocation("tasmod/shields/" + name);
        }
        return this.bottleshield;
    }

    @Deprecated
    public void downloadFromTASTools(String uuid, String location) {
        String name = this.getShieldName(uuid);
        if (name != null && !name.isEmpty()) {
            String url = "https://raw.githubusercontent.com/ScribbleLP/MC-TASTools/1.12.2/shields/" + name;
            TextureManager textureManager = Minecraft.func_71410_x().func_110434_K();
            ResourceLocation cachedLocation = new ResourceLocation(location + name);
            if (!this.rExists(cachedLocation)) {
                IImageBuffer iib = new IImageBuffer(){

                    public BufferedImage func_78432_a(BufferedImage var1) {
                        return var1;
                    }

                    public void func_152634_a() {
                    }
                };
                ThreadDownloadImageData downloadedShield = new ThreadDownloadImageData(null, url, null, iib);
                textureManager.func_110579_a(cachedLocation, (ITextureObject)downloadedShield);
            }
        }
    }

    @Deprecated
    private String getShieldName(String uuid) {
        this.cacheNames = this.downloadNames();
        if (this.cacheNames != null) {
            if (this.cacheNames.containsKey(uuid)) {
                return this.cacheNames.get(uuid);
            }
            return "bottleshield";
        }
        return "bottleshield";
    }

    @Deprecated
    private Map<String, String> downloadNames() {
        URL url;
        File feil = new File(Minecraft.func_71410_x().field_71412_D + File.separator + "playerstt.txt");
        Map<Object, Object> uuids = Maps.newHashMap();
        try {
            url = new URL("https://raw.githubusercontent.com/ScribbleLP/MC-TASTools/1.12.2/shields/shieldnames.txt");
        }
        catch (MalformedURLException e1) {
            e1.printStackTrace();
            return null;
        }
        try {
            uuids = this.mapNames(this.readThingsFromURL(url, feil));
        }
        catch (IOException e) {
            e.printStackTrace();
            return null;
        }
        return uuids;
    }

    @Deprecated
    private Map<String, String> mapNames(List<String> input) {
        HashMap output = Maps.newHashMap();
        for (int i = 0; i < input.size(); ++i) {
            String line = input.get(i);
            if (!line.contains(":")) {
                return null;
            }
            String[] split = line.split(":");
            output.put(split[0], split[1]);
        }
        return output;
    }

    private List<String> readThingsFromURL(URL url, File file) throws IOException {
        ReadableByteChannel readableByteChannel = Channels.newChannel(url.openStream());
        FileOutputStream fileOutputStream = new FileOutputStream(file);
        fileOutputStream.getChannel().transferFrom(readableByteChannel, 0L, Long.MAX_VALUE);
        fileOutputStream.close();
        return this.readThings(file);
    }

    private List<String> readThings(File file) throws IOException {
        String s;
        BufferedReader reader = new BufferedReader(new FileReader(file));
        ArrayList<String> out = new ArrayList<String>();
        while ((s = reader.readLine()) != null) {
            out.add(s);
        }
        reader.close();
        return out;
    }
}

