/*
 * Decompiled with CFR 0.152.
 */
package com.minecrafttas.tasmod.tickratechanger;

import com.minecrafttas.tasmod.networking.Packet;
import com.minecrafttas.tasmod.networking.PacketSide;
import com.minecrafttas.tasmod.tickratechanger.TickrateChangerClient;
import com.minecrafttas.tasmod.tickratechanger.TickrateChangerServer;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.network.PacketBuffer;

public class PauseTickratePacket
implements Packet {
    private short status;

    public PauseTickratePacket() {
        this.status = 0;
    }

    public PauseTickratePacket(State state) {
        this.status = state.toShort();
    }

    public State getState() {
        return State.fromShort(this.status);
    }

    @Override
    public void handle(PacketSide side, EntityPlayer player) {
        if (side.isServer()) {
            if (player.func_70003_b(2, "tickrate")) {
                State state = this.getState();
                if (state == State.PAUSE) {
                    TickrateChangerServer.pauseGame(true);
                } else if (state == State.UNPAUSE) {
                    TickrateChangerServer.pauseGame(false);
                } else if (state == State.TOGGLE) {
                    TickrateChangerServer.togglePause();
                }
            }
        } else if (side.isClient()) {
            State state = this.getState();
            if (state == State.PAUSE) {
                TickrateChangerClient.pauseClientGame(true);
            } else if (state == State.UNPAUSE) {
                TickrateChangerClient.pauseClientGame(false);
            } else if (state == State.TOGGLE) {
                TickrateChangerClient.togglePauseClient();
            }
        }
    }

    @Override
    public void serialize(PacketBuffer buf) {
        buf.writeShort((int)this.status);
    }

    @Override
    public void deserialize(PacketBuffer buf) {
        this.status = buf.readShort();
    }

    public static enum State {
        PAUSE(1),
        UNPAUSE(2),
        TOGGLE(0);

        private short id;

        private State(short i) {
            this.id = i;
        }

        public short toShort() {
            return this.id;
        }

        public static State fromShort(short i) {
            switch (i) {
                case 1: {
                    return PAUSE;
                }
                case 2: {
                    return UNPAUSE;
                }
            }
            return TOGGLE;
        }
    }
}

