/*
 * Decompiled with CFR 0.152.
 */
package com.minecrafttas.tasmod.tickratechanger;

import com.minecrafttas.tasmod.TASmod;
import com.minecrafttas.tasmod.networking.Packet;
import com.minecrafttas.tasmod.tickratechanger.AdvanceTickratePacket;
import com.minecrafttas.tasmod.tickratechanger.ChangeTickratePacket;
import net.minecraft.entity.player.EntityPlayerMP;
import org.apache.logging.log4j.Logger;

public class TickrateChangerServer {
    public static float ticksPerSecond = 20.0f;
    public static long millisecondsPerTick = 50L;
    public static float tickrateSaved = 20.0f;
    public static boolean advanceTick = false;
    public static Logger logger;

    public static void changeTickrate(float tickrate) {
        TickrateChangerServer.changeClientTickrate(tickrate);
        TickrateChangerServer.changeServerTickrate(tickrate);
    }

    public static void changeClientTickrate(float tickrate) {
        TickrateChangerServer.changeClientTickrate(tickrate, false);
    }

    public static void changeClientTickrate(float tickrate, boolean log) {
        if (log) {
            TickrateChangerServer.log("Changing the tickrate " + tickrate + " to all clients");
        }
        TASmod.packetServer.sendToAll(new ChangeTickratePacket(tickrate));
    }

    public static void changeServerTickrate(float tickrate) {
        TickrateChangerServer.changeServerTickrate(tickrate, true);
    }

    public static void changeServerTickrate(float tickrate, boolean log) {
        if (tickrate > 0.0f) {
            millisecondsPerTick = (long)(1000.0f / tickrate);
        } else if (tickrate == 0.0f && ticksPerSecond != 0.0f) {
            tickrateSaved = ticksPerSecond;
        }
        ticksPerSecond = tickrate;
        if (log) {
            TickrateChangerServer.log("Setting the server tickrate to " + ticksPerSecond);
        }
    }

    public static void togglePause() {
        if (ticksPerSecond > 0.0f) {
            TickrateChangerServer.changeTickrate(0.0f);
        } else if (ticksPerSecond == 0.0f) {
            TickrateChangerServer.changeTickrate(tickrateSaved);
        }
    }

    public static void pauseGame(boolean pause) {
        if (pause) {
            TickrateChangerServer.changeTickrate(0.0f);
        } else {
            advanceTick = false;
            TickrateChangerServer.changeTickrate(tickrateSaved);
        }
    }

    public static void pauseServerGame(boolean pause) {
        if (pause) {
            TickrateChangerServer.changeServerTickrate(0.0f);
        } else {
            TickrateChangerServer.changeServerTickrate(tickrateSaved);
        }
    }

    public static void advanceTick() {
        TickrateChangerServer.advanceServerTick();
        TickrateChangerServer.advanceClientTick();
    }

    private static void advanceClientTick() {
        TASmod.packetServer.sendToAll(new AdvanceTickratePacket());
    }

    private static void advanceServerTick() {
        if (ticksPerSecond == 0.0f) {
            advanceTick = true;
            TickrateChangerServer.changeServerTickrate(tickrateSaved);
        }
    }

    public static void joinServer(EntityPlayerMP player) {
        if (TASmod.getServerInstance().func_71262_S()) {
            TickrateChangerServer.log("Sending the current tickrate (" + ticksPerSecond + ") to " + player.func_70005_c_());
            TASmod.packetServer.sendTo((Packet)new ChangeTickratePacket(ticksPerSecond), player);
        }
    }

    private static void log(String msg) {
        logger.info(msg);
    }
}

