/*
 * Decompiled with CFR 0.152.
 */
package com.minecrafttas.tasmod.util;

import com.dselent.bigarraylist.BigArrayList;
import com.minecrafttas.tasmod.TASmod;
import com.minecrafttas.tasmod.inputcontainer.InputContainer;
import com.minecrafttas.tasmod.inputcontainer.TickInputContainer;
import com.minecrafttas.tasmod.inputcontainer.controlbytes.ControlByteHandler;
import com.minecrafttas.tasmod.util.FileThread;
import com.minecrafttas.tasmod.virtual.VirtualKey;
import com.minecrafttas.tasmod.virtual.VirtualKeyboard;
import com.minecrafttas.tasmod.virtual.VirtualMouse;
import com.minecrafttas.tasmod.virtual.VirtualSubticks;
import com.mojang.realmsclient.util.Pair;
import java.io.File;
import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.commons.io.FileUtils;

public class ContainerSerialiser {
    public void saveToFileV1(File file, InputContainer container) throws IOException {
        this.saveToFileV1Until(file, container, -1);
    }

    public void saveToFileV1Until(File file, InputContainer container, int index) throws IOException {
        if (container.size() == 0) {
            throw new IOException("There are no inputs to save to a file");
        }
        FileThread fileThread = new FileThread(file, false);
        fileThread.start();
        fileThread.addLine("################################################# TASFile ###################################################\n#\t\t\t\t\t\t\t\t\t\t\t\tVersion:1\t\t\t\t\t\t\t\t\t\t\t\t\t#\n#\t\t\t\t\t\t\tThis file was generated using the Minecraft TASMod\t\t\t\t\t\t\t\t#\n#\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t#\n#\t\t\tAny errors while reading this file will be printed out in the console and the chat\t\t\t\t#\n#\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t#\n#------------------------------------------------ Header ---------------------------------------------------#\n#Author:" + container.getAuthors() + "\n#\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t#\n#Title:" + container.getTitle() + "\n#\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t#\n#Playing Time:" + container.getPlaytime() + "\n#\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t#\n#Rerecords:" + container.getRerecords() + "\n#\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t#\n#----------------------------------------------- Settings --------------------------------------------------#\n#StartPosition:" + container.getStartLocation() + "\n#\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t#\n#StartSeed:" + container.getStartSeed() + "\n#############################################################################################################\n#Comments start with \"//\" at the start of the line, comments with # will not be saved\n");
        BigArrayList<TickInputContainer> ticks = container.getInputs();
        Map<Integer, List<Pair<String, String[]>>> cbytes = container.getControlBytes();
        Map<Integer, List<String>> comments = container.getComments();
        for (int i = 0; (long)i < ticks.size() && i != index; ++i) {
            List<Pair<String, String[]>> cbytelist;
            String cbyteString;
            if (comments.containsKey(i)) {
                List<String> multiLine = comments.get(i);
                multiLine.forEach(comment -> fileThread.addLine("//" + comment + "\n"));
            }
            if (cbytes.containsKey(i) && !(cbyteString = ControlByteHandler.toString(cbytelist = cbytes.get(i))).isEmpty()) {
                fileThread.addLine(cbyteString);
            }
            TickInputContainer tick = ticks.get(i);
            fileThread.addLine(tick.toString() + "~&\t\t\t\t//Monitoring:" + container.dMonitor.get(i) + "\n");
        }
        fileThread.close();
    }

    public int getFileVersion(File file) throws IOException {
        List lines = FileUtils.readLines((File)file, (Charset)Charset.defaultCharset());
        for (String line : lines) {
            if (!line.contains("Version")) continue;
            String trimmed = line.replaceAll("#|\t", "");
            int tick = 0;
            try {
                tick = Integer.parseInt(trimmed.split(":")[1]);
            }
            catch (NumberFormatException e) {
                throw new IOException("Can't read the file version: " + trimmed);
            }
            return tick;
        }
        return 0;
    }

    public InputContainer fromEntireFileV1(File file) throws IOException {
        List lines = FileUtils.readLines((File)file, (Charset)StandardCharsets.UTF_8);
        File monitorFile = new File(file, "../" + file.getName().replace(".tas", "") + ".mon");
        List<String> monitorLines = new ArrayList();
        if (monitorFile.exists()) {
            monitorLines = FileUtils.readLines((File)monitorFile, (Charset)StandardCharsets.UTF_8);
            monitorFile.delete();
        }
        boolean oldmonfileLoaded = !monitorLines.isEmpty();
        InputContainer container = new InputContainer();
        String author = "Insert author here";
        String title = "Insert TAS category here";
        String playtime = "00:00.0";
        int rerecords = 0;
        String startLocation = "";
        long startSeed = TASmod.ktrngHandler.getGlobalSeedClient();
        container.clear();
        int linenumber = 0;
        for (String line : lines) {
            String[] commentData;
            String[] sections;
            ++linenumber;
            int tickcount = (int)container.getInputs().size();
            if (line.startsWith("#")) {
                if (line.startsWith("#Author:")) {
                    author = line.split(":")[1];
                    continue;
                }
                if (line.startsWith("#Title:")) {
                    title = line.split(":")[1];
                    continue;
                }
                if (line.startsWith("#Playing Time:")) {
                    playtime = line.split("Playing Time:")[1];
                    continue;
                }
                if (line.startsWith("#Rerecords:")) {
                    rerecords = Integer.parseInt(line.split(":")[1]);
                    continue;
                }
                if (line.startsWith("#StartPosition:")) {
                    startLocation = line.replace("#StartPosition:", "");
                    continue;
                }
                if (!line.startsWith("#StartSeed:")) continue;
                startSeed = Long.parseLong(line.replace("#StartSeed:", ""));
                continue;
            }
            if (line.startsWith("$") && line.replace('$', ' ').trim().contains(" ")) {
                String[] sections2 = line.replace('$', ' ').trim().split(" ", 2);
                if (sections2.length == 0) continue;
                String control = sections2[0];
                String[] params = sections2[1].split(" ");
                List cbytes = container.getControlBytes().getOrDefault(tickcount, new ArrayList());
                cbytes.add(Pair.of((Object)control, (Object)params));
                container.getControlBytes().put(tickcount, cbytes);
                continue;
            }
            if (line.startsWith("//")) {
                List commentList = container.getComments().getOrDefault(tickcount, new ArrayList());
                commentList.add(line.replace("//", ""));
                container.getComments().put(tickcount, commentList);
                continue;
            }
            String dataPart = line;
            String commentPart = "";
            if (line.contains("~&")) {
                String[] splitComments = line.split("~&");
                dataPart = splitComments[0];
                commentPart = splitComments[1];
            }
            if ((sections = dataPart.split(SectionsV1.getRegexString())).length != SectionsV1.values().length) {
                throw new IOException("Error in line " + linenumber + ". Cannot read the line correctly");
            }
            container.getInputs().add(new TickInputContainer(this.readTicks(sections[0], linenumber), this.readKeyboard(sections[1], linenumber), this.readMouse(sections[2], linenumber), this.readSubtick(sections[3], linenumber)));
            if (oldmonfileLoaded || (commentData = commentPart.split("Monitoring:")).length != 2) continue;
            monitorLines.add(commentData[1]);
        }
        container.setAuthors(author);
        container.setTitle(title);
        container.setPlaytime(playtime);
        container.setRerecords(rerecords);
        container.setStartLocation(startLocation);
        container.setStartSeed(startSeed);
        if (!monitorLines.isEmpty()) {
            container.dMonitor.setPos(monitorLines);
        }
        if (oldmonfileLoaded) {
            this.saveToFileV1(file, container);
        }
        return container;
    }

    private int readTicks(String section, int linenumber) throws IOException {
        int ticks = 0;
        try {
            ticks = Integer.parseInt(section);
        }
        catch (NumberFormatException e) {
            throw new IOException(section + " is not a recognised number in line " + linenumber);
        }
        return ticks;
    }

    private VirtualKeyboard readKeyboard(String section, int linenumber) throws IOException {
        VirtualKeyboard keyboard = new VirtualKeyboard();
        String[] keys = (section = section.replace("Keyboard:", "")).split(";");
        if (keys.length == 0) {
            return keyboard;
        }
        if (!keys[0].isEmpty()) {
            String[] splitKeys;
            for (String key : splitKeys = keys[0].split(",")) {
                VirtualKey vkey = null;
                vkey = this.isNumeric(key) ? keyboard.get(Integer.parseInt(key)) : keyboard.get(key);
                if (vkey == null) {
                    throw new IOException(key + " is not a recognised keyboard key in line " + linenumber);
                }
                vkey.setPressed(true);
            }
        }
        char[] chars = new char[]{};
        if (keys.length == 2) {
            chars = keys[1].replace("\\n", "\n").toCharArray();
        }
        for (char onechar : chars) {
            keyboard.addChar(onechar);
        }
        return keyboard;
    }

    private VirtualMouse readMouse(String section, int linenumber) throws IOException {
        VirtualMouse mouse = new VirtualMouse();
        section = section.replace("Mouse:", "");
        String buttons = section.split(";")[0];
        String path = section.split(";")[1];
        if (!buttons.isEmpty()) {
            String[] splitButtons;
            for (String button : splitButtons = buttons.split(",")) {
                VirtualKey vkey = null;
                vkey = this.isNumeric(button) ? mouse.get(Integer.parseInt(button)) : mouse.get(button);
                if (vkey == null) {
                    throw new IOException(button + " is not a recognised mouse key in line " + linenumber);
                }
                mouse.get(button).setPressed(true);
            }
        }
        mouse.setPath(this.readPath(path, linenumber, mouse));
        return mouse;
    }

    private List<VirtualMouse.PathNode> readPath(String section, int linenumber, VirtualMouse mouse) throws IOException {
        String[] pathNodes;
        ArrayList<VirtualMouse.PathNode> path = new ArrayList<VirtualMouse.PathNode>();
        section = section.replace("[", "").replace("]", "");
        for (String pathNode : pathNodes = section.split("->")) {
            String[] split = pathNode.split(",");
            int length = split.length;
            int scrollWheel = 0;
            int cursorX = 0;
            int cursorY = 0;
            try {
                scrollWheel = Integer.parseInt(split[length - 3]);
                cursorX = Integer.parseInt(split[length - 2]);
                cursorY = Integer.parseInt(split[length - 1]);
            }
            catch (NumberFormatException e) {
                throw new IOException("'" + pathNode + "' couldn't be read in line " + linenumber + ": Something is not a number");
            }
            catch (ArrayIndexOutOfBoundsException e) {
                throw new IOException("'" + pathNode + "' couldn't be read in line " + linenumber + ": Something is missing or is too much");
            }
            VirtualMouse.PathNode node = new VirtualMouse.PathNode(mouse);
            for (int i = 0; i < length - 3; ++i) {
                String key = split[i];
                node.get(key).setPressed(true);
            }
            node.scrollwheel = scrollWheel;
            node.cursorX = cursorX;
            node.cursorY = cursorY;
            path.add(node);
        }
        return path;
    }

    private VirtualSubticks readSubtick(String section, int linenumber) throws IOException {
        section = section.replace("Camera:", "");
        String[] split = section.split(";");
        float x = 0.0f;
        float y = 0.0f;
        try {
            x = Float.parseFloat(split[0]);
            y = Float.parseFloat(split[1]);
        }
        catch (NumberFormatException e) {
            throw new IOException(split[0] + " or/and " + split[1] + " are not float numbers in line " + linenumber);
        }
        return new VirtualSubticks(x, y);
    }

    private boolean isNumeric(String in) {
        try {
            Integer.parseInt(in);
        }
        catch (NumberFormatException e) {
            return false;
        }
        return true;
    }

    public static enum SectionsV1 {
        TICKS("Ticks", ""),
        KEYBOARD("Keyboard", "(\\|Keyboard:)"),
        MOUSE("Mouse", "(\\|Mouse:)"),
        CAMERA("Camera", "(\\|Camera:)");

        private String name;
        private String regex;

        private SectionsV1(String nameIn, String regexIn) {
            this.name = nameIn;
            this.regex = regexIn;
        }

        public String getName() {
            return this.name;
        }

        public String getRegex() {
            return this.regex;
        }

        public static String getRegexString() {
            String out = "";
            for (SectionsV1 section : SectionsV1.values()) {
                if (section.getRegex().isEmpty()) continue;
                String seperator = "|";
                if (SectionsV1.values().length - 1 == section.ordinal()) {
                    seperator = "";
                }
                out = out.concat(section.getRegex() + seperator);
            }
            return out;
        }
    }
}

