/*
 * Decompiled with CFR 0.152.
 */
package com.minecrafttas.tasmod.util;

import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiMultiplayer;
import net.minecraft.client.gui.GuiWorldSelection;
import net.minecraft.client.gui.ScaledResolution;
import net.minecraft.client.gui.inventory.GuiContainer;
import net.minecraft.client.gui.inventory.GuiContainerCreative;
import org.lwjgl.LWJGLException;
import org.lwjgl.opengl.Display;
import org.lwjgl.opengl.DisplayMode;

public class PointerNormalizer {
    public static int getNormalizedX(int pointerX) {
        Minecraft mc = Minecraft.func_71410_x();
        ScaledResolution scaled = new ScaledResolution(mc);
        int out = (int)((double)pointerX - (double)scaled.func_78326_a() / 2.0);
        return out;
    }

    public static int getNormalizedY(int pointerY) {
        Minecraft mc = Minecraft.func_71410_x();
        ScaledResolution scaled = new ScaledResolution(mc);
        int out = pointerY;
        if (mc.field_71462_r instanceof GuiContainer || mc.field_71462_r instanceof GuiContainerCreative) {
            out = (int)((double)pointerY - (double)scaled.func_78328_b() / 2.0);
        } else if (!(mc.field_71462_r instanceof GuiWorldSelection) && !(mc.field_71462_r instanceof GuiMultiplayer)) {
            out = pointerY - (scaled.func_78328_b() / 4 + 72 + -16);
        }
        return out;
    }

    public static int getCoordsX(int normalizedX) {
        Minecraft mc = Minecraft.func_71410_x();
        ScaledResolution scaled = new ScaledResolution(mc);
        int out = (int)Math.round((double)normalizedX + (double)scaled.func_78326_a() / 2.0);
        return PointerNormalizer.limiterX(out, scaled);
    }

    public static int getCoordsY(int normalizedY) {
        Minecraft mc = Minecraft.func_71410_x();
        ScaledResolution scaled = new ScaledResolution(mc);
        int out = normalizedY;
        if (mc.field_71462_r instanceof GuiContainer || mc.field_71462_r instanceof GuiContainerCreative) {
            out = (int)Math.round((double)normalizedY + (double)scaled.func_78328_b() / 2.0);
        } else if (!(mc.field_71462_r instanceof GuiWorldSelection) && !(mc.field_71462_r instanceof GuiMultiplayer)) {
            out = normalizedY + (scaled.func_78328_b() / 4 + 72 + -16);
        }
        return PointerNormalizer.limiterY(out, scaled);
    }

    private static int limiterX(int out, ScaledResolution scaled) {
        int width = scaled.func_78326_a();
        if (out > width) {
            out = width;
        } else if (out < 0) {
            out = 0;
        }
        return out;
    }

    private static int limiterY(int out, ScaledResolution scaled) {
        int height = scaled.func_78328_b();
        if (out > height) {
            out = height;
        } else if (out < 0) {
            out = 0;
        }
        return out;
    }

    private static int gcd(int a, int b) {
        return b == 0 ? a : PointerNormalizer.gcd(b, a % b);
    }

    public static void printAspectRatio() {
        int width = Minecraft.func_71410_x().field_71443_c;
        int height = Minecraft.func_71410_x().field_71440_d;
        int gcd = PointerNormalizer.gcd(width, height);
        if (gcd == 0) {
            System.out.println(gcd);
        } else {
            System.out.println(width / gcd + ":" + height / gcd);
        }
    }

    public static void resize(int width, int height) {
        double temp = (double)width / (double)height;
        int newHeight = Minecraft.func_71410_x().field_71440_d;
        int newWidth = (int)(temp * (double)newHeight);
        try {
            Display.setDisplayMode((DisplayMode)new DisplayMode(newWidth, newHeight));
        }
        catch (LWJGLException e) {
            e.printStackTrace();
        }
        Minecraft.func_71410_x().field_71440_d = newHeight;
        Minecraft.func_71410_x().field_71443_c = newWidth;
        Minecraft.func_71410_x().func_71370_a(newWidth, newHeight);
        Display.setResizable((boolean)false);
        Display.setResizable((boolean)true);
        Minecraft.func_71410_x().func_175601_h();
    }
}

