/*
 * Decompiled with CFR 0.152.
 */
package com.minecrafttas.tasmod.virtual;

import com.minecrafttas.tasmod.ClientProxy;
import com.minecrafttas.tasmod.TASmod;
import com.minecrafttas.tasmod.events.OpenGuiEvents;
import com.minecrafttas.tasmod.inputcontainer.InputContainer;
import com.minecrafttas.tasmod.inputcontainer.TASstate;
import com.minecrafttas.tasmod.inputcontainer.TickInputContainer;
import com.minecrafttas.tasmod.mixin.accessors.AccessorRunStuff;
import com.minecrafttas.tasmod.util.PointerNormalizer;
import com.minecrafttas.tasmod.virtual.VirtualKey;
import com.minecrafttas.tasmod.virtual.VirtualKeybindings;
import com.minecrafttas.tasmod.virtual.VirtualKeyboard;
import com.minecrafttas.tasmod.virtual.VirtualKeyboardEvent;
import com.minecrafttas.tasmod.virtual.VirtualMouse;
import com.minecrafttas.tasmod.virtual.VirtualMouseEvent;
import com.minecrafttas.tasmod.virtual.VirtualSubticks;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import net.minecraft.client.Minecraft;

public class VirtualInput {
    private InputContainer container = new InputContainer();
    private VirtualKeyboard currentKeyboard = new VirtualKeyboard();
    private VirtualKeyboard nextKeyboard = new VirtualKeyboard();
    private List<VirtualKeyboardEvent> currentKeyboardEvents = new ArrayList<VirtualKeyboardEvent>();
    private Iterator<VirtualKeyboardEvent> currentKeyboardEventIterator = this.currentKeyboardEvents.iterator();
    private VirtualKeyboardEvent currentKeyboardEvent = null;
    private VirtualMouse currentMouse = new VirtualMouse();
    private VirtualMouse nextMouse = new VirtualMouse();
    private List<VirtualMouseEvent> currentMouseEvents = new ArrayList<VirtualMouseEvent>();
    private Iterator<VirtualMouseEvent> currentMouseEventIterator = this.currentMouseEvents.iterator();
    private VirtualMouseEvent currentMouseEvent = null;
    VirtualSubticks currentSubtick = new VirtualSubticks(0.0f, 0.0f);

    public VirtualKeyboard getCurrentKeyboard() {
        return this.currentKeyboard;
    }

    public VirtualKeyboard getNextKeyboard() {
        return this.nextKeyboard;
    }

    public VirtualInput(String fileToLoad) {
        if (fileToLoad != null) {
            try {
                this.loadInputs(fileToLoad);
                OpenGuiEvents.stateWhenOpened = TASstate.PLAYBACK;
            }
            catch (IOException e) {
                TASmod.logger.error("Cannot load inputs from the start of the TAS: {}", (Object)e.getMessage());
            }
        }
    }

    public void updateNextKeyboard(int keycode, boolean keystate, char character) {
        if (keystate) {
            character = this.nextKeyboard.encodeUnicode(keycode, character);
        } else if (keycode == 15) {
            character = (char)10503;
        }
        this.nextKeyboard.addChar(character);
        if (VirtualKeybindings.isKeyCodeAlwaysBlocked(keycode)) {
            return;
        }
        VirtualKey key = this.nextKeyboard.get(keycode);
        key.setPressed(keystate);
    }

    public List<VirtualKeyboardEvent> getCurrentKeyboardEvents() {
        return this.currentKeyboard.getDifference(this.nextKeyboard);
    }

    public void updateCurrentKeyboard() {
        this.currentKeyboardEvents = this.getCurrentKeyboardEvents();
        this.currentKeyboardEventIterator = this.currentKeyboardEvents.iterator();
        this.nextKeyboard.clearCharList();
        this.currentKeyboard = this.nextKeyboard.clone();
    }

    public boolean nextKeyboardEvent() {
        boolean hasnext = this.currentKeyboardEventIterator.hasNext();
        if (hasnext) {
            this.currentKeyboardEvent = this.currentKeyboardEventIterator.next();
        }
        return hasnext;
    }

    public int getEventKeyboardKey() {
        return this.currentKeyboardEvent.getKeyCode();
    }

    public boolean getEventKeyboardState() {
        return this.currentKeyboardEvent.isState();
    }

    public char getEventKeyboardCharacter() {
        return this.currentKeyboardEvent.getCharacter();
    }

    public void clearNextKeyboard() {
        this.nextKeyboard.clear();
    }

    public boolean isKeyDown(int keycode) {
        if (keycode >= 0) {
            return this.currentKeyboard.get(keycode).isKeyDown();
        }
        return this.currentMouse.get(keycode).isKeyDown();
    }

    public boolean isKeyDown(String keyname) {
        if (this.currentKeyboard.get(keyname).isKeyDown()) {
            return true;
        }
        return this.currentMouse.get(keyname).isKeyDown();
    }

    public boolean willKeyBeDown(int keycode) {
        if (keycode >= 0) {
            return this.nextKeyboard.get(keycode).isKeyDown();
        }
        return this.nextMouse.get(keycode).isKeyDown();
    }

    public boolean willKeyBeDown(String keyname) {
        if (this.nextKeyboard.get(keyname).isKeyDown()) {
            return true;
        }
        return this.nextMouse.get(keyname).isKeyDown();
    }

    public List<String> getCurrentKeyboardPresses() {
        ArrayList<String> out = new ArrayList<String>();
        this.currentKeyboard.getKeyList().forEach((keycodes, virtualkeys) -> {
            if (virtualkeys.isKeyDown()) {
                out.add(virtualkeys.getName());
            }
        });
        return out;
    }

    public List<String> getNextKeyboardPresses() {
        ArrayList<String> out = new ArrayList<String>();
        if (this.container.isPlayingback() && this.container.get(this.container.index()) != null) {
            this.container.get(this.container.index()).getKeyboard().getKeyList().forEach((keycodes, virtualkeys) -> {
                if (virtualkeys.isKeyDown()) {
                    out.add(virtualkeys.getName());
                }
            });
        } else {
            this.nextKeyboard.getKeyList().forEach((keycodes, virtualkeys) -> {
                if (virtualkeys.isKeyDown()) {
                    out.add(virtualkeys.getName());
                }
            });
        }
        return out;
    }

    public VirtualMouse getCurrentMouse() {
        return this.currentMouse;
    }

    public VirtualMouse getNextMouse() {
        return this.nextMouse;
    }

    public void updateNextMouse(int keycode, boolean keystate, int scrollwheel, int cursorX, int cursorY, boolean filter) {
        boolean flag = true;
        if (filter) {
            flag = this.nextMouse.isSomethingDown() || scrollwheel != 0 || keycode != -1;
        }
        VirtualKey key = this.nextMouse.get(keycode - 100);
        if (VirtualKeybindings.isKeyCodeAlwaysBlocked(keycode - 100)) {
            key.setPressed(false);
            return;
        }
        key.setPressed(keystate);
        this.nextMouse.setScrollWheel(scrollwheel);
        this.nextMouse.setCursor(PointerNormalizer.getNormalizedX(cursorX), PointerNormalizer.getNormalizedY(cursorY));
        if (flag) {
            this.nextMouse.addPathNode();
        }
    }

    public List<VirtualMouseEvent> getCurrentMouseEvents() {
        return this.currentMouse.getDifference(this.nextMouse);
    }

    public void updateCurrentMouseEvents() {
        this.currentMouseEvents = this.getCurrentMouseEvents();
        this.currentMouseEventIterator = this.currentMouseEvents.iterator();
        this.resetNextMouseLists();
        this.currentMouse = this.nextMouse.clone();
    }

    public void resetNextMouseLists() {
        this.nextMouse.resetPath();
    }

    public boolean nextMouseEvent() {
        boolean hasnext = this.currentMouseEventIterator.hasNext();
        if (hasnext) {
            this.currentMouseEvent = this.currentMouseEventIterator.next();
        }
        return hasnext;
    }

    public int getEventMouseKey() {
        return this.currentMouseEvent.getKeyCode();
    }

    public boolean getEventMouseState() {
        return this.currentMouseEvent.isState();
    }

    public int getEventMouseScrollWheel() {
        return this.currentMouseEvent.getScrollwheel();
    }

    public int getEventCursorX() {
        return PointerNormalizer.getCoordsX(this.currentMouseEvent.getMouseX());
    }

    public int getEventCursorY() {
        return PointerNormalizer.getCoordsY(this.currentMouseEvent.getMouseY());
    }

    public void clearNextMouse() {
        this.nextMouse.clear();
    }

    public List<String> getCurrentMousePresses() {
        ArrayList<String> out = new ArrayList<String>();
        this.currentMouse.getKeyList().forEach((keycodes, virtualkeys) -> {
            if (virtualkeys.isKeyDown()) {
                out.add(virtualkeys.getName());
            }
        });
        return out;
    }

    public List<String> getNextMousePresses() {
        ArrayList<String> out = new ArrayList<String>();
        if (this.container.isPlayingback() && this.container.get(this.container.index()) != null) {
            this.container.get(this.container.index()).getMouse().getKeyList().forEach((keycodes, virtualkeys) -> {
                if (virtualkeys.isKeyDown()) {
                    out.add(virtualkeys.getName());
                }
            });
        } else {
            this.nextMouse.getKeyList().forEach((keycodes, virtualkeys) -> {
                if (virtualkeys.isKeyDown()) {
                    out.add(virtualkeys.getName());
                }
            });
        }
        return out;
    }

    public void unpressEverything() {
        this.container.unpressContainer();
        this.unpressNext();
    }

    public void unpressNext() {
        this.clearNextKeyboard();
        this.clearNextMouse();
    }

    public void updateSubtick(float pitch, float yaw) {
        this.currentSubtick = this.container.addSubticksToContainer(new VirtualSubticks(pitch, yaw));
    }

    public float getSubtickPitch() {
        return this.currentSubtick.getPitch();
    }

    public float getSubtickYaw() {
        return this.currentSubtick.getYaw();
    }

    public InputContainer getContainer() {
        return this.container;
    }

    public void updateContainer() {
        this.nextKeyboard = this.container.addKeyboardToContainer(this.nextKeyboard);
        this.nextMouse = this.container.addMouseToContainer(this.nextMouse);
    }

    public void setContainer(InputContainer container) {
        this.container = container;
    }

    public void loadClientSavestate(InputContainer savestatecontainer) {
        if (this.container.isPlayingback()) {
            this.preloadInput(this.container, savestatecontainer.size() - 1);
            if (this.container.size() >= savestatecontainer.size()) {
                try {
                    this.container.setIndex(savestatecontainer.size());
                }
                catch (IndexOutOfBoundsException e) {
                    e.printStackTrace();
                }
            } else {
                String start = savestatecontainer.getStartLocation();
                savestatecontainer.setStartLocation("");
                try {
                    savestatecontainer.setIndex(savestatecontainer.size() - 1);
                }
                catch (IndexOutOfBoundsException e) {
                    e.printStackTrace();
                }
                savestatecontainer.setTASState(TASstate.PLAYBACK);
                savestatecontainer.setStartLocation(start);
                this.container = savestatecontainer;
            }
        } else if (this.container.isRecording()) {
            String start = savestatecontainer.getStartLocation();
            this.preloadInput(savestatecontainer, savestatecontainer.size() - 1);
            this.nextKeyboard = new VirtualKeyboard();
            this.nextMouse = new VirtualMouse();
            try {
                savestatecontainer.setIndex(savestatecontainer.size());
            }
            catch (IndexOutOfBoundsException e) {
                e.printStackTrace();
            }
            savestatecontainer.setTASState(TASstate.RECORDING);
            savestatecontainer.setStartLocation(start);
            this.container = savestatecontainer;
        }
    }

    private void preloadInput(InputContainer container, int index) {
        TickInputContainer tickcontainer = container.get(index);
        if (tickcontainer != null) {
            tickcontainer = tickcontainer.clone();
            this.nextKeyboard = tickcontainer.getKeyboard().clone();
            this.nextMouse = tickcontainer.getMouse().clone();
            ((AccessorRunStuff)Minecraft.func_71410_x()).runTickKeyboardAccessor();
            ((AccessorRunStuff)Minecraft.func_71410_x()).runTickMouseAccessor();
        } else {
            TASmod.logger.warn("Can't preload inputs, specified inputs are null!");
        }
    }

    public void loadInputs(String filename) throws IOException {
        this.setContainer(ClientProxy.serialiser.fromEntireFileV1(new File(ClientProxy.tasdirectory + "/" + filename + ".tas")));
        this.getContainer().fixTicks();
    }

    public void saveInputs(String filename) throws IOException {
        ClientProxy.createTASDir();
        ClientProxy.serialiser.saveToFileV1(new File(ClientProxy.tasdirectory + "/" + filename + ".tas"), ClientProxy.virtual.getContainer());
    }

    public List<InputEvent> getAllInputEvents() {
        ArrayList<InputEvent> main = new ArrayList<InputEvent>();
        for (int i = 0; i < this.container.size(); ++i) {
            TickInputContainer tick = this.container.get(i);
            TickInputContainer nextTick = this.container.get(i + 1);
            if (nextTick == null) {
                nextTick = new TickInputContainer(i + 1);
            }
            VirtualKeyboard keyboard = tick.getKeyboard();
            List<VirtualKeyboardEvent> keyboardEventsList = keyboard.getDifference(nextTick.getKeyboard());
            VirtualMouse mouse = tick.getMouse();
            List<VirtualMouseEvent> mouseEventsList = mouse.getDifference(nextTick.getMouse());
            main.add(new InputEvent(tick.getTick(), keyboardEventsList, mouseEventsList, tick.getSubticks()));
        }
        return main;
    }

    public class InputEvent {
        public int tick;
        public List<VirtualKeyboardEvent> keyboardevent;
        public List<VirtualMouseEvent> mouseEvent;
        public VirtualSubticks subticks;

        public InputEvent(int tick, List<VirtualKeyboardEvent> keyboardevent, List<VirtualMouseEvent> mouseEvent, VirtualSubticks subticks) {
            this.tick = tick;
            this.keyboardevent = keyboardevent;
            this.mouseEvent = mouseEvent;
            this.subticks = subticks;
        }
    }
}

